/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.adapters;

import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentLifecycle;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.AbstractAdapter;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;

public final class InstanceAdapter<T>
extends AbstractAdapter<T>
implements ComponentLifecycle<T>,
LifecycleStrategy {
    private final T componentInstance;
    private final LifecycleStrategy lifecycleStrategy;
    private boolean started;

    public InstanceAdapter(Object componentKey, T componentInstance, LifecycleStrategy lifecycleStrategy, ComponentMonitor componentMonitor) throws PicoCompositionException {
        super(componentKey, InstanceAdapter.getInstanceClass(componentInstance), componentMonitor);
        this.componentInstance = componentInstance;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    public InstanceAdapter(Object componentKey, T componentInstance) {
        this(componentKey, componentInstance, new NullLifecycleStrategy(), new NullComponentMonitor());
    }

    public InstanceAdapter(Object componentKey, T componentInstance, LifecycleStrategy lifecycleStrategy) {
        this(componentKey, componentInstance, lifecycleStrategy, new NullComponentMonitor());
    }

    public InstanceAdapter(Object componentKey, T componentInstance, ComponentMonitor componentMonitor) {
        this(componentKey, componentInstance, new NullLifecycleStrategy(), componentMonitor);
    }

    private static Class getInstanceClass(Object componentInstance) {
        if (componentInstance == null) {
            throw new NullPointerException("componentInstance cannot be null");
        }
        return componentInstance.getClass();
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) {
        return this.componentInstance;
    }

    @Override
    public void verify(PicoContainer container) {
    }

    @Override
    public String getDescriptor() {
        return "Instance-";
    }

    @Override
    public String toString() {
        Object componentKey = this.getComponentKey();
        if (componentKey instanceof Class) {
            componentKey = "of " + ((Class)componentKey).getName();
        }
        return this.getDescriptor() + componentKey;
    }

    @Override
    public void start(PicoContainer container) {
        this.start(this.componentInstance);
    }

    @Override
    public void stop(PicoContainer container) {
        this.stop(this.componentInstance);
    }

    @Override
    public void dispose(PicoContainer container) {
        this.dispose(this.componentInstance);
    }

    @Override
    public boolean componentHasLifecycle() {
        return this.hasLifecycle(this.componentInstance.getClass());
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start(Object component) {
        this.lifecycleStrategy.start(this.componentInstance);
        this.started = true;
    }

    @Override
    public void stop(Object component) {
        this.lifecycleStrategy.stop(this.componentInstance);
        this.started = false;
    }

    @Override
    public void dispose(Object component) {
        this.lifecycleStrategy.dispose(this.componentInstance);
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        return this.lifecycleStrategy.hasLifecycle(type);
    }

    @Override
    public boolean isLazy(ComponentAdapter<?> adapter) {
        return this.lifecycleStrategy.isLazy(adapter);
    }
}

