/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.SystemInfo;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.core.i18n.LanguageManager;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSParameter;
import com.logicaldoc.webservice.model.WSSystemInfo;
import com.logicaldoc.webservice.soap.SystemService;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapSystemService
extends AbstractService
implements SystemService {
    private static final Logger log = LoggerFactory.getLogger(SoapSystemService.class);

    @Override
    public List<WSParameter> getStatistics(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        return this.getTenantStatistics(sid, -1L);
    }

    @Override
    public List<WSParameter> getTenantStatistics(String sid, long tenantId) throws AuthenticationException, WebserviceException, PersistenceException {
        this.validateSession(sid);
        ArrayList<WSParameter> parameters = new ArrayList<WSParameter>();
        try {
            parameters.add(this.getStat("docdir", "repo_storage", tenantId));
            parameters.add(this.getStat("userdir", "repo_users", -1L));
            parameters.add(this.getStat("indexdir", "repo_fulltextindex", -1L));
            parameters.add(this.getStat("importdir", "repo_import", -1L));
            parameters.add(this.getStat("exportdir", "repo_export", -1L));
            parameters.add(this.getStat("plugindir", "repo_plugins", -1L));
            parameters.add(this.getStat("dbdir", "repo_database", -1L));
            parameters.add(this.getStat("logdir", "repo_logs", -1L));
            parameters.add(this.getStat("notindexeddocs", "docs_notindexed", tenantId));
            parameters.add(this.getStat("notindexabledocs", "docs_notindexable", tenantId));
            parameters.add(this.getStat("indexeddocs", "docs_indexed", tenantId));
            parameters.add(this.getStat("deleteddocs", "docs_trash", tenantId));
            parameters.add(this.getStat("archiveddocs", "docs_archived", tenantId));
            parameters.add(this.getStat("totaldocs", "docs_total", tenantId));
            parameters.add(this.getStat("withdocs", "folder_withdocs", tenantId));
            parameters.add(this.getStat("empty", "folder_empty", tenantId));
            parameters.add(this.getStat("deletedfolders", "folder_trash", tenantId));
            UserDAO userDao = Context.get(UserDAO.class);
            WSParameter users = new WSParameter();
            users.setName("users_regular");
            users.setValue(Long.toString(userDao.count(tenantId != -1L ? Long.valueOf(tenantId) : null)));
            parameters.add(users);
            WSParameter readonly = new WSParameter();
            readonly.setName("users_readonly");
            readonly.setValue(Long.toString(userDao.countGuests(tenantId != -1L ? Long.valueOf(tenantId) : null)));
            parameters.add(readonly);
            GenericDAO genDao = Context.get(GenericDAO.class);
            Generic gen = genDao.findByAlternateKey("stat", "lastrun", null, -1L);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            WSParameter lastrun = new WSParameter();
            lastrun.setName("stats_lastrun");
            if (gen.getDate1() != null) {
                lastrun.setValue(df.format(gen.getDate1()));
            } else {
                lastrun.setValue("");
            }
            parameters.add(lastrun);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return parameters;
    }

    private WSParameter getStat(String statSubtype, String paramName, long tenantId) throws PersistenceException {
        GenericDAO genDao = Context.get(GenericDAO.class);
        Generic gen = genDao.findByAlternateKey("stat", statSubtype, null, tenantId);
        WSParameter parameter = new WSParameter();
        parameter.setName(paramName);
        if (gen != null) {
            parameter.setValue(Long.toString(gen.getInteger1()));
        } else {
            parameter.setValue("0");
        }
        return parameter;
    }

    @Override
    public List<String> getLanguages(String tenantOrSid) {
        ArrayList<String> langs = new ArrayList<String>();
        String t = "default";
        if (tenantOrSid != null) {
            t = SessionManager.get().get(tenantOrSid) != null ? SessionManager.get().get(tenantOrSid).getTenantName() : tenantOrSid;
        }
        try {
            for (Language lang : LanguageManager.getInstance().getActiveLanguages(t)) {
                langs.add(lang.getLocale().toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return langs;
    }

    @Override
    public WSSystemInfo getInfo() throws WebserviceException {
        try {
            SystemInfo info = SystemInfo.get();
            WSSystemInfo wsInfo = new WSSystemInfo();
            BeanUtils.copyProperties((Object)wsInfo, (Object)info);
            wsInfo.setFeatures(new ArrayList<String>(info.getFeatures()));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            wsInfo.setDate(df.format(info.getDate()));
            return wsInfo;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new WebserviceException(e.getMessage(), e);
        }
    }
}

