/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderComparator;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderEvent;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.model.WSUtil;
import com.logicaldoc.webservice.soap.FolderService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapFolderService
extends AbstractService
implements FolderService {
    private static final String FOLDER = "Folder ";
    private static final String NOT_ALLOWED = "Not Allowed";
    private static final String NO_CHANGES = "No Changes";
    private static final String CANNOT_MOVE_FOLDERS_IN_THE_ROOT = "Cannot move folders in the root";
    private static final Logger log = LoggerFactory.getLogger(SoapFolderService.class);

    @Override
    public WSFolder create(String sid, WSFolder wsFolder) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder parentFolder = (Folder)folderDao.findById(wsFolder.getParentId());
        if (parentFolder == null) {
            throw new WebserviceException(String.format("A parent folder with id %s was not found.", wsFolder.getParentId()));
        }
        this.checkFolderPermission(Permission.ADD, user, wsFolder.getParentId());
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        transaction.setSessionId(sid);
        Folder folderVO = new Folder();
        folderVO.setTenantId(user.getTenantId());
        folderVO.setName(wsFolder.getName());
        folderVO.setDescription(wsFolder.getDescription());
        folderVO.setType(wsFolder.getType());
        folderVO.setPosition(wsFolder.getPosition());
        folderVO.setTemplateLocked(wsFolder.getTemplateLocked());
        folderVO.setHidden(wsFolder.getHidden());
        folderVO.setFoldRef(wsFolder.getFoldRef());
        folderVO.setStore(wsFolder.getStore());
        folderVO.setMaxVersions(wsFolder.getMaxVersions());
        folderVO.setSecurityRef(wsFolder.getSecurityRef());
        folderVO.setFoldRef(wsFolder.getFoldRef());
        folderVO.setOcrTemplateId(wsFolder.getOcrTemplateId());
        folderVO.setBarcodeTemplateId(wsFolder.getBarcodeTemplateId());
        folderVO.setColor(wsFolder.getColor());
        folderVO.setTile(wsFolder.getTile());
        folderVO.setTagsFromWords(Set.copyOf(wsFolder.getTags()));
        wsFolder.updateAttributes(folderVO);
        Folder f = folderDao.create(parentFolder, folderVO, true, transaction);
        if (f == null) {
            log.error("Folder {} not created", (Object)folderVO.getName());
            throw new WebserviceException("error");
        }
        WSFolder createdFolder = WSFolder.fromFolder(f);
        log.info("Created folder {}", (Object)createdFolder.getName());
        return createdFolder;
    }

    @Override
    public WSFolder createAlias(String sid, long parentId, long foldRef) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder parentFolder = folderDao.findFolder(parentId);
        if (parentFolder == null) {
            throw new WebserviceException(String.format("A parent folder with id %s was not found.", parentId));
        }
        this.checkFolderPermission(Permission.ADD, user, parentFolder.getId());
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        transaction.setSessionId(sid);
        Folder f = folderDao.createAlias(parentFolder.getId(), foldRef, transaction);
        WSFolder createdFolder = WSFolder.fromFolder(f);
        log.info("Created folder {}", (Object)createdFolder.getName());
        return createdFolder;
    }

    @Override
    public long createFolder(String sid, long parentId, String name) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WSFolder folder = new WSFolder();
        folder.setParentId(parentId);
        folder.setName(name);
        folder.setType(0);
        return this.create(sid, folder).getId();
    }

    @Override
    public void delete(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        long rootId = folderDao.findRoot(user.getTenantId()).getTenantId();
        if (folderId == rootId) {
            throw new WebserviceException("Cannot delete root folder or Default workspace");
        }
        this.checkFolderPermission(Permission.DELETE, user, folderId);
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        transaction.setEvent(FolderEvent.DELETED);
        transaction.setSessionId(sid);
        folderDao.deleteTree(folderId, transaction);
    }

    @Override
    public WSFolder getFolder(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        this.checkFolderPermission(Permission.READ, user, folderId);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folder = (Folder)folderDao.findById(folderId);
        if (folder == null) {
            return null;
        }
        folderDao.initialize(folder);
        return WSFolder.fromFolder(folder);
    }

    @Override
    public WSFolder findByPath(String sid, String path) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folder = folderDao.findByPathExtended(path, user.getTenantId());
        if (folder == null) {
            return null;
        }
        folderDao.initialize(folder);
        this.checkFolderPermission(Permission.READ, user, folder.getId());
        return WSFolder.fromFolder(folder);
    }

    @Override
    public boolean isReadable(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        try {
            this.checkFolderPermission(Permission.READ, user, folderId);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public List<WSFolder> list(String sid, long folderId, String sort, Integer page, Integer max) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        this.checkFolderPermission(Permission.READ, user, folderId);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        List<Folder> folders = folderDao.findChildren(folderId, user.getId());
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            Collections.sort(folders, FolderComparator.getComparator(sort));
        }
        if (max != null && page != null && max < folders.size()) {
            folders = folders.stream().skip((long)(page - 1) * (long)max.intValue()).limit(max.intValue()).collect(Collectors.toList());
        }
        ArrayList<WSFolder> wsFolders = new ArrayList<WSFolder>();
        for (Folder folder : folders) {
            if (folder.getHidden() != 0) continue;
            folderDao.initialize(folder);
            wsFolders.add(WSFolder.fromFolder(folder));
        }
        return wsFolders;
    }

    @Override
    public List<WSFolder> listChildren(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        return this.list(sid, folderId, "name asc", null, null);
    }

    @Override
    public void move(String sid, long folderId, long parentId) throws PersistenceException, AuthenticationException, WebserviceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        if (parentId == folderDao.findRoot(user.getTenantId()).getId()) {
            String message = CANNOT_MOVE_FOLDERS_IN_THE_ROOT;
            log.error(message);
            throw new WebserviceException(message);
        }
        Folder destParentFolder = (Folder)folderDao.findById(parentId);
        Folder folderToMove = (Folder)folderDao.findById(folderId);
        if (parentId == folderToMove.getParentId()) {
            throw new SecurityException(NO_CHANGES);
        }
        if (parentId == folderToMove.getId()) {
            throw new SecurityException(NOT_ALLOWED);
        }
        Folder sourceParent = (Folder)folderDao.findById(folderToMove.getParentId());
        boolean sourceParentDeleteEnabled = folderDao.isPermissionAllowed(Permission.DELETE, sourceParent.getId(), user.getId());
        if (!sourceParentDeleteEnabled) {
            throw new SecurityException("No rights to delete folder");
        }
        this.checkFolderPermission(Permission.ADD, user, destParentFolder.getId());
        FolderHistory transaction = new FolderHistory();
        transaction.setSessionId(sid);
        transaction.setUser(user);
        folderDao.move(folderToMove, destParentFolder, transaction);
    }

    @Override
    public void copy(String sid, long folderId, long targetId, int foldersOnly, String securityOption) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        if (targetId == folderDao.findRoot(user.getTenantId()).getId()) {
            String message = CANNOT_MOVE_FOLDERS_IN_THE_ROOT;
            log.error(message);
            throw new WebserviceException(message);
        }
        Folder destTargetFolder = (Folder)folderDao.findById(targetId);
        Folder folderToCopy = (Folder)folderDao.findById(folderId);
        if (targetId == folderToCopy.getParentId()) {
            throw new SecurityException(NO_CHANGES);
        }
        if (targetId == folderToCopy.getId()) {
            throw new SecurityException(NOT_ALLOWED);
        }
        this.checkFolderPermission(Permission.ADD, user, destTargetFolder.getId());
        FolderHistory transaction = new FolderHistory();
        transaction.setSessionId(sid);
        transaction.setUser(user);
        folderDao.copy(folderToCopy, destTargetFolder, null, 1 == foldersOnly, securityOption, transaction);
    }

    @Override
    public void rename(String sid, long folderId, String name) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        if (!folderDao.isPermissionAllowed(Permission.RENAME, folderId, user.getId())) {
            throw new PermissionException(user.getUsername(), FOLDER + folderId, Permission.RENAME);
        }
        long rootId = folderDao.findRoot(user.getTenantId()).getId();
        if (folderId == rootId) {
            throw new WebserviceException("cannot rename the root folder");
        }
        Folder folder = (Folder)folderDao.findById(folderId);
        if (folder == null) {
            throw new WebserviceException(String.format("cannot find folder %s", folderId));
        }
        folderDao.initialize(folder);
        List<Folder> folders = folderDao.findByNameAndParentId(name, folder.getParentId());
        if (CollectionUtils.isNotEmpty(folders)) {
            throw new WebserviceException(String.format("duplicate folder name %s", name));
        }
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        transaction.setEvent(FolderEvent.RENAMED);
        transaction.setSessionId(sid);
        transaction.setFilenameOld(folder.getName());
        transaction.setPathOld(folderDao.computePathExtended(folderId));
        folder.setName(name);
        folderDao.store(folder, transaction);
    }

    @Override
    public WSFolder getRootFolder(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folder = folderDao.findRoot(user.getTenantId());
        folderDao.initialize(folder);
        return WSFolder.fromFolder(folder);
    }

    @Override
    public WSFolder getDefaultWorkspace(String sid) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        return this.getFolder(sid, folderDao.findDefaultWorkspace(user.getTenantId()).getId());
    }

    @Override
    public boolean isWritable(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        return folderDao.isWriteAllowed(folderId, user.getId());
    }

    @Override
    public boolean isGranted(String sid, long folderId, String permission) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        try {
            this.checkFolderPermission(Permission.valueOf(permission), user, folderId);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public List<WSFolder> getPath(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        this.checkFolderPermission(Permission.READ, user, folderId);
        ArrayList<WSFolder> path = new ArrayList<WSFolder>();
        FolderDAO folderDao = Context.get(FolderDAO.class);
        long rootId = folderDao.findRoot(user.getTenantId()).getId();
        if (folderId == rootId) {
            path.add(this.getRootFolder(sid));
        } else {
            List<Folder> folders = folderDao.findParents(folderId);
            for (Folder folder : folders) {
                folderDao.initialize(folder);
                WSFolder wsFolder = WSFolder.fromFolder(folder);
                path.add(wsFolder);
            }
            Folder f = (Folder)folderDao.findById(folderId);
            folderDao.initialize(f);
            WSFolder wsFolder = WSFolder.fromFolder(f);
            path.add(wsFolder);
        }
        return path;
    }

    @Override
    public void setAccessControlList(String sid, long folderId, List<WSAccessControlEntry> acl) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException {
        User sessionUser = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        if (!folderDao.isPermissionAllowed(Permission.SECURITY, folderId, sessionUser.getId())) {
            throw new PermissionException(sessionUser.getUsername(), FOLDER + folderId, Permission.SECURITY);
        }
        Folder folder = (Folder)folderDao.findById(folderId);
        folderDao.initialize(folder);
        folder.setSecurityRef(null);
        folder.getAccessControlList().clear();
        for (WSAccessControlEntry wsAcwe : acl) {
            folder.addAccessControlEntry(WSUtil.toFolderAccessControlEntry(wsAcwe));
        }
        FolderHistory history = new FolderHistory();
        history.setEvent(FolderEvent.PERMISSION);
        history.setSession(SessionManager.get().get(sid));
        folderDao.store(folder, history);
    }

    @Override
    public List<WSAccessControlEntry> getAccessControlList(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        this.validateSession(sid);
        ArrayList<WSAccessControlEntry> acl = new ArrayList<WSAccessControlEntry>();
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder folder = (Folder)folderDao.findById(folderId);
        if (folder.getSecurityRef() != null) {
            folder = (Folder)folderDao.findById(folder.getSecurityRef());
        }
        folderDao.initialize(folder);
        for (AccessControlEntry accessControlEntry : folder.getAccessControlList()) {
            acl.add(WSUtil.toWSAccessControlEntry(accessControlEntry));
        }
        return acl;
    }

    @Override
    public void update(String sid, WSFolder wsFolder) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        long folderId = wsFolder.getId();
        String name = wsFolder.getName();
        FolderDAO folderDao = Context.get(FolderDAO.class);
        if (!folderDao.isPermissionAllowed(Permission.RENAME, folderId, user.getId())) {
            throw new PermissionException(user.getUsername(), FOLDER + folderId, Permission.RENAME);
        }
        if (folderId == folderDao.findRoot(user.getTenantId()).getId()) {
            throw new PermissionException("cannot update the root folder");
        }
        Folder folder = (Folder)folderDao.findById(folderId);
        if (folder == null) {
            throw new WebserviceException(String.format("cannot find folder %s", folderId));
        }
        String oldName = folder.getName();
        List<Folder> folders = folderDao.findByNameAndParentId(name, folder.getParentId());
        if (CollectionUtils.isNotEmpty(folders) && folders.get(0).getId() != folder.getId()) {
            throw new WebserviceException(String.format("duplicate folder name %s", name));
        }
        folderDao.initialize(folder);
        folder.setName(name);
        folder.setColor(wsFolder.getColor());
        folder.setTile(wsFolder.getTile());
        folder.setDescription(wsFolder.getDescription());
        folder.setTemplateLocked(wsFolder.getTemplateLocked());
        folder.setPosition(wsFolder.getPosition());
        folder.setSecurityRef(wsFolder.getSecurityRef());
        folder.setFoldRef(wsFolder.getFoldRef());
        folder.setOcrTemplateId(wsFolder.getOcrTemplateId());
        folder.setBarcodeTemplateId(wsFolder.getBarcodeTemplateId());
        folder.setStore(wsFolder.getStore());
        folder.setMaxVersions(wsFolder.getMaxVersions());
        folder.setTagsFromWords(new HashSet<String>(wsFolder.getTags()));
        wsFolder.updateAttributes(folder);
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        transaction.setEvent(FolderEvent.CHANGED);
        transaction.setSessionId(sid);
        folderDao.store(folder, transaction);
        if (!oldName.equals(name)) {
            FolderHistory renameHistory = new FolderHistory();
            renameHistory.setUser(user);
            renameHistory.setEvent(FolderEvent.RENAMED);
            renameHistory.setSessionId(sid);
            folderDao.saveFolderHistory(folder, renameHistory);
        }
    }

    @Override
    public WSFolder createPath(String sid, long parentId, String path) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        long rootId;
        User user = this.validateSession(sid);
        this.checkFolderPermission(Permission.ADD, user, parentId);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        Folder parent = (Folder)folderDao.findById(parentId);
        folderDao.initialize(parent);
        FolderHistory transaction = new FolderHistory();
        transaction.setUser(user);
        transaction.setEvent(FolderEvent.CREATED);
        transaction.setSessionId(sid);
        transaction.setTenantId(user.getTenantId());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (parentId == (rootId = folderDao.findRoot(user.getTenantId()).getTenantId())) {
            Folder workspace = null;
            for (WSFolder w : this.listWorkspaces(sid)) {
                if (!path.startsWith(w.getName() + "/")) continue;
                workspace = (Folder)folderDao.findById(w.getId());
                folderDao.initialize(workspace);
                break;
            }
            if (workspace == null) {
                log.debug("Path {} will be created in the Default workspace", (Object)path);
                parent = folderDao.findDefaultWorkspace(user.getTenantId());
                folderDao.initialize(parent);
            }
        }
        Folder folder = folderDao.createPath(parent, path, true, transaction);
        return WSFolder.fromFolder(folder, false);
    }

    @Override
    public List<WSFolder> listWorkspaces(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        List<Folder> folders = folderDao.findByUserId(user.getId(), folderDao.findRoot(user.getTenantId()).getId());
        ArrayList<WSFolder> wsFolders = new ArrayList<WSFolder>();
        for (Folder folder : folders) {
            if (folder.getType() != 1) continue;
            folderDao.initialize(folder);
            wsFolders.add(WSFolder.fromFolder(folder));
        }
        return wsFolders;
    }

    @Override
    public void merge(String sid, long sourceId, long targetId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        if (targetId == folderDao.findRoot(user.getTenantId()).getId()) {
            throw new PermissionException(CANNOT_MOVE_FOLDERS_IN_THE_ROOT);
        }
        Folder destTargetFolder = (Folder)folderDao.findById(targetId);
        Folder folderToCopy = (Folder)folderDao.findById(sourceId);
        if (targetId == folderToCopy.getParentId()) {
            throw new SecurityException(NO_CHANGES);
        }
        if (targetId == folderToCopy.getId()) {
            throw new SecurityException(NOT_ALLOWED);
        }
        this.checkFolderPermission(Permission.ADD, user, destTargetFolder.getId());
        this.checkFolderPermission(Permission.WRITE, user, destTargetFolder.getId());
        this.checkFolderPermission(Permission.DELETE, user, sourceId);
        FolderHistory transaction = new FolderHistory();
        transaction.setSessionId(sid);
        transaction.setUser(user);
        folderDao.merge(folderToCopy, destTargetFolder, transaction);
    }
}

