/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailAttachment;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentComparator;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.document.DocumentLink;
import com.logicaldoc.core.document.DocumentLinkDAO;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.Rating;
import com.logicaldoc.core.document.RatingDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.document.thumbnail.ThumbnailManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.ticket.Ticket;
import com.logicaldoc.util.MimeType;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSLink;
import com.logicaldoc.webservice.model.WSNote;
import com.logicaldoc.webservice.model.WSRating;
import com.logicaldoc.webservice.model.WSUtil;
import com.logicaldoc.webservice.soap.DocumentService;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapDocumentService
extends AbstractService
implements DocumentService {
    private static final String DOCUMENT_WITH_ID = "Document with ID ";
    private static final String NOT_FOUND_OR_NOT_ACCESSIBLE = " not found or not accessible";
    private static final String IS_LOCKED = " is locked";
    private static final String IS_IMMUTABLE = " is immutable";
    private static final String THE_DOCUMENT = "The document ";
    private static final Logger log = LoggerFactory.getLogger(SoapDocumentService.class);

    @Override
    public WSDocument create(String sid, WSDocument document, DataHandler content) throws IOException, AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        return this.create(sid, document, content.getInputStream());
    }

    public WSDocument create(String sid, WSDocument document, InputStream content) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        this.checkFolderPermission(Permission.WRITE, user, document.getFolderId());
        FolderDAO fdao = Context.get(FolderDAO.class);
        Folder folder = (Folder)fdao.findById(document.getFolderId());
        long rootId = fdao.findRoot(user.getTenantId()).getId();
        if (folder == null) {
            throw new WebserviceException(String.format("Folder %d not found", document.getFolderId()));
        }
        if (folder.getId() == rootId) {
            throw new WebserviceException("Cannot add documents in the root");
        }
        Document doc = WSUtil.toDocument(document);
        doc.setTenantId(user.getTenantId());
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.STORED);
        transaction.setComment(document.getComment());
        transaction.setUser(user);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        doc = documentManager.create(content, doc, transaction).getDocument();
        return WSUtil.toWSDocument(doc);
    }

    public void checkinDocument(String sid, long docId, String comment, String filename, boolean release, WSDocument docVO, InputStream content) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        this.checkin(sid, docId, comment, filename, release, docVO, content);
    }

    @Override
    public void checkinDocument(String sid, long docId, String comment, String filename, boolean release, WSDocument docVO, DataHandler content) throws IOException, AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        this.checkin(sid, docId, comment, filename, release, docVO, content.getInputStream());
    }

    @Override
    public void checkin(String sid, long docId, String comment, String filename, boolean release, DataHandler content) throws IOException, AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        this.checkin(sid, docId, comment, filename, release, null, content.getInputStream());
    }

    public void checkin(String sid, long docId, String comment, String filename, boolean release, WSDocument docVO, InputStream content) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        Document doc;
        DocumentHistory transaction;
        User user = this.validateSession(sid);
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        Document document = (Document)ddao.findById(docId);
        if (document.getImmutable() == 1) {
            throw new PermissionException(THE_DOCUMENT + docId + IS_IMMUTABLE);
        }
        this.checkDocumentPermission(Permission.READ, user, docId);
        document = ddao.findDocument(docId);
        if (document.getStatus() == DocumentStatus.CHECKEDOUT && (user.getId() == document.getLockUserId().longValue() || user.isMemberOf("admin"))) {
            ddao.initialize(document);
            transaction = new DocumentHistory();
            transaction.setSessionId(sid);
            transaction.setEvent(DocumentEvent.CHECKEDIN);
            transaction.setUser(user);
            transaction.setComment(comment);
            doc = null;
            if (docVO != null) {
                doc = WSUtil.toDocument(docVO);
                doc.setTenantId(user.getTenantId());
            }
        } else {
            throw new WebserviceException("document not checked in");
        }
        DocumentManager documentManager = Context.get(DocumentManager.class);
        documentManager.checkin(document.getId(), content, filename, release, doc, transaction);
        log.info("Document {} checked in", (Object)document.getId());
    }

    @Override
    public void checkout(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(docId);
        docDao.initialize(doc);
        if (doc.getImmutable() == 1) {
            throw new PermissionException(THE_DOCUMENT + docId + IS_IMMUTABLE);
        }
        if (doc.getStatus() != DocumentStatus.UNLOCKED) {
            throw new PermissionException("The document is locked or already checked out");
        }
        this.checkDocumentPermission(Permission.WRITE, user, docId);
        this.checkDocumentPermission(Permission.DOWNLOAD, user, docId);
        doc = docDao.findDocument(docId);
        docDao.initialize(doc);
        this.checkPublished(user, doc);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.CHECKEDOUT);
        transaction.setComment("");
        transaction.setUser(user);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        documentManager.checkout(doc, transaction);
    }

    @Override
    public void delete(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(docId);
        this.checkLocked(user, doc);
        this.checkFolderPermission(Permission.DELETE, user, doc.getFolder().getId());
        this.checkPublished(user, doc);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.DELETED);
        transaction.setComment("");
        transaction.setUser(user);
        docDao.delete(docId, transaction);
    }

    private void checkLocked(User user, Document doc) throws PermissionException {
        if (user.isMemberOf("admin")) {
            return;
        }
        if (doc.getImmutable() == 1) {
            throw new PermissionException(THE_DOCUMENT + doc.getId() + IS_IMMUTABLE);
        }
        if (doc.getStatus() != DocumentStatus.UNLOCKED && user.getId() != doc.getLockUserId().longValue()) {
            throw new PermissionException(THE_DOCUMENT + doc.getId() + IS_LOCKED);
        }
    }

    @Override
    public DataHandler getContent(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        return this.getVersionContent(sid, docId, null);
    }

    @Override
    public DataHandler getVersionContent(String sid, long docId, String version) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        String fileVersion = null;
        if (version != null) {
            VersionDAO vDao = Context.get(VersionDAO.class);
            Version v = vDao.findByVersion(docId, version);
            fileVersion = v.getFileVersion();
        }
        return this.getResource(sid, docId, fileVersion, null);
    }

    @Override
    public DataHandler getResource(String sid, long docId, String fileVersion, String suffix) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        Session session;
        User user = this.validateSession(sid);
        this.checkDocumentPermission(Permission.READ, user, docId);
        this.checkDocumentPermission(Permission.DOWNLOAD, user, docId);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = docDao.findDocument(docId);
        this.checkPublished(user, doc);
        if (doc.isPasswordProtected() && !(session = SessionManager.get().get(sid)).getUnprotectedDocs().containsKey(doc.getId())) {
            throw new PermissionException(String.format("The document is protected by a password %s", doc));
        }
        Store store = Context.get(Store.class);
        String resourceName = store.getResourceName(doc, fileVersion, suffix);
        if (!store.exists(doc.getId(), resourceName)) {
            throw new WebserviceException("Resource " + resourceName + " not found");
        }
        log.debug("Attach file {}", (Object)resourceName);
        String fileName = doc.getFileName();
        if (StringUtils.isNotEmpty(suffix)) {
            fileName = suffix;
        }
        String mime = MimeType.getByFilename(fileName);
        return new DataHandler((DataSource)new InputStreamDataSource(store.getStream(doc.getId(), resourceName), mime));
    }

    @Override
    public void createPdf(String sid, long docId, String fileVersion) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        User user = this.validateSession(sid);
        this.checkDocumentPermission(Permission.READ, user, docId);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = docDao.findDocument(docId);
        FormatConverterManager manager = Context.get(FormatConverterManager.class);
        manager.convertToPdf(doc, fileVersion, sid);
    }

    @Override
    public void createThumbnail(String sid, long docId, String fileVersion, String type) throws AuthenticationException, WebserviceException, PersistenceException, IOException {
        String resource;
        this.validateSession(sid);
        ThumbnailManager manager = Context.get(ThumbnailManager.class);
        Store store = Context.get(Store.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = docDao.findDocument(docId);
        if (!((String)type).toLowerCase().endsWith(".png")) {
            type = (String)type + ".png";
        }
        if (!store.exists(docId, resource = store.getResourceName(doc, fileVersion, (String)type))) {
            if (((String)type).equals("thumb.png")) {
                manager.createTumbnail(doc, fileVersion, sid);
            } else if (((String)type).equals("tile.png")) {
                manager.createTile(doc, fileVersion, sid);
            } else if (((String)type).equals("mobile.png")) {
                manager.createMobile(doc, fileVersion, sid);
            } else if (((String)type).startsWith("thumb")) {
                String sizeStr = resource.substring(resource.indexOf(45) + 6, resource.lastIndexOf(46));
                manager.createTumbnail(doc, fileVersion, Integer.parseInt(sizeStr), null, sid);
            }
        }
    }

    @Override
    public void uploadResource(String sid, long docId, String fileVersion, String suffix, DataHandler content) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        User user = this.validateSession(sid);
        if (StringUtils.isEmpty(suffix)) {
            throw new WebserviceException("Please provide a suffix");
        }
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(docId);
        this.checkDocumentPermission(Permission.READ, user, doc.getId());
        this.checkDocumentPermission(Permission.WRITE, user, doc.getId());
        doc = docDao.findDocument(docId);
        if (doc.getImmutable() == 1) {
            throw new WebserviceException("The document is immutable");
        }
        if ("sign.p7m".equalsIgnoreCase(suffix)) {
            throw new PermissionException("You cannot upload a signature");
        }
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(doc, fileVersion, suffix);
        log.debug("Attach file {}", (Object)resource);
        store.store(content.getInputStream(), doc.getId(), resource);
    }

    @Override
    public WSDocument getDocument(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkPublished(user, doc);
        return this.getDoc(docId);
    }

    @Override
    public WSDocument getDocumentByCustomId(String sid, String customId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = docDao.findByCustomId(customId, user.getTenantId());
        if (doc == null) {
            return null;
        }
        this.checkDocumentPermission(Permission.READ, user, doc.getId());
        this.checkPublished(user, doc);
        return this.getDoc(doc.getId());
    }

    @Override
    public void lock(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkLocked(user, doc);
        this.checkDocumentPermission(Permission.WRITE, user, docId);
        doc = docDao.findDocument(docId);
        this.checkPublished(user, doc);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.LOCKED);
        transaction.setComment("");
        transaction.setUser(user);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        documentManager.lock(doc.getId(), DocumentStatus.LOCKED, transaction);
    }

    @Override
    public void move(String sid, long docId, long folderId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        FolderDAO fdao = Context.get(FolderDAO.class);
        long rootId = fdao.findRoot(user.getTenantId()).getId();
        if (folderId == rootId) {
            throw new PermissionException("Cannot move documents in the root");
        }
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkFolderPermission(Permission.MOVE, user, doc.getFolder().getId());
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        doc = docDao.findDocument(docId);
        this.checkPublished(user, doc);
        FolderDAO dao = Context.get(FolderDAO.class);
        Folder folder = (Folder)dao.findById(folderId);
        this.checkLocked(user, doc);
        this.checkFolderPermission(Permission.WRITE, user, folder.getId());
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.MOVED);
        transaction.setComment("");
        transaction.setUser(user);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        documentManager.moveToFolder(doc, folder, transaction);
    }

    @Override
    public WSDocument copy(String sid, long docId, long folderId, boolean links, boolean notes, boolean security) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        User user = this.validateSession(sid);
        FolderDAO fdao = Context.get(FolderDAO.class);
        long rootId = fdao.findRoot(user.getTenantId()).getId();
        if (folderId == rootId) {
            throw new PermissionException("Cannot create documents in the root");
        }
        this.checkFolderPermission(Permission.WRITE, user, folderId);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = docDao.findDocument(docId);
        this.checkPublished(user, doc);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.COPYED);
        transaction.setComment("");
        transaction.setUser(user);
        Folder folder = fdao.findFolder(folderId);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        Document createdDoc = documentManager.copyToFolder(doc, folder, transaction, links, notes, security).getDocument();
        return this.getDoc(createdDoc.getId());
    }

    @Override
    public void rename(String sid, long docId, String name) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkFolderPermission(Permission.RENAME, user, doc.getFolder().getId());
        this.checkPublished(user, doc);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setUser(user);
        manager.rename(docId, name, transaction);
    }

    @Override
    public void restore(String sid, long docId, long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        transaction.setSessionId(sid);
        docDao.restore(docId, folderId, transaction);
    }

    @Override
    public void unlock(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkLocked(user, doc);
        if (doc.getStatus() == DocumentStatus.UNLOCKED) {
            return;
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.UNLOCKED);
        transaction.setComment("");
        transaction.setUser(user);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        documentManager.unlock(docId, transaction);
    }

    @Override
    public void update(String sid, WSDocument document) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        this.updateDocument(sid, document);
    }

    private void updateDocument(String sid, WSDocument document) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(document.getId(), user);
        this.checkLocked(user, doc);
        this.checkDocumentPermission(Permission.WRITE, user, doc.getId());
        this.checkPublished(user, doc);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        docDao.initialize(doc);
        long originalFolderId = doc.getFolder().getId();
        doc.setCustomId(document.getCustomId());
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.CHANGED);
        transaction.setComment(document.getComment());
        transaction.setUser(user);
        manager.update(doc, WSUtil.toDocument(document), transaction);
        if (!document.getFolderId().equals(originalFolderId)) {
            this.move(sid, document.getId(), document.getFolderId());
        }
    }

    @Override
    public List<WSDocument> listDocuments(String sid, long folderId, String fileName) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        return this.list(sid, folderId, fileName, "fileName asc", null, null);
    }

    @Override
    public List<WSDocument> list(String sid, long folderId, String fileName, String sort, Integer page, Integer max) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        this.checkFolderPermission(Permission.READ, user, folderId);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        List<Document> docs = docDao.findByFolder(folderId, null);
        if (StringUtils.isNotEmpty(sort)) {
            Collections.sort(docs, DocumentComparator.getComparator(sort));
        }
        docs = docs.stream().filter(doc -> this.mustList((Document)doc, user, fileName)).collect(Collectors.toList());
        if (max != null && page != null && max < docs.size()) {
            docs = docs.stream().skip((long)(page - 1) * (long)max.intValue()).limit(max.intValue()).collect(Collectors.toList());
        }
        ArrayList<WSDocument> wsDocs = new ArrayList<WSDocument>();
        for (Document doc2 : docs) {
            docDao.initialize(doc2);
            wsDocs.add(WSUtil.toWSDocument(doc2));
        }
        return wsDocs;
    }

    private boolean mustList(Document document, User user, String fileName) {
        try {
            this.checkPublished(user, document);
            this.checkNotArchived(document);
            if (fileName != null && !FileUtil.matches(document.getFileName(), List.of(fileName), null)) {
                throw new ParsingException("no match");
            }
            return true;
        }
        catch (Exception t) {
            return false;
        }
    }

    @Override
    public List<WSDocument> getDocuments(String sid, List<Long> docIds) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        FolderDAO fdao = Context.get(FolderDAO.class);
        Collection<Long> folderIds = fdao.findFolderIdByUserId(user.getId(), null, true);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        List<Document> docs = docDao.findByIds(Set.copyOf(docIds), null);
        ArrayList<WSDocument> wsDocs = new ArrayList<WSDocument>();
        int i = 0;
        while (i < docs.size()) {
            block4: {
                try {
                    this.checkPublished(user, docs.get(i));
                    this.checkNotArchived(docs.get(i));
                }
                catch (Exception t) {
                    break block4;
                }
                if (user.isMemberOf("admin") || folderIds.contains(docs.get(i).getFolder().getId())) {
                    wsDocs.add(this.getDoc(docs.get(i).getId()));
                }
            }
            ++i;
        }
        return wsDocs;
    }

    @Override
    public List<WSDocument> getRecentDocuments(String sid, Integer max) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        DocumentHistoryDAO dao = Context.get(DocumentHistoryDAO.class);
        StringBuilder query = new StringBuilder("select docId from DocumentHistory where deleted=0 and (docId is not NULL) and userId=" + user.getId());
        query.append(" order by date desc");
        List<Long> records = dao.findByQuery(query.toString(), null, Long.class, max);
        ArrayList<Long> docIds = new ArrayList<Long>();
        for (Long id : records) {
            if (docIds.contains(id)) continue;
            docIds.add(id);
        }
        return this.getDocuments(sid, docIds);
    }

    @Override
    public void sendEmail(String sid, List<Long> docIds, String recipients, String subject, String message) throws AuthenticationException, WebserviceException, PersistenceException, IOException, MessagingException {
        User user = this.validateSession(sid);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        FolderDAO folderDao = Context.get(FolderDAO.class);
        ContextProperties config = Context.get().getProperties();
        Session session = SessionManager.get().get(sid);
        EMail mail = new EMail();
        mail.setTenantId(user.getTenantId());
        mail.setAccountId(-1L);
        mail.setAuthor(user.getUsername());
        if (config.getBoolean(session.getTenantName() + ".smtp.userasfrom", true)) {
            mail.setAuthorAddress(user.getEmail());
        }
        mail.parseRecipients(recipients);
        for (Recipient recipient : mail.getRecipients()) {
            recipient.setRead(1);
        }
        mail.setFolder("outbox");
        mail.setMessageText(message);
        mail.setSentDate(new Date());
        mail.setSubject(subject);
        mail.setUsername(user.getUsername());
        ArrayList<Document> docs = new ArrayList<Document>();
        for (long id : docIds) {
            Document doc = (Document)docDao.findById(id);
            if (doc == null || !folderDao.isReadAllowed(doc.getFolder().getId(), user.getId())) continue;
            doc = docDao.findDocument(id);
            this.createAttachment(mail, doc);
            docs.add(doc);
        }
        EMailSender sender = new EMailSender(user.getTenantId());
        sender.send(mail);
        for (Document doc : docs) {
            try {
                this.checkPublished(user, doc);
            }
            catch (Exception t) {
                continue;
            }
            DocumentHistory history = new DocumentHistory();
            history.setSessionId(sid);
            history.setDocument(doc);
            history.setDocId(doc.getId());
            history.setEvent(DocumentEvent.SENT);
            history.setUser(user);
            history.setComment(StringUtils.abbreviate(recipients, 4000));
            history.setFilename(doc.getFileName());
            history.setVersion(doc.getVersion());
            history.setFileVersion(doc.getFileVersion());
            history.setPath(folderDao.computePathExtended(doc.getFolder().getId()));
            docDao.saveDocumentHistory(doc, history);
        }
    }

    private WSDocument getDoc(long docId) throws PersistenceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(docId);
        Long aliasId = null;
        String aliasFileName = null;
        if (doc.getDocRef() != null) {
            aliasFileName = doc.getFileName();
            long id = doc.getDocRef();
            doc = (Document)docDao.findById(id);
            aliasId = docId;
        }
        docDao.initialize(doc);
        WSDocument document = WSUtil.toWSDocument(doc);
        if (aliasId != null) {
            document.setDocRef(aliasId);
        }
        if (StringUtils.isNotEmpty(aliasFileName)) {
            document.setFileName(aliasFileName);
        }
        return document;
    }

    private void createAttachment(EMail email, Document doc) throws IOException {
        EMailAttachment att = new EMailAttachment();
        att.setIcon(doc.getIcon());
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(doc, null, null);
        att.setData(store.getBytes(doc.getId(), resource));
        att.setFileName(doc.getFileName());
        String extension = doc.getFileExtension();
        att.setMimeType(MimeType.get(extension));
        email.addAttachment(2 + email.getAttachments().size(), att);
    }

    @Override
    public WSDocument createAlias(String sid, long docId, long folderId, String type) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        FolderDAO fdao = Context.get(FolderDAO.class);
        long rootId = fdao.findRoot(user.getTenantId()).getId();
        if (folderId == rootId) {
            throw new PermissionException("Cannot create alias in the root");
        }
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document originalDoc = (Document)docDao.findById(docId);
        this.checkDocumentPermission(Permission.DOWNLOAD, user, docId);
        this.checkFolderPermission(Permission.WRITE, user, folderId);
        FolderDAO mdao = Context.get(FolderDAO.class);
        Folder folder = (Folder)mdao.findById(folderId);
        if (folder == null) {
            throw new WebserviceException("error - folder not found");
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setEvent(DocumentEvent.SHORTCUT_STORED);
        transaction.setComment("");
        transaction.setUser(user);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        Document doc = documentManager.createAlias(originalDoc, folder, type, transaction);
        this.checkPublished(user, doc);
        return WSUtil.toWSDocument(doc);
    }

    @Override
    public void reindex(String sid, long docId, String content) throws ParsingException, AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        DocumentManager documentManager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setUser(user);
        documentManager.index(docId, content, transaction);
    }

    @Override
    public List<WSDocument> getAliases(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        Collection<Long> folderIds = null;
        if (!user.isMemberOf("admin")) {
            FolderDAO fdao = Context.get(FolderDAO.class);
            folderIds = fdao.findFolderIdByUserId(user.getId(), null, true);
        }
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        List<Object> docs = new ArrayList();
        if (user.isMemberOf("admin")) {
            docs = docDao.findByWhere("_entity.docRef=" + docId, null, null);
        } else if (folderIds != null) {
            String idsStr = folderIds.toString().replace('[', '(').replace(']', ')');
            docs = docDao.findByWhere("_entity.docRef=" + docId + " and _entity.id in " + idsStr, null, null);
        }
        ArrayList<WSDocument> wsDocs = new ArrayList<WSDocument>();
        int i = 0;
        while (i < docs.size()) {
            docDao.initialize((Document)docs.get(i));
            if (user.isMemberOf("admin") || folderIds != null && folderIds.contains(((Document)docs.get(i)).getFolder().getId())) {
                wsDocs.add(WSUtil.toWSDocument((AbstractDocument)docs.get(i)));
            }
            ++i;
        }
        return wsDocs;
    }

    @Override
    public long upload(String sid, Long docId, Long folderId, boolean release, String filename, String language, DataHandler content) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException {
        this.validateSession(sid);
        if (docId != null) {
            this.checkout(sid, docId);
            this.checkin(sid, docId, "", filename, release, content);
            return docId;
        }
        WSDocument doc = new WSDocument();
        doc.setFileName(filename);
        doc.setFolderId(folderId);
        if (StringUtils.isEmpty(language)) {
            doc.setLanguage("en");
        } else {
            doc.setLanguage(language);
        }
        return this.create(sid, doc, content).getId();
    }

    @Override
    public WSLink link(String sid, long doc1, long doc2, String type) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        DocumentLinkDAO linkDao = Context.get(DocumentLinkDAO.class);
        DocumentLink link = linkDao.findByDocIdsAndType(doc1, doc2, type);
        Document document1 = this.retrieveReadableDocument(doc1, user);
        Document document2 = this.retrieveReadableDocument(doc2, user);
        this.checkDocumentPermission(Permission.WRITE, user, document2.getId());
        if (link == null) {
            link = new DocumentLink();
            link.setTenantId(document1.getTenantId());
            link.setDocument1(document1);
            link.setDocument2(document2);
            link.setType(type);
            linkDao.store(link);
            WSLink lnk = new WSLink();
            lnk.setId(link.getId());
            lnk.setDoc1(doc1);
            lnk.setDoc2(doc2);
            lnk.setType(type);
            return lnk;
        }
        throw new WebserviceException("Documents already linked");
    }

    @Override
    public List<WSLink> getLinks(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        DocumentLinkDAO linkDao = Context.get(DocumentLinkDAO.class);
        this.checkDocumentPermission(Permission.READ, user, docId);
        List<DocumentLink> links = linkDao.findByDocId(docId);
        ArrayList<WSLink> lnks = new ArrayList<WSLink>();
        for (DocumentLink link : links) {
            WSLink lnk = new WSLink();
            lnk.setId(link.getId());
            lnk.setDoc1(link.getDocument1().getId());
            lnk.setDoc2(link.getDocument2().getId());
            lnk.setType(link.getType());
            lnks.add(lnk);
        }
        return lnks;
    }

    @Override
    public void deleteLink(String sid, long id) throws AuthenticationException, WebserviceException, PersistenceException {
        this.validateSession(sid);
        DocumentLinkDAO linkDao = Context.get(DocumentLinkDAO.class);
        linkDao.delete(id);
    }

    @Override
    public String getExtractedText(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        this.validateSession(sid);
        SearchEngine indexer = Context.get(SearchEngine.class);
        return indexer.getHit(docId).getContent();
    }

    @Override
    public String createDownloadTicket(String sid, long docId, String suffix, Integer expireHours, String expireDate, Integer maxDownloads) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        this.validateSession(sid);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(SessionManager.get().get(sid));
        Ticket ticket = new Ticket();
        ticket.setType(0);
        ticket.setTenantId(transaction.getTenantId());
        ticket.setDocId(docId);
        ticket.setSuffix(suffix);
        ticket.setExpireHours(expireHours);
        ticket.setExpired(SoapDocumentService.convertStringToDate(expireDate));
        ticket.setMaxCount(maxDownloads);
        ticket = manager.createTicket(ticket, transaction);
        return ticket.getUrl();
    }

    @Override
    public String createViewTicket(String sid, long docId, String suffix, Integer expireHours, String expireDate, Integer maxDownloads, Integer maxViews) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        this.validateSession(sid);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(SessionManager.get().get(sid));
        Ticket ticket = new Ticket();
        ticket.setType(2);
        ticket.setTenantId(transaction.getTenantId());
        ticket.setDocId(docId);
        ticket.setSuffix(suffix);
        ticket.setExpireHours(expireHours);
        ticket.setExpired(SoapDocumentService.convertStringToDate(expireDate));
        ticket.setMaxCount(maxDownloads);
        ticket.setMaxViews(maxViews);
        ticket = manager.createTicket(ticket, transaction);
        return ticket.getUrl();
    }

    @Override
    public void setPassword(String sid, long docId, String password) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkFolderPermission(Permission.PASSWORD, user, doc.getFolder().getId());
        DocumentDAO dao = Context.get(DocumentDAO.class);
        doc = dao.findDocument(docId);
        Session session = SessionManager.get().get(sid);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setComment("");
        dao.setPassword(doc.getId(), password, transaction);
    }

    @Override
    public void unsetPassword(String sid, long docId, String currentPassword) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkFolderPermission(Permission.PASSWORD, user, doc.getFolder().getId());
        DocumentDAO dao = Context.get(DocumentDAO.class);
        doc = dao.findDocument(docId);
        Session session = SessionManager.get().get(sid);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSession(session);
        transaction.setComment("");
        if (!doc.isGranted(currentPassword)) {
            throw new PermissionException("You cannot access the document");
        }
        dao.unsetPassword(doc.getId(), transaction);
    }

    @Override
    public boolean unprotect(String sid, long docId, String password) throws PersistenceException, AuthenticationException, WebserviceException {
        this.validateSession(sid);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentDAO dao = Context.get(DocumentDAO.class);
        Document doc = dao.findDocument(docId);
        return manager.unprotect(sid, doc.getId(), password);
    }

    @Override
    public WSNote addNote(String sid, long docId, String note) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        WSDocument document = this.getDocument(sid, docId);
        if (document == null) {
            throw new PermissionException(DOCUMENT_WITH_ID + docId + NOT_FOUND_OR_NOT_ACCESSIBLE);
        }
        DocumentNote newNote = new DocumentNote();
        newNote.setDocId(document.getId());
        newNote.setMessage(note);
        newNote.setUserId(user.getId());
        newNote.setUsername(user.getFullName());
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        Document doc = ddao.findDocument(docId);
        newNote.setFileName(doc.getFileName());
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setUser(user);
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        dao.store(newNote, transaction);
        return WSNote.fromDocumentNote(newNote);
    }

    @Override
    public WSNote saveNote(String sid, long docId, WSNote wsNote) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        WSDocument document = this.getDocument(sid, docId);
        if (document == null) {
            throw new PermissionException(DOCUMENT_WITH_ID + docId + NOT_FOUND_OR_NOT_ACCESSIBLE);
        }
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        DocumentNote note = (DocumentNote)dao.findById(wsNote.getId());
        if (note == null) {
            note = new DocumentNote();
            note.setTenantId(user.getTenantId());
            note.setDocId(docId);
            note.setUserId(user.getId());
            note.setUsername(user.getUsername());
            note.setDate(new Date());
        }
        note.setPage(wsNote.getPage());
        note.setMessage(wsNote.getMessage());
        note.setColor(wsNote.getColor());
        note.setTop(wsNote.getTop());
        note.setLeft(wsNote.getLeft());
        note.setWidth(wsNote.getWidth());
        note.setHeight(wsNote.getHeight());
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        Document doc = ddao.findDocument(docId);
        note.setFileName(doc.getFileName());
        if (note.getId() == 0L) {
            DocumentHistory transaction = new DocumentHistory();
            transaction.setSessionId(sid);
            transaction.setUser(user);
            dao.store(note, transaction);
        } else {
            dao.store(note);
        }
        return WSNote.fromDocumentNote(note);
    }

    @Override
    public void deleteNote(String sid, long noteId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        DocumentNote note = (DocumentNote)dao.findById(noteId);
        if (note == null) {
            return;
        }
        if (user.isMemberOf("admin") || user.getId() == note.getUserId()) {
            dao.delete(note.getId());
        }
    }

    @Override
    public String deleteVersion(String sid, long docId, String version) throws AuthenticationException, WebserviceException, PersistenceException {
        this.validateSession(sid);
        VersionDAO dao = Context.get(VersionDAO.class);
        Version ver = dao.findByVersion(docId, version);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        Version latestVersion = manager.deleteVersion(ver.getId(), transaction);
        return latestVersion.getVersion();
    }

    @Override
    public List<WSNote> getNotes(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        this.validateSession(sid);
        WSDocument document = this.getDocument(sid, docId);
        if (document == null) {
            throw new WebserviceException(DOCUMENT_WITH_ID + docId + NOT_FOUND_OR_NOT_ACCESSIBLE);
        }
        DocumentNoteDAO dao = Context.get(DocumentNoteDAO.class);
        List<DocumentNote> notes = dao.findByDocId(docId, document.getFileVersion());
        ArrayList<WSNote> wsNotes = new ArrayList<WSNote>();
        if (notes != null) {
            for (DocumentNote note : notes) {
                wsNotes.add(WSNote.fromDocumentNote(note));
            }
        }
        return wsNotes;
    }

    @Override
    public WSRating rateDocument(String sid, long docId, int vote) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        WSDocument document = this.getDocument(sid, docId);
        if (document == null) {
            throw new WebserviceException(DOCUMENT_WITH_ID + docId + NOT_FOUND_OR_NOT_ACCESSIBLE);
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setSessionId(sid);
        transaction.setUser(user);
        RatingDAO ratingDao = Context.get(RatingDAO.class);
        Rating rating = ratingDao.findByDocIdAndUserId(docId, user.getId());
        if (rating == null) {
            rating = new Rating();
            rating.setDocId(docId);
            rating.setUserId(user.getId());
            rating.setUsername(user.getFullName());
        }
        rating.setVote(vote);
        ratingDao.store(rating, transaction);
        return WSRating.fromRating(rating);
    }

    @Override
    public List<WSRating> getRatings(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        this.validateSession(sid);
        WSDocument document = this.getDocument(sid, docId);
        if (document == null) {
            throw new WebserviceException(DOCUMENT_WITH_ID + docId + NOT_FOUND_OR_NOT_ACCESSIBLE);
        }
        RatingDAO ratingDao = Context.get(RatingDAO.class);
        List<Rating> ratings = ratingDao.findByDocId(docId);
        ArrayList<WSRating> wsRatings = new ArrayList<WSRating>();
        if (ratings != null) {
            for (Rating rating : ratings) {
                wsRatings.add(WSRating.fromRating(rating));
            }
        }
        return wsRatings;
    }

    @Override
    public void replaceFile(String sid, long docId, String fileVersion, String comment, DataHandler content) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        if (doc.getImmutable() == 1) {
            throw new PermissionException(THE_DOCUMENT + docId + IS_IMMUTABLE);
        }
        this.checkDocumentPermission(Permission.WRITE, user, doc.getId());
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        doc = ddao.findDocument(docId);
        if (doc.getStatus() != DocumentStatus.UNLOCKED) {
            throw new PermissionException(THE_DOCUMENT + docId + IS_LOCKED);
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setComment(comment);
        transaction.setUser(user);
        transaction.setSession(SessionManager.get().get(sid));
        DocumentManager manager = Context.get(DocumentManager.class);
        manager.replaceFile(doc.getId(), fileVersion, content.getInputStream(), transaction);
        log.info("Replaced fileVersion {} of document {}", (Object)fileVersion, (Object)doc);
    }

    @Override
    public void promoteVersion(String sid, long docId, String version) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkDocumentPermission(Permission.WRITE, user, doc.getId());
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        doc = ddao.findDocument(docId);
        if (doc.getStatus() != DocumentStatus.UNLOCKED) {
            throw new PermissionException(THE_DOCUMENT + docId + IS_LOCKED);
        }
        DocumentHistory transaction = new DocumentHistory();
        transaction.setUser(user);
        transaction.setSession(SessionManager.get().get(sid));
        DocumentManager manager = Context.get(DocumentManager.class);
        manager.promoteVersion(doc.getId(), version, transaction);
        log.info("Promoted version {} of document {}", (Object)version, (Object)doc);
    }

    @Override
    public WSDocument getVersion(String sid, long docId, String version) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkPublished(user, doc);
        VersionDAO versDao = Context.get(VersionDAO.class);
        Version ver = versDao.findByVersion(docId, version);
        if (ver != null) {
            versDao.initialize(ver);
            WSDocument wsVersion = WSUtil.toWSDocument(ver);
            wsVersion.setComment(ver.getComment());
            return wsVersion;
        }
        return null;
    }

    @Override
    public List<WSDocument> getVersions(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        Document doc = this.retrieveReadableDocument(docId, user);
        this.checkPublished(user, doc);
        VersionDAO versDao = Context.get(VersionDAO.class);
        List<Version> versions = versDao.findByDocId(doc.getId());
        ArrayList<WSDocument> wsVersions = new ArrayList<WSDocument>();
        for (Version version : versions) {
            versDao.initialize(version);
            WSDocument wsVersion = WSUtil.toWSDocument(version);
            wsVersion.setComment(version.getComment());
            wsVersions.add(wsVersion);
        }
        return wsVersions;
    }

    private Document retrieveReadableDocument(long docId, User user) throws PersistenceException, PermissionException, UnexistingResourceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(docId);
        if (doc == null) {
            throw new UnexistingResourceException(user.getUsername(), "Document " + docId);
        }
        this.checkDocumentPermission(Permission.READ, user, docId);
        doc = docDao.findDocument(docId);
        return doc;
    }

    @Override
    public void setAccessControlList(String sid, long docId, List<WSAccessControlEntry> acl) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException {
        User sessionUser = this.validateSession(sid);
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        if (!documentDao.isPermissionAllowed(Permission.SECURITY, docId, sessionUser.getId())) {
            throw new PermissionException(sessionUser.getUsername(), "Document " + docId, Permission.SECURITY);
        }
        Document document = (Document)documentDao.findById(docId);
        documentDao.initialize(document);
        document.getAccessControlList().clear();
        for (WSAccessControlEntry wsAcwe : acl) {
            document.addAccessControlEntry(WSUtil.toDocumentAccessControlEntry(wsAcwe));
        }
        DocumentHistory history = new DocumentHistory();
        history.setEvent(DocumentEvent.PERMISSION);
        history.setSession(SessionManager.get().get(sid));
        documentDao.store(document, history);
    }

    @Override
    public List<WSAccessControlEntry> getAccessControlList(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        this.validateSession(sid);
        ArrayList<WSAccessControlEntry> acl = new ArrayList<WSAccessControlEntry>();
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        Document document = (Document)documentDao.findById(docId);
        documentDao.initialize(document);
        for (AccessControlEntry accessControlEntry : document.getAccessControlList()) {
            acl.add(WSUtil.toWSAccessControlEntry(accessControlEntry));
        }
        return acl;
    }

    @Override
    public boolean isRead(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        return this.isGranted(sid, docId, Permission.READ.name());
    }

    @Override
    public boolean isWrite(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        return this.isGranted(sid, docId, Permission.WRITE.name());
    }

    @Override
    public boolean isDownload(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        return this.isGranted(sid, docId, Permission.DOWNLOAD.name());
    }

    @Override
    public boolean isGranted(String sid, long docId, String permission) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        try {
            this.checkDocumentPermission(Permission.valueOf(permission.toUpperCase()), user, docId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
        return true;
    }
}

