/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Bookmark;
import com.logicaldoc.core.document.BookmarkDAO;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSBookmark;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.soap.BookmarkService;
import com.logicaldoc.webservice.soap.endpoint.SoapDocumentService;
import com.logicaldoc.webservice.soap.endpoint.SoapFolderService;
import java.util.ArrayList;
import java.util.List;

public class SoapBookmarkService
extends AbstractService
implements BookmarkService {
    @Override
    public WSBookmark saveBookmark(String sid, WSBookmark bookmark) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        this.checkObjectAvailability(sid, bookmark);
        return this.storeBookmark(bookmark, user);
    }

    private void checkObjectAvailability(String sid, WSBookmark bookmark) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        if (bookmark.getType() == 0) {
            this.checkDocumentAvailable(sid, bookmark.getTargetId());
        } else {
            this.checkFolderAvailable(sid, bookmark.getTargetId());
        }
    }

    private WSFolder checkFolderAvailable(String sid, long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        SoapFolderService folderService = new SoapFolderService();
        folderService.setValidateSession(this.isValidateSession());
        WSFolder folder = folderService.getFolder(sid, folderId);
        if (folder == null) {
            throw new PermissionException("Folder " + folderId + " not found or not accessible");
        }
        return folder;
    }

    private WSDocument checkDocumentAvailable(String sid, long docId) throws PermissionException, AuthenticationException, WebserviceException, PersistenceException, UnexistingResourceException {
        SoapDocumentService docService = new SoapDocumentService();
        docService.setValidateSession(this.isValidateSession());
        return docService.getDocument(sid, docId);
    }

    private WSBookmark storeBookmark(WSBookmark bookmark, User user) throws PersistenceException {
        BookmarkDAO bDao = Context.get(BookmarkDAO.class);
        Bookmark bmark = null;
        bmark = bookmark.getType() == 0 ? bDao.findByUserIdAndDocId(user.getId(), bookmark.getTargetId()) : bDao.findByUserIdAndFolderId(user.getId(), bookmark.getTargetId());
        if (bmark == null) {
            bmark = new Bookmark();
        }
        bmark.setDescription(bookmark.getDescription());
        bmark.setTitle(bookmark.getTitle());
        bmark.setFileType(bookmark.getFileType());
        bmark.setPosition(bookmark.getPosition());
        bmark.setTenantId(user.getTenantId());
        bmark.setTargetId(bookmark.getTargetId());
        bmark.setType(bookmark.getType());
        bmark.setUserId(user.getId());
        bDao.store(bmark);
        return WSBookmark.fromBookmark(bmark);
    }

    @Override
    public WSBookmark bookmarkDocument(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException {
        User user = this.validateSession(sid);
        WSDocument doc = this.checkDocumentAvailable(sid, docId);
        BookmarkDAO bDao = Context.get(BookmarkDAO.class);
        Bookmark bmark = bDao.findByUserIdAndDocId(user.getId(), docId);
        if (bmark == null) {
            bmark = new Bookmark();
            bmark.setType(0);
            bmark.setFileType(doc.getFileName());
            bmark.setFileType(doc.getType());
            bmark.setUserId(user.getId());
            bmark.setTargetId(docId);
            bDao.store(bmark);
        }
        return WSBookmark.fromBookmark(bmark);
    }

    @Override
    public WSBookmark bookmarkFolder(String sid, long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        this.checkFolderAvailable(sid, folderId);
        User user = this.validateSession(sid);
        WSFolder folder = this.checkFolderAvailable(sid, folderId);
        BookmarkDAO bDao = Context.get(BookmarkDAO.class);
        Bookmark bmark = bDao.findByUserIdAndDocId(user.getId(), folderId);
        if (bmark == null) {
            bmark = new Bookmark();
            bmark.setType(0);
            bmark.setTitle(folder.getName());
            bmark.setFileType("folder");
            bmark.setUserId(user.getId());
            bmark.setTargetId(folderId);
            bDao.store(bmark);
        }
        return WSBookmark.fromBookmark(bmark);
    }

    @Override
    public List<WSBookmark> getBookmarks(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        BookmarkDAO bDao = Context.get(BookmarkDAO.class);
        List<Bookmark> list = bDao.findByUserId(user.getId());
        ArrayList<WSBookmark> wsBookmarks = new ArrayList<WSBookmark>();
        for (Bookmark bookmark : list) {
            wsBookmarks.add(WSBookmark.fromBookmark(bookmark));
        }
        return wsBookmarks;
    }

    @Override
    public void deleteBookmark(String sid, long bookmarkId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        BookmarkDAO bDao = Context.get(BookmarkDAO.class);
        Bookmark bookmark = (Bookmark)bDao.findById(bookmarkId);
        if (bookmark == null || bookmark.getUserId() != user.getId()) {
            throw new WebserviceException("Bookmark " + bookmarkId + " not found or not accessible");
        }
        bDao.delete(bookmarkId);
    }

    @Override
    public void unbookmarkDocument(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        BookmarkDAO bDao = Context.get(BookmarkDAO.class);
        Bookmark bookmark = bDao.findByUserIdAndDocId(user.getId(), docId);
        if (bookmark != null) {
            this.deleteBookmark(sid, bookmark.getId());
        }
    }

    @Override
    public void unbookmarkFolder(String sid, long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        BookmarkDAO bDao = Context.get(BookmarkDAO.class);
        Bookmark bookmark = bDao.findByUserIdAndFolderId(user.getId(), folderId);
        if (bookmark != null) {
            this.deleteBookmark(sid, bookmark.getId());
        }
    }
}

