/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.endpoint;

import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.soap.AuthService;

public class SoapAuthService
extends AbstractService
implements AuthService {
    @Override
    public String login(String username, String password) throws AuthenticationException {
        if (Context.get().getProperties().getBoolean("webservice.basicauth.enabled", false)) {
            return SessionManager.get().newSession(username, password, this.getCurrentRequest()).getSid();
        }
        throw new AuthenticationException("Basic Authentication is disabled");
    }

    @Override
    public String loginApiKey(String apiKey) throws AuthenticationException {
        Session session = SessionManager.get().newSession(apiKey, this.getCurrentRequest());
        return session.getSid();
    }

    @Override
    public void logout(String sidOrApiKey) {
        SessionManager.get().kill(this.sessionId(sidOrApiKey));
    }

    @Override
    public boolean valid(String sidOrApiKey) {
        if (!this.isWebserviceEnabled()) {
            return false;
        }
        return SessionManager.get().isOpen(this.sessionId(sidOrApiKey));
    }

    @Override
    public void renew(String sidOrApiKey) {
        if (!this.isWebserviceEnabled()) {
            return;
        }
        String sid = this.sessionId(sidOrApiKey);
        if (SessionManager.get().isOpen(sid)) {
            SessionManager.get().renew(sid);
        }
    }
}

