/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.client;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.model.WSTagCloud;
import com.logicaldoc.webservice.soap.TagService;
import com.logicaldoc.webservice.soap.client.SoapClient;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;

@WebService(name="Tag", serviceName="Tag")
public class SoapTagClient
extends SoapClient<TagService>
implements TagService {
    public SoapTagClient(String endpoint, int gzipThreshold, boolean log, int timeout) {
        super(endpoint, TagService.class, gzipThreshold, log, timeout);
    }

    public SoapTagClient(String endpoint) {
        super(endpoint, TagService.class, -1, true, -1);
    }

    @Override
    public void setDocumentTags(String sid, long docId, List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((TagService)this.client).setDocumentTags(sid, docId, tags);
    }

    @Override
    public void addDocumentTags(String sid, long docId, List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((TagService)this.client).addDocumentTags(sid, docId, tags);
    }

    @Override
    public List<String> getDocumentTags(String sid, long docId) throws PermissionException, AuthenticationException, PersistenceException, WebserviceException, UnexistingResourceException {
        return ((TagService)this.client).getDocumentTags(sid, docId);
    }

    @Override
    public void setFolderTags(String sid, long folderId, List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        ((TagService)this.client).setFolderTags(sid, folderId, tags);
    }

    @Override
    public void addFolderTags(String sid, long folderId, List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        ((TagService)this.client).addFolderTags(sid, folderId, tags);
    }

    @Override
    public List<String> getFolderTags(String sid, long folderId) throws PermissionException, AuthenticationException, PersistenceException, WebserviceException {
        return ((TagService)this.client).getFolderTags(sid, folderId);
    }

    @Override
    public List<String> getTags(String sid) throws AuthenticationException, PersistenceException, WebserviceException {
        List<String> tags = ((TagService)this.client).getTags(sid);
        if (tags != null) {
            return tags;
        }
        return new ArrayList<String>();
    }

    @Override
    public List<WSTagCloud> getTagCloud(String sid) throws AuthenticationException, PersistenceException, WebserviceException {
        List<WSTagCloud> tags = ((TagService)this.client).getTagCloud(sid);
        if (tags != null) {
            return tags;
        }
        return new ArrayList<WSTagCloud>();
    }

    @Override
    public List<WSDocument> findDocumentsByTag(String sid, String tag) throws AuthenticationException, PersistenceException, WebserviceException {
        List<WSDocument> documents = ((TagService)this.client).findDocumentsByTag(sid, tag);
        if (documents != null) {
            return documents;
        }
        return new ArrayList<WSDocument>();
    }

    @Override
    public List<WSFolder> findFoldersByTag(String sid, String tag) throws AuthenticationException, WebserviceException, PersistenceException {
        List<WSFolder> folders = ((TagService)this.client).findFoldersByTag(sid, tag);
        if (folders != null) {
            return folders;
        }
        return new ArrayList<WSFolder>();
    }

    @Override
    public List<String> getTagsPreset(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        List<String> tags = ((TagService)this.client).getTagsPreset(sid);
        if (tags != null) {
            return tags;
        }
        return new ArrayList<String>();
    }
}

