/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.client;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSParameter;
import com.logicaldoc.webservice.model.WSSystemInfo;
import com.logicaldoc.webservice.soap.SystemService;
import com.logicaldoc.webservice.soap.client.SoapClient;
import java.util.ArrayList;
import java.util.List;

public class SoapSystemClient
extends SoapClient<SystemService>
implements SystemService {
    public SoapSystemClient(String endpoint) {
        super(endpoint, SystemService.class, -1, true, -1);
    }

    @Override
    public List<WSParameter> getStatistics(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        return this.getTenantStatistics(sid, -1L);
    }

    @Override
    public List<WSParameter> getTenantStatistics(String sid, long tenantId) throws AuthenticationException, WebserviceException, PersistenceException {
        List<WSParameter> params = ((SystemService)this.client).getTenantStatistics(sid, tenantId);
        if (params != null) {
            return params;
        }
        return new ArrayList<WSParameter>();
    }

    @Override
    public List<String> getLanguages(String tenantOrSid) {
        List<String> languages = ((SystemService)this.client).getLanguages(tenantOrSid);
        if (languages != null) {
            return languages;
        }
        return new ArrayList<String>();
    }

    @Override
    public WSSystemInfo getInfo() throws WebserviceException {
        return ((SystemService)this.client).getInfo();
    }
}

