/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.client;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSAttributeOption;
import com.logicaldoc.webservice.model.WSAttributeSet;
import com.logicaldoc.webservice.model.WSTemplate;
import com.logicaldoc.webservice.soap.DocumentMetadataService;
import com.logicaldoc.webservice.soap.client.SoapClient;
import java.util.ArrayList;
import java.util.List;

public class SoapDocumentMetadataClient
extends SoapClient<DocumentMetadataService>
implements DocumentMetadataService {
    public SoapDocumentMetadataClient(String endpoint) {
        super(endpoint, DocumentMetadataService.class, -1, true, -1);
    }

    public SoapDocumentMetadataClient(String endpoint, int timeout) {
        super(endpoint, DocumentMetadataService.class, -1, true, timeout);
    }

    @Override
    public List<WSTemplate> listTemplates(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        List<WSTemplate> templates = ((DocumentMetadataService)this.client).listTemplates(sid);
        if (templates != null) {
            return templates;
        }
        return new ArrayList<WSTemplate>();
    }

    @Override
    public long storeTemplate(String sid, WSTemplate template) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).storeTemplate(sid, template);
    }

    @Override
    public void deleteTemplate(String sid, long templateId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        ((DocumentMetadataService)this.client).deleteTemplate(sid, templateId);
    }

    @Override
    public WSTemplate getTemplate(String sid, String name) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).getTemplate(sid, name);
    }

    @Override
    public WSTemplate getTemplateById(String sid, long templateId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).getTemplateById(sid, templateId);
    }

    @Override
    public void setAttributeOptions(String sid, long setId, String attribute, List<WSAttributeOption> options) throws WebserviceException, PersistenceException {
        ((DocumentMetadataService)this.client).setAttributeOptions(sid, setId, attribute, options);
    }

    @Override
    public List<String> getAttributeOptions(String sid, long setId, String attribute) throws AuthenticationException, WebserviceException, PersistenceException {
        List<String> options = ((DocumentMetadataService)this.client).getAttributeOptions(sid, setId, attribute);
        if (options != null) {
            return options;
        }
        return new ArrayList<String>();
    }

    @Override
    public List<WSAttributeOption> getAttributeOptionsByCategory(String sid, long setId, String attribute, String category) throws AuthenticationException, WebserviceException, PersistenceException {
        List<WSAttributeOption> options = ((DocumentMetadataService)this.client).getAttributeOptionsByCategory(sid, setId, attribute, category);
        if (options != null) {
            return options;
        }
        return new ArrayList<WSAttributeOption>();
    }

    @Override
    public List<WSAttributeSet> listAttributeSets(String sid) throws AuthenticationException, WebserviceException, PersistenceException {
        List<WSAttributeSet> sets = ((DocumentMetadataService)this.client).listAttributeSets(sid);
        if (sets != null) {
            return sets;
        }
        return new ArrayList<WSAttributeSet>();
    }

    @Override
    public WSAttributeSet getAttributeSet(String sid, String name) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).getAttributeSet(sid, name);
    }

    @Override
    public WSAttributeSet getAttributeSetById(String sid, long setId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).getAttributeSetById(sid, setId);
    }

    @Override
    public long storeAttributeSet(String sid, WSAttributeSet attributeSet) throws WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).storeAttributeSet(sid, attributeSet);
    }

    @Override
    public void deleteAttributeSet(String sid, long setId) throws WebserviceException, PersistenceException {
        ((DocumentMetadataService)this.client).deleteAttributeSet(sid, setId);
    }

    @Override
    public boolean isReadable(String sid, long templateId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).isReadable(sid, templateId);
    }

    @Override
    public boolean isWritable(String sid, long templateId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentMetadataService)this.client).isWritable(sid, templateId);
    }

    @Override
    public void addAttributeOption(String sid, long setId, String attribute, WSAttributeOption wsoption) throws AuthenticationException, WebserviceException, PersistenceException {
        ((DocumentMetadataService)this.client).addAttributeOption(sid, setId, attribute, wsoption);
    }

    @Override
    public List<WSAccessControlEntry> getAccessControlList(String sid, long templateId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        List<WSAccessControlEntry> acl = ((DocumentMetadataService)this.client).getAccessControlList(sid, templateId);
        if (acl != null) {
            return acl;
        }
        return new ArrayList<WSAccessControlEntry>();
    }

    @Override
    public void setAccessControlList(String sid, long templateId, List<WSAccessControlEntry> acl) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException {
        ((DocumentMetadataService)this.client).setAccessControlList(sid, templateId, acl);
    }
}

