/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.client;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSLink;
import com.logicaldoc.webservice.model.WSNote;
import com.logicaldoc.webservice.model.WSRating;
import com.logicaldoc.webservice.soap.DocumentService;
import com.logicaldoc.webservice.soap.client.SoapClient;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.jws.WebService;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@WebService(name="Document", serviceName="Document")
public class SoapDocumentClient
extends SoapClient<DocumentService>
implements DocumentService {
    public SoapDocumentClient(String endpoint, int gzipThreshold, boolean log, int timeout) {
        super(endpoint, DocumentService.class, gzipThreshold, log, timeout);
    }

    public SoapDocumentClient(String endpoint) {
        super(endpoint, DocumentService.class, -1, true, -1);
    }

    @Override
    public WSDocument create(String sid, WSDocument document, DataHandler content) throws AuthenticationException, PermissionException, IOException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).create(sid, document, content);
    }

    public WSDocument create(String sid, WSDocument document, File content) throws AuthenticationException, PermissionException, IOException, WebserviceException, PersistenceException {
        if (StringUtils.isEmpty(document.getFileName())) {
            document.setFileName(content.getName());
        }
        return this.create(sid, document, new DataHandler((DataSource)new FileDataSource(content)));
    }

    @Override
    public void checkout(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).checkout(sid, docId);
    }

    @Override
    public void delete(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).delete(sid, docId);
    }

    @Override
    public WSDocument getDocument(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        return ((DocumentService)this.client).getDocument(sid, docId);
    }

    @Override
    public WSDocument getDocumentByCustomId(String sid, String customId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).getDocumentByCustomId(sid, customId);
    }

    @Override
    public void lock(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((DocumentService)this.client).lock(sid, docId);
    }

    @Override
    public void move(String sid, long docId, long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((DocumentService)this.client).move(sid, docId, folderId);
    }

    @Override
    public WSDocument copy(String sid, long docId, long folderId, boolean links, boolean notes, boolean security) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        return ((DocumentService)this.client).copy(sid, docId, folderId, links, notes, security);
    }

    @Override
    public void unlock(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((DocumentService)this.client).unlock(sid, docId);
    }

    @Override
    public void update(String sid, WSDocument document) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((DocumentService)this.client).update(sid, document);
    }

    @Override
    public void checkin(String sid, long docId, String comment, String filename, boolean release, DataHandler content) throws AuthenticationException, PermissionException, IOException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).checkin(sid, docId, comment, filename, release, content);
    }

    public void checkin(String sid, long docId, String comment, String filename, boolean release, File content) throws AuthenticationException, PermissionException, IOException, WebserviceException, PersistenceException {
        this.checkin(sid, docId, comment, filename, release, new DataHandler((DataSource)new FileDataSource(content)));
    }

    @Override
    public void checkinDocument(String sid, long docId, String comment, String filename, boolean release, WSDocument docVO, DataHandler content) throws AuthenticationException, PermissionException, IOException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).checkinDocument(sid, docId, comment, filename, release, docVO, content);
    }

    public void checkinDocument(String sid, long docId, String comment, String filename, boolean release, WSDocument docVO, File content) throws AuthenticationException, PermissionException, IOException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).checkinDocument(sid, docId, comment, filename, release, docVO, new DataHandler((DataSource)new FileDataSource(content)));
    }

    @Override
    public DataHandler getContent(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        return ((DocumentService)this.client).getContent(sid, docId);
    }

    @Override
    public DataHandler getVersionContent(String sid, long docId, String version) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        return ((DocumentService)this.client).getVersionContent(sid, docId, version);
    }

    @Override
    public DataHandler getResource(String sid, long docId, String fileVersion, String suffix) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        return ((DocumentService)this.client).getResource(sid, docId, fileVersion, suffix);
    }

    public void downloadContent(String sid, long docId, File out) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        DataHandler data = ((DocumentService)this.client).getContent(sid, docId);
        data.writeTo((OutputStream)new FileOutputStream(out));
    }

    public void downloadVersionContent(String sid, long docId, String version, File out) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        DataHandler data = ((DocumentService)this.client).getVersionContent(sid, docId, version);
        data.writeTo((OutputStream)new FileOutputStream(out));
    }

    public void downloadResourceContent(String sid, long docId, String fileVersion, String suffix, File out) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        DataHandler data = ((DocumentService)this.client).getResource(sid, docId, fileVersion, suffix);
        data.writeTo((OutputStream)new FileOutputStream(out));
    }

    @Override
    public void restore(String sid, long docId, long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).restore(sid, docId, folderId);
    }

    @Override
    public void rename(String sid, long docId, String name) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((DocumentService)this.client).rename(sid, docId, name);
    }

    @Override
    public List<WSDocument> getDocuments(String sid, List<Long> docIds) throws AuthenticationException, WebserviceException, PersistenceException {
        List<WSDocument> documents = ((DocumentService)this.client).getDocuments(sid, docIds);
        if (documents != null) {
            return documents;
        }
        return new ArrayList<WSDocument>();
    }

    @Override
    public List<WSDocument> getRecentDocuments(String sid, Integer max) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).getRecentDocuments(sid, max);
    }

    @Override
    public void sendEmail(String sid, List<Long> docIds, String recipients, String subject, String message) throws AuthenticationException, WebserviceException, PersistenceException, IOException, MessagingException {
        ((DocumentService)this.client).sendEmail(sid, docIds, recipients, subject, message);
    }

    @Override
    public WSDocument createAlias(String sid, long docId, long folderId, String type) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).createAlias(sid, docId, folderId, type);
    }

    @Override
    public void reindex(String sid, long docId, String content) throws AuthenticationException, WebserviceException, PersistenceException, ParsingException {
        ((DocumentService)this.client).reindex(sid, docId, content);
    }

    @Override
    public List<WSDocument> listDocuments(String sid, long folderId, String fileName) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        List<WSDocument> documents = ((DocumentService)this.client).listDocuments(sid, folderId, fileName);
        if (documents != null) {
            return documents;
        }
        return new ArrayList<WSDocument>();
    }

    @Override
    public List<WSDocument> list(String sid, long folderId, String fileName, String sort, Integer page, Integer max) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        List<WSDocument> documents = ((DocumentService)this.client).list(sid, folderId, fileName, sort, page, max);
        if (documents != null) {
            return documents;
        }
        return new ArrayList<WSDocument>();
    }

    @Override
    public List<WSDocument> getAliases(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        List<WSDocument> documents = ((DocumentService)this.client).getAliases(sid, docId);
        if (documents != null) {
            return documents;
        }
        return new ArrayList<WSDocument>();
    }

    @Override
    public WSLink link(String sid, long doc1, long doc2, String type) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        return ((DocumentService)this.client).link(sid, doc1, doc2, type);
    }

    @Override
    public List<WSLink> getLinks(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        List<WSLink> links = ((DocumentService)this.client).getLinks(sid, docId);
        if (links != null) {
            return links;
        }
        return new ArrayList<WSLink>();
    }

    @Override
    public void deleteLink(String sid, long id) throws AuthenticationException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).deleteLink(sid, id);
    }

    @Override
    public void createPdf(String sid, long docId, String fileVersion) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        ((DocumentService)this.client).createPdf(sid, docId, fileVersion);
    }

    @Override
    public void createThumbnail(String sid, long docId, String fileVersion, String type) throws AuthenticationException, WebserviceException, PersistenceException, IOException {
        ((DocumentService)this.client).createThumbnail(sid, docId, fileVersion, type);
    }

    @Override
    public void uploadResource(String sid, long docId, String fileVersion, String suffix, DataHandler content) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        ((DocumentService)this.client).uploadResource(sid, docId, fileVersion, suffix, content);
    }

    public void uploadResource(String sid, long docId, String fileVersion, String suffix, File content) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        this.uploadResource(sid, docId, fileVersion, suffix, new DataHandler((DataSource)new FileDataSource(content)));
    }

    @Override
    public String getExtractedText(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).getExtractedText(sid, docId);
    }

    @Override
    public String createDownloadTicket(String sid, long docId, String suffix, Integer expireHours, String expireDate, Integer maxDownloads) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        return ((DocumentService)this.client).createDownloadTicket(sid, docId, suffix, expireHours, expireDate, maxDownloads);
    }

    @Override
    public String createViewTicket(String sid, long docId, String suffix, Integer expireHours, String expireDate, Integer maxDownloads, Integer maxViews) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        return ((DocumentService)this.client).createViewTicket(sid, docId, suffix, expireHours, expireDate, maxDownloads, maxViews);
    }

    @Override
    public void setPassword(String sid, long docId, String password) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((DocumentService)this.client).setPassword(sid, docId, password);
    }

    @Override
    public void unsetPassword(String sid, long docId, String currentPassword) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        ((DocumentService)this.client).unsetPassword(sid, docId, currentPassword);
    }

    @Override
    public boolean unprotect(String sid, long docId, String password) throws PersistenceException, AuthenticationException, WebserviceException {
        return ((DocumentService)this.client).unprotect(sid, docId, password);
    }

    @Override
    public WSNote addNote(String sid, long docId, String note) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        return ((DocumentService)this.client).addNote(sid, docId, note);
    }

    @Override
    public void deleteNote(String sid, long noteId) throws AuthenticationException, WebserviceException, PersistenceException {
        ((DocumentService)this.client).deleteNote(sid, noteId);
    }

    @Override
    public List<WSNote> getNotes(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        return ((DocumentService)this.client).getNotes(sid, docId);
    }

    @Override
    public WSRating rateDocument(String sid, long docId, int vote) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        return ((DocumentService)this.client).rateDocument(sid, docId, vote);
    }

    @Override
    public List<WSRating> getRatings(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        List<WSRating> ratings = ((DocumentService)this.client).getRatings(sid, docId);
        if (ratings != null) {
            return ratings;
        }
        return new ArrayList<WSRating>();
    }

    @Override
    public String deleteVersion(String sid, long docId, String version) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).deleteVersion(sid, docId, version);
    }

    @Override
    public void replaceFile(String sid, long docId, String fileVersion, String comment, DataHandler content) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException, UnexistingResourceException {
        ((DocumentService)this.client).replaceFile(sid, docId, fileVersion, comment, content);
    }

    public void replaceFile(String sid, long docId, String fileVersion, String comment, File content) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException, UnexistingResourceException {
        ((DocumentService)this.client).replaceFile(sid, docId, fileVersion, comment, new DataHandler((DataSource)new FileDataSource(content)));
    }

    @Override
    public void promoteVersion(String sid, long docId, String version) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException, UnexistingResourceException {
        ((DocumentService)this.client).promoteVersion(sid, docId, version);
    }

    @Override
    public WSNote saveNote(String sid, long docId, WSNote note) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        return ((DocumentService)this.client).saveNote(sid, docId, note);
    }

    @Override
    public long upload(String sid, Long docId, Long folderId, boolean release, String filename, String language, DataHandler content) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        return ((DocumentService)this.client).upload(sid, docId, folderId, release, filename, language, content);
    }

    @Override
    public List<WSDocument> getVersions(String sid, long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        List<WSDocument> versions = ((DocumentService)this.client).getVersions(sid, docId);
        if (versions != null) {
            return versions;
        }
        return new ArrayList<WSDocument>();
    }

    @Override
    public WSDocument getVersion(String sid, long docId, String version) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        return ((DocumentService)this.client).getVersion(sid, docId, version);
    }

    @Override
    public boolean isRead(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).isRead(sid, docId);
    }

    @Override
    public boolean isWrite(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).isWrite(sid, docId);
    }

    @Override
    public boolean isDownload(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).isDownload(sid, docId);
    }

    @Override
    public boolean isGranted(String sid, long docId, String permission) throws AuthenticationException, WebserviceException, PersistenceException {
        return ((DocumentService)this.client).isGranted(sid, docId, permission);
    }

    @Override
    public List<WSAccessControlEntry> getAccessControlList(String sid, long docId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        List<WSAccessControlEntry> acl = ((DocumentService)this.client).getAccessControlList(sid, docId);
        if (acl != null) {
            return acl;
        }
        return new ArrayList<WSAccessControlEntry>();
    }

    @Override
    public void setAccessControlList(String sid, long docId, List<WSAccessControlEntry> acl) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException {
        ((DocumentService)this.client).setAccessControlList(sid, docId, acl);
    }
}

