/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap.client;

import com.logicaldoc.util.security.EasyX509TrustManager;
import javax.net.ssl.TrustManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public abstract class SoapClient<T> {
    protected T client;
    protected String endpoint;

    protected SoapClient(String endpoint, Class<T> serviceClass, int gzipThreshold, boolean log, int timeout) {
        this.endpoint = endpoint;
        this.initClient(serviceClass, gzipThreshold, log);
        if (endpoint.toLowerCase().startsWith("https")) {
            this.configureSSL();
        }
        this.configureTimeout(timeout);
    }

    protected void initClient(Class<T> serviceClass, int gzipThreshold, boolean log) {
        System.setProperty("org.apache.cxf.stax.allowInsecureParser", "true");
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        if (log) {
            LoggingFeature loggingFeature = new LoggingFeature();
            loggingFeature.setPrettyLogging(true);
            loggingFeature.setVerbose(false);
            loggingFeature.setLogMultipart(true);
            factory.getFeatures().add(loggingFeature);
        }
        if (gzipThreshold >= 0) {
            factory.getInInterceptors().add(new GZIPInInterceptor());
            factory.getOutInterceptors().add(new GZIPOutInterceptor(gzipThreshold));
        }
        factory.setServiceClass(serviceClass);
        factory.setAddress(this.endpoint);
        this.client = factory.create();
    }

    protected void configureSSL() {
        TLSClientParameters tlsParams = new TLSClientParameters();
        tlsParams.setDisableCNCheck(true);
        tlsParams.setTrustManagers(new TrustManager[]{new EasyX509TrustManager()});
        Client cl = ClientProxy.getClient(this.client);
        HTTPConduit httpConduit = (HTTPConduit)cl.getConduit();
        httpConduit.setTlsClientParameters(tlsParams);
    }

    protected void configureTimeout(int timeout) {
        if (timeout <= 0) {
            return;
        }
        HTTPClientPolicy policy = new HTTPClientPolicy();
        policy.setConnectionTimeout((long)timeout * 1000L);
        policy.setReceiveTimeout((long)timeout * 1000L);
        Client cl = ClientProxy.getClient(this.client);
        HTTPConduit httpConduit = (HTTPConduit)cl.getConduit();
        httpConduit.setClient(policy);
    }
}

