/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.model.WSTagCloud;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import java.util.List;

@WSDoc(description="Tags management and search")
@WebService(name="Tag", serviceName="Tag", targetNamespace="http://ws.logicaldoc.com")
public interface TagService {
    @WebMethod(action="setDocumentTags")
    @WSDoc(description="sets the tags of a document")
    public void setDocumentTags(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="identifier of the document", required=true) @WebParam(name="docId") long var2, @WebParam(name="tag") List<String> var4) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @WebMethod(action="addDocumentTags")
    @WSDoc(description="adds tags to a document")
    public void addDocumentTags(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="identifier of the document", required=true) @WebParam(name="docId") long var2, @WebParam(name="tag") List<String> var4) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @WebMethod(action="getDocumentTags")
    @WebResult(name="tag")
    @WSDoc(description="retrieves all the tags of a document")
    public List<String> getDocumentTags(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="identifier of the document", required=true) @WebParam(name="docId") long var2) throws PermissionException, PersistenceException, AuthenticationException, WebserviceException, UnexistingResourceException;

    @WebMethod(action="setFolderTags")
    @WSDoc(description="sets the tags of a folder")
    public void setFolderTags(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WebParam(name="tag") List<String> var4) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @WebMethod(action="addFolderTags")
    @WSDoc(description="adds tags to a folder")
    public void addFolderTags(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WebParam(name="tag") List<String> var4) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @WebMethod(action="getFolderTags")
    @WebResult(name="tag")
    @WSDoc(description="retrieves all the tags of a folder")
    public List<String> getFolderTags(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws PermissionException, PersistenceException, AuthenticationException, WebserviceException;

    @WebMethod(action="getTags")
    @WebResult(name="tag")
    @WSDoc(description="retrieves all the tags in the repository")
    public List<String> getTags(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1) throws PersistenceException, AuthenticationException, WebserviceException;

    @WebMethod(action="getTagsPreset")
    @WebResult(name="tag")
    @WSDoc(description="retrieves all the tags specified in the preset, empty if input mode is free")
    public List<String> getTagsPreset(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getTagCloud")
    @WebResult(name="tagCloud")
    @WSDoc(description="retrieves all tag clouds in the repository")
    public List<WSTagCloud> getTagCloud(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1) throws PersistenceException, AuthenticationException, WebserviceException;

    @WebMethod(action="findDocumentsByTag")
    @WebResult(name="document")
    @WSDoc(description="finds authorized documents for the current user having a specified tag")
    public List<WSDocument> findDocumentsByTag(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="tag") String var2) throws PersistenceException, AuthenticationException, WebserviceException;

    @WebMethod(action="findFoldersByTag")
    @WebResult(name="folder")
    @WSDoc(description="finds authorized folders for the current user having a specified tag")
    public List<WSFolder> findFoldersByTag(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="tag") String var2) throws AuthenticationException, WebserviceException, PersistenceException;
}

