/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSGroup;
import com.logicaldoc.webservice.model.WSUser;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import java.util.List;

@WSDoc(description="users and groups handling")
@WebService(name="Security", serviceName="Security", targetNamespace="http://ws.logicaldoc.com")
public interface SecurityService {
    @WebMethod(action="listUsers")
    @WebResult(name="user")
    @WSDoc(description="gets all existing users")
    public List<WSUser> listUsers(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1, @WSDoc(description="if not null, all the users that belong to this group will be returned") @WebParam(name="group") String var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="listGroups")
    @WebResult(name="group")
    @WSDoc(description="gets all existing groups")
    public List<WSGroup> listGroups(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1) throws WebserviceException, PersistenceException;

    @WebResult(name="userId")
    @WebMethod(action="storeUser")
    @WSDoc(description="creates/updates a user; you can completely customize the user through a value object containing the user's metadata;<br/>the current user must be an administrator;<br/>returns the identifier of the created/updated user")
    public long storeUser(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1, @WebParam(name="user") WSUser var2) throws WebserviceException, PersistenceException;

    @WebResult(name="groupId")
    @WebMethod(action="storeGroup")
    @WSDoc(description="creates/updates a group; you can completely customize the group through a value object containing the group's metadata;<br/>the current user must be an administrator;<br/>returns the identifier of the created/updated user")
    public long storeGroup(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1, @WebParam(name="group") WSGroup var2) throws WebserviceException, PersistenceException;

    @WebMethod(action="deleteUser")
    @WSDoc(description="deletes an existing user")
    public void deleteUser(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="userId") long var2) throws WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="deleteGroup")
    @WSDoc(description="deletes an existing group")
    public void deleteGroup(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="groupId") long var2) throws PermissionException, PersistenceException, WebserviceException;

    @WebResult(name="changeResult")
    @WebMethod(action="changePassword")
    @WSDoc(description="changes the password of a user.<br/><b>0</b> if all is ok, <b>1</b> if the password is incorrect, <b>2</b> if the new password cannot be notified, otherwise a positive number grater than <b>2</b>")
    public int changePassword(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1, @WebParam(name="userId") long var2, @WebParam(name="oldPassword") String var4, @WebParam(name="newPassword") String var5) throws WebserviceException, PersistenceException;

    @WebResult(name="user")
    @WebMethod(action="getUser")
    @WSDoc(description="gets an existing user")
    public WSUser getUser(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1, @WebParam(name="userId") long var2) throws WebserviceException, PersistenceException;

    @WebResult(name="user")
    @WebMethod(action="getUserByUsername")
    @WSDoc(description="finds a user by his username")
    public WSUser getUserByUsername(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1, @WebParam(name="username") String var2) throws WebserviceException, PersistenceException;

    @WebResult(name="group")
    @WebMethod(action="getGroup")
    @WSDoc(description="gets an existing group")
    public WSGroup getGroup(@WSDoc(description="identifier of the session, must be an administrator", required=true) @WebParam(name="sid") String var1, @WebParam(name="groupId") long var2) throws WebserviceException, PersistenceException;
}

