/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSFolder;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import java.util.List;

@WebService(name="Folder", serviceName="Folder", targetNamespace="http://ws.logicaldoc.com")
@WSDoc(description="folders handling and CRUD operations")
public interface FolderService {
    @WebMethod(action="create")
    @WebResult(name="folder")
    @WSDoc(description="Creates a new folder; returns the newly created folder")
    public WSFolder create(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="definition of the new folder") @WebParam(name="folder") WSFolder var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="createAlias")
    @WebResult(name="folder")
    @WSDoc(description="creates a new folder alias; returns the newly created alias")
    public WSFolder createAlias(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="identifier of the folder in which the alias will be created") long var2, @WSDoc(description="identifier of the referenced folder") long var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="createFolder")
    @WebResult(name="folderId")
    @WSDoc(description="creates a new folder; returns the newly created folder")
    public long createFolder(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="parentId") long var2, @WebParam(name="name") String var4) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @WebMethod(action="delete")
    @WSDoc(description="deletes an existing folder")
    public void delete(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="rename")
    @WSDoc(description="renames an existing folder")
    public void rename(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="the new folder's name") @WebParam(name="name") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="update")
    @WSDoc(description="updates an existing folder; you need the RENAME permission")
    public void update(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folder") WSFolder var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="move")
    @WSDoc(description="moves an existing folder with the given identifier")
    public void move(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="the new folder's parent") @WebParam(name="parentId") long var4) throws PersistenceException, AuthenticationException, WebserviceException, PermissionException;

    @WebMethod(action="merge")
    @WSDoc(description="merges the contents of folder into a target")
    public void merge(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="sourceId") long var2, @WebParam(name="targetId") long var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="copy")
    @WSDoc(description="copies an existing folder into another location")
    public void copy(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="the new folder's parent") @WebParam(name="targetId") long var4, @WSDoc(description="<b>0</b> = copy folders and files, <b>1</b> = copy just folders") @WebParam(name="foldersOnly") int var6, @WSDoc(description="<b>null</b> or </b>none</b> = no sec. policies are created, <b>inherit</b>: the new folder will point to the parent for the security policies, <b>replicate</b> = sec. policies are inherited from the new parent folder") @WebParam(name="securityOption") String var7) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="getFolder")
    @WebResult(name="folder")
    @WSDoc(description="gets an existing folder")
    public WSFolder getFolder(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="getRootFolder")
    @WebResult(name="folder")
    @WSDoc(description="gets the root folder")
    public WSFolder getRootFolder(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getDefaultWorkspace")
    @WebResult(name="workspace")
    @WSDoc(description="gets the default workspace")
    public WSFolder getDefaultWorkspace(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="listChildren")
    @WebResult(name="folder")
    @WSDoc(description="lists all direct children of a parent folder: readable only sub-folders are returned")
    public List<WSFolder> listChildren(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="listChildren")
    @WebResult(name="folder")
    @WSDoc(description="lists all direct children of a parent folder: readable sub-folders only are returned")
    public List<WSFolder> list(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="Optional sort criteria (eg creation asc)") @WebParam(name="sort") String var4, @WSDoc(description="Optional page number") @WebParam(name="page") Integer var5, @WSDoc(description="Optional maximum number of elements per page") @WebParam(name="max") Integer var6) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="isReadable")
    @WSDoc(description="tests if a folder is readable")
    public boolean isReadable(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="isWritable")
    @WSDoc(description="tests if a folder is writable")
    public boolean isWritable(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="isGranted")
    @WSDoc(description="tests if the current user has a specific permission on a folder")
    public boolean isGranted(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="the permissions' integer representation") @WebParam(name="permission") String var4) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getPath")
    @WebResult(name="folders")
    @WSDoc(description="computes the path from the root to the target folder; returns the array of folders, the first is the root")
    public List<WSFolder> getPath(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="setAccessControlList")
    @WSDoc(description="sets the Access Control List")
    public void setAccessControlList(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="the complete Access Control List") @WebParam(name="acl") List<WSAccessControlEntry> var4) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException;

    @WebMethod(action="getAccessControlList")
    @WSDoc(description="retrieves the access control list")
    public List<WSAccessControlEntry> getAccessControlList(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="createPath")
    @WebResult(name="folder")
    @WSDoc(description="creates the folder for the specified path; all unexisting nodes will be created")
    public WSFolder createPath(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="parentId") long var2, @WSDoc(description="the folder's path(for example /Default/dog/cat/mouse)") @WebParam(name="path") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="findByPath")
    @WebResult(name="folder")
    @WSDoc(description="finds the folder at the specified path")
    public WSFolder findByPath(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the folder's path(for example /Default/dog/cat/mouse)") @WebParam(name="path") String var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="listWorkspaces")
    @WebResult(name="workspaces")
    @WSDoc(description="retrieves the list of all workspaces")
    public List<WSFolder> listWorkspaces(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1) throws AuthenticationException, WebserviceException, PersistenceException;
}

