/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSLink;
import com.logicaldoc.webservice.model.WSNote;
import com.logicaldoc.webservice.model.WSRating;
import jakarta.activation.DataHandler;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.List;

@WSDoc(description="documents handling and CRUD operations")
@WebService(name="Document", serviceName="Document", targetNamespace="http://ws.logicaldoc.com")
public interface DocumentService {
    @WebMethod(action="create")
    @WebResult(name="document")
    @WSDoc(description="creates a new document; the user can completely customize the document through a value object containing the document's metadata; returns the newly created document.")
    public WSDocument create(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="document") WSDocument var2, @WSDoc(description="the raw content of the file") @WebParam(name="content") DataHandler var3) throws IOException, AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @WebMethod(action="delete")
    @WSDoc(description="deletes an existing document with the given identifier")
    public void delete(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="lock")
    @WSDoc(description="locks an existing document with the given identifier")
    public void lock(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID", required=true) @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="unlock")
    @WSDoc(description="unlocks an existing document with the given identifier")
    public void unlock(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="identifier of the document", required=true) @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="rename")
    @WSDoc(description="renames the title of an existing document with the given identifier")
    public void rename(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID", required=true) @WebParam(name="docId") long var2, @WebParam(name="name") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="move")
    @WSDoc(description="moves an existing document with the given identifier")
    public void move(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID") @WebParam(name="docId") long var2, @WSDoc(description="identifier of the new document's folder") @WebParam(name="folderId") long var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="copy")
    @WebResult(name="document")
    @WSDoc(description="copies a document into a folder")
    public WSDocument copy(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID") @WebParam(name="docId") long var2, @WSDoc(description="identifier of the new document's folder") @WebParam(name="folderId") long var4, @WSDoc(description="if the links must be copied too") @WebParam(name="links") boolean var6, @WSDoc(description="if the notes and annotations must be copied too") @WebParam(name="notes") boolean var7, @WSDoc(description="if the security settings must be copied too") @WebParam(name="security") boolean var8) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException;

    @WebMethod(action="getDocument")
    @WebResult(name="document")
    @WSDoc(description="gets the metadata of an existing document with the given identifier; returns the document's representation")
    public WSDocument getDocument(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="getDocumentByCustomId")
    @WebResult(name="document")
    @WSDoc(description="gets document metadata of an existing document with the given custom identifier")
    public WSDocument getDocumentByCustomId(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="customId") String var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="getDocuments")
    @WebResult(name="documents")
    @WSDoc(description="gets document metadata of a collection of existing documents with the given identifiers; returns an array of WSDocument")
    public List<WSDocument> getDocuments(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docIds") List<Long> var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getAliases")
    @WebResult(name="aliases")
    @WSDoc(description="gets the aliases of the given document; returns an array of WSDocument that are aliases")
    public List<WSDocument> getAliases(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="update")
    @WSDoc(description="updates an existing document with the value object containing the document's metadata")
    public void update(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="document") WSDocument var2) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @WebMethod(action="getContent")
    @WSDoc(description="gets the content of an existing document with the given identifier; returns the raw content of the file")
    public DataHandler getContent(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="Document ID") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException;

    @WebMethod(action="getExtractedText")
    @WebResult(name="text")
    @WSDoc(description="gets the document's text stored in the full-text index")
    public String getExtractedText(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getVersionContent")
    @WSDoc(description="gets the content of a specific version of a document; returns the raw content of the file")
    public DataHandler getVersionContent(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the version to retrieve, eg: '1.0', '2.3'") @WebParam(name="version") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException;

    @WebMethod(action="getResource")
    @WSDoc(description="gets the content of a resource associated to the given document; returns the raw content of the file")
    public DataHandler getResource(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the file version to retrieve, eg: '1.0', '2.3'") @WebParam(name="fileVersion") String var4, @WSDoc(description="suffix specification(it cannot be empty, use 'conversion.pdf' to get the PDF conversion)") @WebParam(name="suffix") String var5) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException;

    @WebMethod(action="checkout")
    @WSDoc(description="checks out an existing document with the given identifier")
    public void checkout(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="checkin")
    @WSDoc(description="checks in an existing document to create a new version")
    public void checkin(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="comment") String var4, @WebParam(name="filename") String var5, @WSDoc(description="true if this is a new release(eg: 2.0) rather than a subversion(eg: 1.1)") @WebParam(name="release") boolean var6, @WebParam(name="content") DataHandler var7) throws IOException, AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @WebMethod(action="checkinDocument")
    @WSDoc(description="checks in an existing document to create a new version and also updates the metadata")
    public void checkinDocument(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="comment") String var4, @WebParam(name="filename") String var5, @WSDoc(description="true if this is a new release(eg: 2.0) rather than a subversion(eg: 1.1)") @WebParam(name="release") boolean var6, @WSDoc(description="optional, contains the metadata to update during the checkin") @WebParam(name="docVO") WSDocument var7, @WebParam(name="content") DataHandler var8) throws IOException, AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @WebMethod(action="replaceFile")
    @WSDoc(description="replaces the file associated to a given version")
    public void replaceFile(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="fileVersion") String var4, @WebParam(name="comment") String var5, @WebParam(name="content") DataHandler var6) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException, UnexistingResourceException;

    @WebMethod(action="promoteVersion")
    @WSDoc(description="promotes an old version to the current default one")
    public void promoteVersion(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="version") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException, UnexistingResourceException;

    @WebMethod(action="upload")
    @WebResult(name="docId")
    @WSDoc(description="creates a new document or updates an existing one; returns the newly created document's ID")
    public long upload(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="id of the document to update") @WebParam(name="docId") Long var2, @WSDoc(description="the folder's id, used in case of creation", required=false) @WebParam(name="folderId") Long var3, @WSDoc(description="true if this is a major release(eg: 2.0) rather than a minor release(eg: 1.12)") @WebParam(name="release") boolean var4, @WSDoc(description="used in case of creation", required=false) @WebParam(name="filename") String var5, @WebParam(name="language") String var6, @WSDoc(description="raw content of the file") @WebParam(name="content") DataHandler var7) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException;

    @WebMethod(action="uploadResource")
    @WSDoc(description="uploads a new resource attached to the given document. If the resource already exists it is overwritten")
    public void uploadResource(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the specific file version", required=false) @WebParam(name="fileVersion") String var4, @WSDoc(description="suffix specification(it cannot be empty, use 'conversion.pdf' to put the PDF conversion)") @WebParam(name="suffix") String var5, @WSDoc(description="raw content of the file") @WebParam(name="content") DataHandler var6) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException;

    @WebMethod(action="restore")
    @WSDoc(description="restores a deleted document")
    public void restore(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="id of the folder in which the document must be restored") @WebParam(name="folderId") long var4) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getVersions")
    @WebResult(name="version")
    @WSDoc(description="gets the versions' history of a document; returns an array of versions")
    public List<WSDocument> getVersions(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="getVersion")
    @WebResult(name="version")
    @WSDoc(description="gets a version of a document; returns the version")
    public WSDocument getVersion(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the version number") @WebParam(name="version") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="listDocuments")
    @WebResult(name="document")
    @WSDoc(description="gets the documents in a specific folder")
    public List<WSDocument> listDocuments(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="file name filter", required=false) @WebParam(name="fileName") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="list")
    @WebResult(name="document")
    @WSDoc(description="gets the documents in a specific folder")
    public List<WSDocument> list(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="folderId") long var2, @WSDoc(description="file name filter", required=false) @WebParam(name="fileName") String var4, @WSDoc(description="Optional sort criteria (eg date asc)") @WebParam(name="sort") String var5, @WSDoc(description="Optional page number") @WebParam(name="page") Integer var6, @WSDoc(description="Optional maximum number of elements per page") @WebParam(name="max") Integer var7) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="getRecentDocuments")
    @WebResult(name="document")
    @WSDoc(description="lists of last modified documents by current user")
    public List<WSDocument> getRecentDocuments(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="max number of returned records", required=false) @WebParam(name="maxHits") Integer var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="sendEmail")
    @WSDoc(description="sends a set of documents as mail attachments")
    public void sendEmail(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docIds") List<Long> var2, @WSDoc(description="comma separated list of email addresses") @WebParam(name="recipients") String var3, @WebParam(name="subject") String var4, @WebParam(name="message") String var5) throws AuthenticationException, WebserviceException, PersistenceException, IOException, MessagingException;

    @WebMethod(action="createAlias")
    @WebResult(name="document")
    @WSDoc(description="creates a new document alias for the given document inside a specified folder")
    public WSDocument createAlias(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the original document's id") @WebParam(name="docId") long var2, @WebParam(name="folderId") long var4, @WSDoc(description="type of the alias (use 'pdf' to create an alias to the PDF conversion)", required=false) @WebParam(name="type") String var6) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="link")
    @WebResult(name="link")
    @WSDoc(description="creates a new link between two documents")
    public WSLink link(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="ID of document 1") @WebParam(name="doc1") long var2, @WSDoc(description="ID of document 2") @WebParam(name="doc2") long var4, @WSDoc(description="type of the link (use 'pdf' to point to the pdf conversion)", required=false) @WebParam(name="type") String var6) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="getLinks")
    @WebResult(name="link")
    @WSDoc(description="gets all the links of a specific document; returns an array of links")
    public List<WSLink> getLinks(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="deleteLink")
    @WSDoc(description="removes an existing link")
    public void deleteLink(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="identifier of the link") @WebParam(name="id") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="reindex")
    @WSDoc(description="re-indexes(or indexes from scratch) a document")
    public void reindex(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the content to be used (if null the file is parsed)", required=false) @WebParam(name="content") String var4) throws AuthenticationException, WebserviceException, PersistenceException, ParsingException;

    @WebMethod(action="createPdf")
    @WSDoc(description="creates the PDF conversion of the given document; if the conversion was already created, nothing will happen")
    public void createPdf(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the specific file version", required=false) @WebParam(name="fileVersion") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, IOException;

    @WebMethod(action="createThumbnail")
    @WSDoc(description="creates the thumbail of the given document; if the thumbnail was already created, nothing will happen")
    public void createThumbnail(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the specific file version", required=false) @WebParam(name="fileVersion") String var4, @WSDoc(description="the thumbnail type(eg: thumbnail, tile, mobile, thumbXXX)", required=false) @WebParam(name="type") String var5) throws AuthenticationException, WebserviceException, PersistenceException, IOException;

    @WebResult(name="ticket")
    @WebMethod(action="createDownloadTicket")
    @WSDoc(description="creates a new download ticket to the original document or it's PDF conversion")
    public String createDownloadTicket(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id", required=true) @WebParam(name="docId") long var2, @WSDoc(description="can be null or 'conversion.pdf'", required=false) @WebParam(name="suffix") String var4, @WSDoc(description="expiration time expressed in hours", required=false) @WebParam(name="expireHours") Integer var5, @WSDoc(description="exact expiration date expressed in the format yyyy-MM-dd", required=false) @WebParam(name="expireDate") String var6, @WSDoc(description="maximum number of downloads allowed", required=false) @WebParam(name="maxDownloads") Integer var7) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebResult(name="ticket")
    @WebMethod(action="createViewTicket")
    @WSDoc(description="creates a new view ticket to the original document or it's PDF conversion")
    public String createViewTicket(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id", required=true) @WebParam(name="docId") long var2, @WSDoc(description="can be null or 'conversion.pdf'", required=false) @WebParam(name="suffix") String var4, @WSDoc(description="expiration time expressed in hours", required=false) @WebParam(name="expireHours") Integer var5, @WSDoc(description="exact expiration date expressed in the format yyyy-MM-dd", required=false) @WebParam(name="expireDate") String var6, @WSDoc(description="maximum number of downloads allowed", required=false) @WebParam(name="maxDownloads") Integer var7, @WSDoc(description="maximum number of views allowed", required=false) @WebParam(name="maxViews") Integer var8) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="setPassword")
    @WSDoc(description="protects with a password the given document")
    public void setPassword(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="password") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="unsetPassword")
    @WSDoc(description="removes the password protection from the document")
    public void unsetPassword(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="currentPassword") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebResult(name="unprotect")
    @WebMethod(action="unprotect")
    @WSDoc(description="unprotects a document that is password protected. If the given password is right, the document remains unprotected for the duration of the session.")
    public boolean unprotect(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="password") String var4) throws PersistenceException, AuthenticationException, WebserviceException;

    @WebMethod(action="addNote")
    @WebResult(name="note")
    @WSDoc(description="adds a new note for the given document")
    public WSNote addNote(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id", required=true) @WebParam(name="docId") long var2, @WebParam(name="note") String var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="saveNote")
    @WebResult(name="note")
    @WSDoc(description="adds/modifies a note for the given document")
    public WSNote saveNote(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="note") WSNote var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="deleteNote")
    @WSDoc(description="deletes a note, only the author or the administrator can delete the note")
    public void deleteNote(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="noteId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getNotes")
    @WebResult(name="note")
    @WSDoc(description="gets the notes for the given document")
    public List<WSNote> getNotes(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="deleteVersion")
    @WebResult(name="latest-version")
    @WSDoc(description="deletes a version of a document with the given identifiers")
    public String deleteVersion(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WSDoc(description="the version to retrieve, eg: '1.0', '2.3'") @WebParam(name="version") String var4) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="rateDocument")
    @WebResult(name="rating")
    @WSDoc(description="rates the given document")
    public WSRating rateDocument(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2, @WebParam(name="vote") int var4) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="getRatings")
    @WebResult(name="rating")
    @WSDoc(description="gets all the ratings of the given document")
    public List<WSRating> getRatings(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WSDoc(description="the document id") @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="setAccessControlList")
    @WSDoc(description="sets the Access Control List")
    public void setAccessControlList(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docId") long var2, @WSDoc(description="the complete Access Control List") @WebParam(name="acl") List<WSAccessControlEntry> var4) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException;

    @WebMethod(action="getAccessControlList")
    @WSDoc(description="retrieves the access control list")
    public List<WSAccessControlEntry> getAccessControlList(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="isRead")
    @WSDoc(description="tests if a document is readable")
    public boolean isRead(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="isWrite")
    @WSDoc(description="tests if a folder is writable")
    public boolean isWrite(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="isDownload")
    @WSDoc(description="tests if a folder is writable")
    public boolean isDownload(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="isGranted")
    @WSDoc(description="tests if the current user has a specific permission on a document")
    public boolean isGranted(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="docId") long var2, @WSDoc(description="the permissions' integer representation") @WebParam(name="permission") String var4) throws AuthenticationException, WebserviceException, PersistenceException;
}

