/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSAttributeOption;
import com.logicaldoc.webservice.model.WSAttributeSet;
import com.logicaldoc.webservice.model.WSTemplate;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import java.util.List;

@WSDoc(description="handling of templates and attribute sets")
@WebService(name="DocumentMetadata", serviceName="DocumentMetadata", targetNamespace="http://ws.logicaldoc.com")
public interface DocumentMetadataService {
    @WebResult(name="template")
    @WebMethod(action="listTemplates")
    @WSDoc(description="lists all the templates")
    public List<WSTemplate> listTemplates(@WebParam(name="sid") String var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebResult(name="template")
    @WebMethod(action="getTemplate")
    @WSDoc(description="gets an existing template by it's name")
    public WSTemplate getTemplate(@WebParam(name="sid") String var1, @WebParam(name="name") String var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebResult(name="template")
    @WebMethod(action="getTemplateById")
    @WSDoc(description="gets an existing template by it's identifier")
    public WSTemplate getTemplateById(@WebParam(name="sid") String var1, @WebParam(name="templateId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebResult(name="templateId")
    @WebMethod(action="storeTemplate")
    @WSDoc(description="creates/updates a template; you can completely customize the template through a value object; returns the identifier of the created/updated template")
    public long storeTemplate(@WebParam(name="sid") String var1, @WebParam(name="template") WSTemplate var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="deleteTemplate")
    @WSDoc(description="deletes an existing template")
    public void deleteTemplate(@WebParam(name="sid") String var1, @WebParam(name="templateId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebResult(name="attributeSet")
    @WebMethod(action="listAttributeSets")
    @WSDoc(description="lists all the attribute sets")
    public List<WSAttributeSet> listAttributeSets(@WebParam(name="sid") String var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebResult(name="attributeSet")
    @WebMethod(action="getAttributeSet")
    @WSDoc(description="gets an attribute set by it's name")
    public WSAttributeSet getAttributeSet(@WebParam(name="sid") String var1, @WebParam(name="name") String var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebResult(name="attributeSet")
    @WebMethod(action="getAttributeSetById")
    @WSDoc(description="gets an attribute set by it's identifier")
    public WSAttributeSet getAttributeSetById(@WebParam(name="sid") String var1, @WebParam(name="setId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebResult(name="setId")
    @WebMethod(action="storeAttributeSet")
    @WSDoc(description="creates/updates an attribute set; you can completely customize the set through a value object; returns the identifier of the created/updated set")
    public long storeAttributeSet(@WebParam(name="sid") String var1, @WebParam(name="attributeSet") WSAttributeSet var2) throws WebserviceException, PersistenceException;

    @WebMethod(action="deleteAttributeSet")
    @WSDoc(description="deletes an existing attribute set")
    public void deleteAttributeSet(@WebParam(name="sid") String var1, @WebParam(name="setId") long var2) throws WebserviceException, PersistenceException;

    @WebMethod(action="setAttributeOptions")
    @WSDoc(description="saves the options for the given attribute")
    public void setAttributeOptions(@WebParam(name="sid") String var1, @WebParam(name="setId") long var2, @WebParam(name="attribute") String var4, @WebParam(name="options") List<WSAttributeOption> var5) throws WebserviceException, PersistenceException;

    @WebMethod(action="getAttributeOptions")
    @WSDoc(description="retrieves the options for the given attribute")
    public List<String> getAttributeOptions(@WebParam(name="sid") String var1, @WebParam(name="setId") long var2, @WebParam(name="attribute") String var4) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="getAttributeOptionsByCategory")
    @WSDoc(description="retrieves the options for the given attribute inside a given category")
    public List<WSAttributeOption> getAttributeOptionsByCategory(@WebParam(name="sid") String var1, @WebParam(name="setId") long var2, @WebParam(name="attribute") String var4, @WebParam(name="category") String var5) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="isReadable")
    @WSDoc(description="tests if a template is readable")
    public boolean isReadable(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="templateId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="isWritable")
    @WSDoc(description="tests if a template is writable")
    public boolean isWritable(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="templateId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="setAccessControlList")
    @WSDoc(description="sets the Access Control List")
    public void setAccessControlList(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="templateId") long var2, @WSDoc(description="the complete Access Control List") @WebParam(name="acl") List<WSAccessControlEntry> var4) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException;

    @WebMethod(action="getAccessControlList")
    @WSDoc(description="retrieves the access control list")
    public List<WSAccessControlEntry> getAccessControlList(@WSDoc(description="identifier of the session", required=true) @WebParam(name="sid") String var1, @WebParam(name="templateId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @WebMethod(action="addAttributeOption")
    @WSDoc(description="Adds a new option for the given attribute")
    public void addAttributeOption(@WebParam(name="sid") String var1, @WebParam(name="setId") long var2, @WebParam(name="attribute") String var4, @WebParam(name="option") WSAttributeOption var5) throws AuthenticationException, WebserviceException, PersistenceException;
}

