/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.soap;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSBookmark;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import java.util.List;

@WSDoc(description="Bookmarks management and search")
@WebService(name="Bookmark", serviceName="Bookmark", targetNamespace="http://ws.logicaldoc.com")
public interface BookmarkService {
    @WebMethod(action="saveBookmark")
    @WebResult(name="bookmark")
    @WSDoc(description="crates or updates a bookmark")
    public WSBookmark saveBookmark(@WebParam(name="sid") String var1, @WebParam(name="bookmark") WSBookmark var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="bookmarkDocument")
    @WebResult(name="bookmark")
    @WSDoc(description="bookmarks a document")
    public WSBookmark bookmarkDocument(@WebParam(name="sid") String var1, @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException, UnexistingResourceException;

    @WebMethod(action="bookmarkFolder")
    @WebResult(name="bookmark")
    @WSDoc(description="bookmarks a folder")
    public WSBookmark bookmarkFolder(@WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @WebMethod(action="getBookmarks")
    @WebResult(name="bookmark")
    @WSDoc(description="retrieves all the bookmarks of the current user")
    public List<WSBookmark> getBookmarks(@WebParam(name="sid") String var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="deleteBookmark")
    @WSDoc(description="deletes a bookmark")
    public void deleteBookmark(@WebParam(name="sid") String var1, @WebParam(name="bookmarkId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="unbookmarkDocument")
    @WSDoc(description="unbookmarks a document")
    public void unbookmarkDocument(@WebParam(name="sid") String var1, @WebParam(name="docId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;

    @WebMethod(action="unbookmarkFolder")
    @WSDoc(description="unbookmarks a folder")
    public void unbookmarkFolder(@WebParam(name="sid") String var1, @WebParam(name="folderId") long var2) throws AuthenticationException, WebserviceException, PersistenceException;
}

