/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.model.WSTagCloud;
import com.logicaldoc.webservice.rest.TagService;
import com.logicaldoc.webservice.soap.endpoint.SoapTagService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;

@Path(value="/")
@Tag(name="tag")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/json"})
public class RestTagService
extends SoapTagService
implements TagService {
    @Override
    @POST
    @Path(value="/setDocumentTags")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Set the tags of a document")
    public void setDocumentTags(@Parameter(description="Document ID", required=true) @FormParam(value="docId") long docId, @FormParam(value="tag") List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        String sid = this.validateSessionREST();
        super.setDocumentTags(sid, docId, tags);
    }

    @Override
    @POST
    @Path(value="/addDocumentTags")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Appends new tags to a document")
    public void addDocumentTags(@Parameter(description="Document ID", required=true) @FormParam(value="docId") long docId, @FormParam(value="tag") List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        String sid = this.validateSessionREST();
        super.addDocumentTags(sid, docId, tags);
    }

    @Override
    @GET
    @Path(value="/getDocumentTags")
    @Operation(summary="Gets all the tags of a document")
    public List<String> getDocumentTags(@Parameter(description="Document ID", required=true) @QueryParam(value="docId") long docId) throws PermissionException, AuthenticationException, PersistenceException, WebserviceException, UnexistingResourceException {
        String sid = this.validateSessionREST();
        return super.getDocumentTags(sid, docId);
    }

    @Override
    @POST
    @Path(value="/setFolderTags")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Sets the tags of a folder")
    public void setFolderTags(@Parameter(description="Folder ID", required=true) @FormParam(value="folderId") long folderId, @FormParam(value="tag") List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.setFolderTags(sid, folderId, tags);
    }

    @Override
    @POST
    @Path(value="/addFolderTags")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Appends new tags to a folder")
    public void addFolderTags(@Parameter(description="Folder ID", required=true) @FormParam(value="folderId") long folderId, @FormParam(value="tag") List<String> tags) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.addFolderTags(sid, folderId, tags);
    }

    @Override
    @GET
    @Path(value="/getFolderTags")
    @Operation(summary="Gets all the tags of a folder")
    public List<String> getFolderTags(@Parameter(description="Folder ID", required=true) @QueryParam(value="folderId") long folderId) throws PermissionException, AuthenticationException, PersistenceException, WebserviceException {
        String sid = this.validateSessionREST();
        return super.getFolderTags(sid, folderId);
    }

    @Override
    @GET
    @Path(value="/getTags")
    @Operation(summary="Gets all the tags used in the sysem")
    public List<String> getTags() throws AuthenticationException, PersistenceException, WebserviceException {
        String sid = this.validateSessionREST();
        return super.getTags(sid);
    }

    @Override
    @GET
    @Path(value="/getTagCloud")
    @Operation(summary="Retrieves all tag clouds in the repository")
    public List<WSTagCloud> getTagCloud() throws AuthenticationException, PersistenceException, WebserviceException {
        String sid = this.validateSessionREST();
        return super.getTagCloud(sid);
    }

    @Override
    @GET
    @Path(value="/findDocumentsByTag")
    @Operation(summary="Finds authorized documents for the current user having a specified tag")
    public List<WSDocument> findDocumentsByTag(@Parameter(description="The tag", required=true) @QueryParam(value="tag") String tag) throws AuthenticationException, PersistenceException, WebserviceException {
        String sid = this.validateSessionREST();
        return super.findDocumentsByTag(sid, tag);
    }

    @Override
    @GET
    @Path(value="/findFoldersByTag")
    @Operation(summary="Finds authorized folders for the current user having a specified tag")
    public List<WSFolder> findFoldersByTag(@Parameter(description="The tag", required=true) @QueryParam(value="tag") String tag) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.findFoldersByTag(sid, tag);
    }

    @Override
    @GET
    @Path(value="/getTagsPreset")
    @Operation(summary="Retrieves all the tags in the preset", description="Retrieves all the tags specified in the preset, empty if input mode is free")
    public List<String> getTagsPreset() throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getTagsPreset(sid);
    }
}

