/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSParameter;
import com.logicaldoc.webservice.model.WSSystemInfo;
import com.logicaldoc.webservice.rest.SystemService;
import com.logicaldoc.webservice.soap.endpoint.SoapSystemService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;

@Path(value="/")
@Tag(name="system")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestSystemService
extends SoapSystemService
implements SystemService {
    @Override
    @GET
    @Path(value="/getInfo")
    @Operation(summary="Get system information", description="Retrieves information about the Installation")
    public WSSystemInfo getInfo() throws WebserviceException {
        return super.getInfo();
    }

    @Override
    @GET
    @Path(value="/getStatistics")
    @Operation(summary="Get system statistics", description="Retrieves the system statistics")
    public List<WSParameter> getStatistics() throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getStatistics(sid);
    }

    @Override
    @GET
    @Path(value="/getTenantStatistics")
    @Operation(summary="Get tenant statistics", description="Retrieves the statistics of a tenant")
    public List<WSParameter> getTenantStatistics(@QueryParam(value="tenantId") long tenantId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getTenantStatistics(sid, tenantId);
    }

    @Override
    @GET
    @Path(value="/getLanguages")
    @Operation(summary="Get enabled languages", description="Retrieves the languages enabled in the server")
    public List<String> getLanguages() {
        String sid = this.validateSessionREST();
        return super.getLanguages(sid);
    }
}

