/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.endpoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.rest.FolderService;
import com.logicaldoc.webservice.soap.endpoint.SoapFolderService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Tag(name="folder")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestFolderService
extends SoapFolderService
implements FolderService {
    private static final Logger log = LoggerFactory.getLogger(RestFolderService.class);

    @Override
    @POST
    @Path(value="/create")
    @Operation(operationId="createFolderByModel", summary="Creates a new folder", description="The 'folder' metadata comes in the POST request body (encoded as JSON). Note: folder object must specify at least fields name and parentId")
    public WSFolder create(@Parameter(description="The folder metadata", required=true, example="{ \"parentId\": 4, \"name\": \"Folder created by REST ws\"}", schema=@Schema(implementation=WSFolder.class)) WSFolder folder) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.create(sid, folder);
    }

    @Override
    @POST
    @Path(value="/createSimpleForm")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Creates folders from path", description="Creates folders using an input path. All the folders in the path will be created. It returns the metadata object representing the latest created folder in the path")
    public WSFolder createSimpleForm(@Parameter(description="The string representing the path to be created", example="/Default/newfolder") @FormParam(value="folderPath") String folderPath) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        WSFolder root = super.getRootFolder(sid);
        return super.createPath(sid, root.getId(), folderPath);
    }

    @Override
    @POST
    @Path(value="/createSimpleJSON")
    @Consumes(value={"application/json"})
    @Operation(summary="Creates folders from path", description="Creates folders using an input path. All the folders in the path will be created. It returns the metadata object representing the latest created folder in the path")
    public WSFolder createSimpleJSON(@Parameter(name="folderPath", description="The string representing the path to be created", example="{\"folderPath\":\"/Default/central/repo\"}") String jsonstr) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        HashMap hm;
        String sid = this.validateSessionREST();
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        try {
            hm = (HashMap)mapper.readValue(jsonstr, (TypeReference)typeRef);
        }
        catch (JsonProcessingException e) {
            throw new WebserviceException(e.getMessage(), e);
        }
        String folderPath = (String)hm.get("folderPath");
        WSFolder root = super.getRootFolder(sid);
        return super.createPath(sid, root.getId(), folderPath);
    }

    @Override
    @POST
    @Path(value="/createSimple")
    @Consumes(value={"text/plain", "application/json"})
    @Operation(summary="Creates folders from path", description="Creates folders using an input path. All the folders in the path will be created. It returns the metadata object representing the latest created folder in the path. Example: curl -u admin:admin -X POST -H ''Content-Type: text/plain'' -H ''Accept: application/json'' -d ''/Default/Curl/newfolder'' http://localhost:8080/services/rest/folder/createSimple")
    public WSFolder createSimple(@Parameter(description="The string representing the path to be created", example="/Default/newfolder") String folderPath) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        log.debug("createSimple()");
        String sid = this.validateSessionREST();
        WSFolder root = super.getRootFolder(sid);
        return super.createPath(sid, root.getId(), folderPath);
    }

    @Override
    @POST
    @Path(value="/createPath")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Creates a path", description="Creates a path of folders starting from a parent folder. It returns the metadata object representing the latest created folder in the path")
    public WSFolder createPath(@Parameter(description="The parent folder ID from which the new path will start") @FormParam(value="parentId") long parentId, @Parameter(description="The path to create", example="How/to/POST/JSON/data/with/Curl") @FormParam(value="path") String path) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.createPath(sid, parentId, path);
    }

    @Override
    @GET
    @Path(value="/findByPath")
    @Produces(value={"application/json"})
    @Operation(summary="Gets a folder", description="Finds the folder at the specified path")
    public WSFolder findByPath(@QueryParam(value="path") String path) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.findByPath(sid, path);
    }

    @Override
    @GET
    @Path(value="/getRootFolder")
    @Produces(value={"application/json"})
    @Operation(summary="Gets the root folder", description="Gets the root folder in the current tenant")
    public WSFolder getRootFolder() throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getRootFolder(sid);
    }

    @Override
    @POST
    @Path(value="/createFolder")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain", "application/json", "application/xml"})
    @Operation(summary="Creates a subfolder")
    public long createFolder(@Parameter(description="The ID of the parent folder") @FormParam(value="parentId") long parentId, @Parameter(description="Name of the new folder") @FormParam(value="name") String name) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.createFolder(sid, parentId, name);
    }

    @Override
    @GET
    @Path(value="/getFolder")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Gets a folder", description="Gets the folder with the specified ID")
    public WSFolder getFolder(@Parameter(description="The folder ID", required=true) @QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getFolder(sid, folderId);
    }

    @Override
    @DELETE
    @Path(value="/delete")
    @Operation(operationId="deleteFolder", summary="Deletes a folder")
    public void delete(@Parameter(description="The ID of the folder to be deleted", required=true) @QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.delete(sid, folderId);
    }

    @Override
    @GET
    @Path(value="/listChildren")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Lists the child folders", description="Returns the list of child folders. Example: curl -u admin:admin -H ''Accept: application/json'' http://localhost:8080/services/rest/folder/listChildren?folderId=4")
    public List<WSFolder> listChildren(@Parameter(description="The ID of the parent folder", required=true) @QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.listChildren(sid, folderId);
    }

    @Override
    @GET
    @Path(value="/list")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Lists the sub-folders", description="Returns the list of child folders. Example: curl -u admin:admin -H ''Accept: application/json'' http://localhost:8080/services/rest/folder/list?folderId=4")
    public List<WSFolder> list(@Parameter(description="The ID of the parent folder", required=true) @QueryParam(value="folderId") long folderId, @QueryParam(value="sort") String sort, @QueryParam(value="page") Integer page, @QueryParam(value="max") Integer max) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.list(sid, folderId, sort, page, max);
    }

    @Override
    @GET
    @Path(value="/getPath")
    @Operation(summary="Gets a path of folders", description="Returns the folders that make up the path to the folder in input")
    public List<WSFolder> getPath(@Parameter(description="Folder identifier (ID)", required=true) @QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getPath(sid, folderId);
    }

    @Override
    @GET
    @Path(value="/getPathString")
    @Operation(summary="Gets a path", description="Returns the path to the folder in input")
    public String getPathString(@Parameter(description="Folder identifier (ID)", required=true) @QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        List<WSFolder> sss = this.getPath(sid, folderId);
        StringBuilder pathString = new StringBuilder();
        for (WSFolder wsFolder : sss) {
            pathString.append("/");
            pathString.append(wsFolder.getName());
        }
        return pathString.toString();
    }

    @Override
    @POST
    @Path(value="/update")
    @Operation(operationId="updateFolder", summary="Updates a folder", description="Updates a folder changing its metadata. The folder object in input must specify the property id")
    public void update(@Parameter(description="A value object with the metadata of the folder to update", example="{ \"id\": 2335253, \"name\": \"Folder updated by REST ws\"}") WSFolder folder) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        log.debug("update()");
        String sid = this.validateSessionREST();
        super.update(sid, folder);
    }

    @Override
    @PUT
    @Path(value="/rename")
    @Operation(operationId="renameFolder", summary="Renames a folder", description="Changes the name of a given folder")
    public void rename(@QueryParam(value="folderId") long folderId, @QueryParam(value="name") String name) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.rename(sid, folderId, name);
    }

    @Override
    @PUT
    @Path(value="/move")
    @Operation(operationId="moveFolder", summary="Moves a folder", description="Updates a folder by changing its parent. The folder is moved to the new parent folder")
    public void move(@QueryParam(value="folderId") long folderId, @QueryParam(value="parentId") long parentId) throws AuthenticationException, PersistenceException, WebserviceException, PermissionException {
        String sid = this.validateSessionREST();
        super.move(sid, folderId, parentId);
    }

    @Override
    @POST
    @Path(value="/createAlias")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(operationId="createAliasFolder", summary="Creates a new folder alias", description="Creates a new alias/simlink of the source folder into the target folder; returns the newly created alias")
    public WSFolder createAlias(@Parameter(description="Folder ID in which the alias will be created (target)") @FormParam(value="parentId") long parentId, @Parameter(description="Folder ID of the referenced folder (source)") @FormParam(value="foldRef") long foldRef) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.createAlias(sid, parentId, foldRef);
    }

    @Override
    @GET
    @Path(value="/getDefaultWorkspace")
    @Operation(summary="Gets the Default workspace")
    public WSFolder getDefaultWorkspace() throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getDefaultWorkspace(sid);
    }

    @Override
    @GET
    @Path(value="/listWorkspaces")
    @Operation(summary="Retrieves the list of all workspaces")
    public List<WSFolder> listWorkspaces() throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.listWorkspaces(sid);
    }

    @Override
    @GET
    @Path(value="/isReadable")
    @Operation(operationId="isReadableFolder", summary="Tests if a folder is readable")
    public boolean isReadable(@QueryParam(value="folderId") long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.isReadable(sid, folderId);
    }

    @Override
    @GET
    @Path(value="/isWritable")
    @Operation(summary="Tests if a folder is writable")
    public boolean isWritable(@QueryParam(value="folderId") long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.isWritable(sid, folderId);
    }

    @Override
    @GET
    @Path(value="/isGranted")
    @Operation(summary="Tests user permission on a folder", description="Tests if the current user has a specific permission on a folder")
    public boolean isGranted(@Parameter(description="Folder identifier (ID)", required=true) @QueryParam(value="folderId") long folderId, @Parameter(description="the permissions' integer representation", required=true) @QueryParam(value="permission") String permission) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.isGranted(sid, folderId, permission);
    }

    @Override
    @POST
    @Path(value="/copy")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Copies a folder", description="Copies an existing folder (source) into the given target; it can copy all the documents contained while defining the inheritance of security policies")
    public void copy(@Parameter(description="Folder identifier (source)", required=true) @FormParam(value="folderId") long folderId, @Parameter(description="The folder ID of the target folder", required=true) @FormParam(value="targetId") long targetId, @Parameter(description="If 1, only the folders will be copied and not the documents", required=true) @FormParam(value="foldersOnly") int foldersOnly, @Parameter(description="<b>null</b> or </b>none</b> = no sec. policies are created, <b>inherit</b>: the new folder will point to the parent for the security policies, <b>replicate</b> = sec. policies are inherited from the new parent folder", required=false) @FormParam(value="securityOption") String securityOption) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        String sid = this.validateSessionREST();
        super.copy(sid, folderId, targetId, foldersOnly, securityOption);
    }

    @Override
    @PUT
    @Path(value="/setAccessControlList")
    @Operation(operationId="setAccessControlList_Folder", summary="Assigns the complete Access Control List")
    public void setAccessControlList(@QueryParam(value="folderId") long folderId, List<WSAccessControlEntry> acl) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException {
        String sid = this.validateSessionREST();
        super.setAccessControlList(sid, folderId, acl);
    }

    @Override
    @GET
    @Path(value="/getAccessControlList")
    @Operation(operationId="getAccessControlList_Folder", summary="Retrieves the access control list")
    public List<WSAccessControlEntry> getAccessControlList(@QueryParam(value="folderId") long folderId) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        String sid = this.validateSessionREST();
        return super.getAccessControlList(sid, folderId);
    }
}

