/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAttributeOption;
import com.logicaldoc.webservice.model.WSAttributeSet;
import com.logicaldoc.webservice.model.WSTemplate;
import com.logicaldoc.webservice.rest.DocumentMetadataService;
import com.logicaldoc.webservice.soap.endpoint.SoapDocumentMetadataService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;

@Path(value="/")
@Tag(name="documentMetadata")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestDocumentMetadataService
extends SoapDocumentMetadataService
implements DocumentMetadataService {
    @Override
    @PUT
    @Path(value="/setAttributeOptions")
    @Operation(summary="Save attribute options", description="Updates the options for the given attribute")
    public void setAttributeOptions(@QueryParam(value="setId") long setId, @QueryParam(value="attribute") String attribute, @QueryParam(value="options") List<WSAttributeOption> options) throws WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.setAttributeOptions(sid, setId, attribute, options);
    }

    @Override
    @POST
    @Path(value="/storeAttributeSet")
    @Operation(summary="Create/Update an attribute set", description="Create/Update an attribute set. You can completely customize the attribute set through a value object containing the attribute set's metadata")
    public long storeAttributeSet(WSAttributeSet attributeSet) throws WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.storeAttributeSet(sid, attributeSet);
    }

    @Override
    @POST
    @Path(value="/storeTemplate")
    @Operation(summary="Create/Update a template", description="Create/Update a template. You can completely customize the template through a value object")
    public long storeTemplate(WSTemplate template) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.storeTemplate(sid, template);
    }

    @Override
    @GET
    @Path(value="/getAttributeSetById")
    @Operation(summary="Gets attribute set's metadata", description="Gets attribute set's metadata. Returns a value object containing the attribute set's metadata")
    public WSAttributeSet getAttributeSetById(@Parameter(description="Attribute set identifier (ID)") @QueryParam(value="setId") long setId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getAttributeSetById(sid, setId);
    }

    @Override
    @GET
    @Path(value="/getAttributeSet")
    @Operation(summary="Gets an attribute set by name", description="Gets an attribute set by name. Returns a value object containing the attribute set's metadata")
    public WSAttributeSet getAttributeSet(@Parameter(description="The attribute set's name") @QueryParam(value="name") String name) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getAttributeSet(sid, name);
    }

    @Override
    @GET
    @Path(value="/getTemplate")
    @Operation(summary="Gets template's metadata", description="Gets an existing template by its name")
    public WSTemplate getTemplate(@Parameter(description="The template name") @QueryParam(value="name") String name) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getTemplate(sid, name);
    }

    @Override
    @GET
    @Path(value="/getTemplateById")
    @Operation(summary="Gets template's metadata", description="Gets an existing template by its identifier")
    public WSTemplate getTemplateById(@Parameter(description="The template identifier (ID)") @QueryParam(value="templateId") long templateId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getTemplateById(sid, templateId);
    }

    @Override
    @GET
    @Path(value="/getAttributeOptions")
    @Operation(summary="Retrieves the options for the given attribute", description="Returns the list of all the attribute's options")
    public List<String> getAttributeOptions(@Parameter(description="Attribute set identifier (ID)") @QueryParam(value="setId") long setId, @Parameter(description="The attribute's name") @QueryParam(value="attribute") String attribute) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getAttributeOptions(sid, setId, attribute);
    }

    @Override
    @GET
    @Path(value="/getAttributeOptionsByCategory")
    @Operation(summary="Retrieves the options for the given attribute and related to the given category", description="Returns the list of all the attribute's options in the given category")
    public List<WSAttributeOption> getAttributeOptionsByCategory(long setId, String attribute, String category) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getAttributeOptionsByCategory(sid, setId, attribute, category);
    }

    @Override
    @GET
    @Path(value="/listAttributeSets")
    @Operation(summary="Lists the attribute sets", description="Gets metadata of all existing attribute sets")
    public List<WSAttributeSet> listAttributeSets() throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.listAttributeSets(sid);
    }

    @Override
    @DELETE
    @Path(value="/deleteAttributeSet")
    @Operation(summary="Deletes an attribute set", description="GDeletes an existing attribute set with the given identifier")
    public void deleteAttributeSet(@Parameter(description="Attribute set identifier (ID)") @QueryParam(value="setId") long setId) throws WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.deleteAttributeSet(sid, setId);
    }

    @Override
    @DELETE
    @Path(value="/deleteTemplate")
    @Operation(summary="Deletes a template", description="Deletes an existing template with the given identifier")
    public void deleteTemplate(@Parameter(description="A template ID") @QueryParam(value="templateId") long templateId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.deleteTemplate(sid, templateId);
    }

    @Override
    @GET
    @Path(value="/listTemplates")
    @Operation(summary="Lists all the templates", description="Gets metadata of all existing templates")
    public List<WSTemplate> listTemplates() throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.listTemplates(sid);
    }

    @Override
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/setAttributeOptionsPOST")
    @Operation(summary="Save attribute options with a POST method", description="Saves the options for the given attribute with a POST method. This is useful for very large lists of values")
    @RequestBody(content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=SetAttributeOptionsMultipartRequest.class))})
    public void setAttributeOptionsPOST(@Multipart(value="setId") Long setId, @Multipart(value="attribute") String attribute, @Multipart(value="options", type="application/json") List<WSAttributeOption> options) throws WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.setAttributeOptions(sid, setId, attribute, options);
    }

    @Override
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/addAttributeOption")
    @Operation(summary="Adds a new attribute option with a POST method", description="Adds the new option for the given attribute with a POST method.")
    public void addAttributeOption(@FormParam(value="setId") long setId, @FormParam(value="attribute") String attribute, @FormParam(value="option") WSAttributeOption option) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.addAttributeOption(sid, setId, attribute, option);
    }

    public class SetAttributeOptionsMultipartRequest {
        @Schema(type="integer", required=true, format="int64", description="Attribute set ID")
        private String setId;
        @Schema(type="string", required=true, description="Attribute name")
        private String attribute;
        private List<WSAttributeOption> options;

        public String getSetId() {
            return this.setId;
        }

        public void setSetId(String setId) {
            this.setId = setId;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public List<WSAttributeOption> getOptions() {
            return this.options;
        }

        public void setOptions(List<WSAttributeOption> options) {
            this.options = options;
        }
    }
}

