/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.endpoint;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSBookmark;
import com.logicaldoc.webservice.rest.BookmarkService;
import com.logicaldoc.webservice.soap.endpoint.SoapBookmarkService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;

@Path(value="/")
@Tag(name="bookmark")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/json"})
public class RestBookmarkService
extends SoapBookmarkService
implements BookmarkService {
    @Override
    @POST
    @Path(value="/saveBookmark")
    public WSBookmark saveBookmark(WSBookmark bookmark) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        String sid = this.validateSessionREST();
        return super.saveBookmark(sid, bookmark);
    }

    @Override
    @GET
    @Path(value="/bookmarkDocument")
    public WSBookmark bookmarkDocument(@QueryParam(value="docId") long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        String sid = this.validateSessionREST();
        return super.bookmarkDocument(sid, docId);
    }

    @Override
    @GET
    @Path(value="/bookmarkFolder")
    public WSBookmark bookmarkFolder(@QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.bookmarkFolder(sid, folderId);
    }

    @Override
    @GET
    @Path(value="/getBookmarks")
    public List<WSBookmark> getBookmarks() throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        return super.getBookmarks(sid);
    }

    @Override
    @DELETE
    @Path(value="/deleteBookmark")
    public void deleteBookmark(@QueryParam(value="bookmarkId") long bookmarkId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.deleteBookmark(sid, bookmarkId);
    }

    @Override
    @DELETE
    @Path(value="/unbookmarkDocument")
    public void unbookmarkDocument(@QueryParam(value="docId") long docId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.unbookmarkDocument(sid, docId);
    }

    @Override
    @DELETE
    @Path(value="/unbookmarkFolder")
    public void unbookmarkFolder(@QueryParam(value="folderId") long folderId) throws AuthenticationException, WebserviceException, PersistenceException {
        String sid = this.validateSessionREST();
        super.unbookmarkFolder(sid, folderId);
    }
}

