/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.endpoint;

import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.webservice.model.WSCredentials;
import com.logicaldoc.webservice.rest.AuthService;
import com.logicaldoc.webservice.soap.endpoint.SoapAuthService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Tag(name="authorize")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/json"})
public class RestAuthService
extends SoapAuthService
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(RestAuthService.class);

    @Override
    @GET
    @Path(value="/login")
    public String login(@QueryParam(value="u") String username, @QueryParam(value="pw") String password) throws AuthenticationException {
        return super.login(username, password);
    }

    @Override
    @POST
    @Path(value="/loginForm")
    @Operation(operationId="loginForm", summary="Login with POST", description="Deprecated, use loginApiKey instead")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String loginForm(@FormParam(value="username") String username, @FormParam(value="password") String password) {
        return super.login(username, password);
    }

    @Override
    @POST
    @Path(value="/login")
    @Operation(operationId="loginPostJSON", summary="Login with POST in JSON format", description="Deprecated, use loginApiKey instead")
    @Consumes(value={"application/json"})
    public String loginPostJSON(WSCredentials cred) {
        return super.login(cred.getUsername(), cred.getPassword());
    }

    @Override
    @GET
    @Path(value="/loginApiKey")
    @Operation(summary="Login by API Key", description="Performs login by passing the API Key in the header. Read more at https://docs.logicaldoc.com/en/web-services-api/api-keys")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation. The Session ID (sid) is returned.", content={@Content(schema=@Schema(implementation=String.class, description="The session ID (sid) created", example="ca3c411d-b043-49a3-b151-e363dddcecef"))}), @ApiResponse(responseCode="500", description="Authentication failed")})
    public String loginApiKey(@HeaderParam(value="X-API-KEY") String apikey) {
        String sid = SessionManager.get().getSessionId(this.getCurrentRequest());
        if (StringUtils.isEmpty((CharSequence)sid)) {
            return super.loginApiKey(apikey);
        }
        return sid;
    }

    @Override
    @DELETE
    @Path(value="/logout")
    public void logout(@QueryParam(value="sid") String sid) {
        log.debug("logout({})", (Object)sid);
        if (sid != null) {
            super.logout(sid);
        }
    }

    @Override
    @GET
    @Path(value="/getSid")
    @Produces(value={"application/json", "text/plain"})
    public String getSid() {
        return this.getCurrentSessionId();
    }

    @Override
    @GET
    @Path(value="/renew")
    public void renew(@QueryParam(value="sid") String sid) {
        super.renew(sid);
    }

    @GET
    @Path(value="/renewcurrent")
    public void renew() {
        super.renew(this.getSid());
    }
}

