/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.client;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.rest.FolderService;
import com.logicaldoc.webservice.rest.client.AbstractRestClient;
import java.util.List;
import org.apache.cxf.jaxrs.client.WebClient;

public class RestFolderClient
extends AbstractRestClient<FolderService> {
    public RestFolderClient(String endpoint, String apiKey) {
        this(endpoint, apiKey, -1);
    }

    public RestFolderClient(String endpoint, String apiKey, int timeout) {
        super(FolderService.class, endpoint, apiKey, timeout);
    }

    public List<WSFolder> listChildren(long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((FolderService)this.proxy).listChildren(folderId);
    }

    public List<WSFolder> list(long folderId, String sort, Integer page, Integer max) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((FolderService)this.proxy).list(folderId, sort, page, max);
    }

    public WSFolder create(WSFolder folder) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((FolderService)this.proxy).create(folder);
    }

    public WSFolder createPath(long rootFolder, String path) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/x-www-form-urlencoded");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((FolderService)this.proxy).createPath(rootFolder, path);
    }

    public WSFolder findByPath(String path) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((FolderService)this.proxy).findByPath(path);
    }

    public WSFolder getRootFolder() throws AuthenticationException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((FolderService)this.proxy).getRootFolder();
    }

    public WSFolder getFolder(long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((FolderService)this.proxy).getFolder(folderId);
    }

    public long createFolder(long parentId, String folderName) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"text/plain"});
        return ((FolderService)this.proxy).createFolder(parentId, folderName);
    }

    public void delete(long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((FolderService)this.proxy).delete(folderId);
    }

    public void update(WSFolder folder) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((FolderService)this.proxy).update(folder);
    }
}

