/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.client;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSNote;
import com.logicaldoc.webservice.model.WSRating;
import com.logicaldoc.webservice.rest.DocumentService;
import com.logicaldoc.webservice.rest.client.AbstractRestClient;
import jakarta.activation.DataHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.AttachmentBuilder;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;

public class RestDocumentClient
extends AbstractRestClient<DocumentService> {
    public RestDocumentClient(String endpoint, String apiKey) {
        this(endpoint, apiKey, -1);
    }

    public RestDocumentClient(String endpoint, String apiKey, int timeout) {
        super(DocumentService.class, endpoint, apiKey, timeout);
    }

    public WSDocument create(WSDocument document, File packageFile) throws FileNotFoundException {
        WebClient.client((Object)this.proxy).type("multipart/form-data");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        Attachment fileAttachment = new Attachment("content", (InputStream)new FileInputStream(packageFile), new ContentDisposition("form-data; name=\"content\"; filename=\"" + packageFile.getName() + "\""));
        return ((DocumentService)this.proxy).create(document, fileAttachment);
    }

    public WSDocument create(WSDocument document, DataHandler dataHandler) {
        WebClient.client((Object)this.proxy).type("multipart/form-data");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        Attachment fileAttachment = new AttachmentBuilder().id("content").dataHandler(dataHandler).mediaType("application/octet-stream").contentDisposition(new ContentDisposition("form-data; name=\"content\"")).build();
        return ((DocumentService)this.proxy).create(document, fileAttachment);
    }

    public List<WSDocument> list(long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("*/*");
        return ((DocumentService)this.proxy).list(folderId);
    }

    public List<WSDocument> listPaginated(long folderId, String fileName, String sort, Integer page, Integer max) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("*/*");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((DocumentService)this.proxy).listPaginated(folderId, fileName, sort, page, max);
    }

    public List<WSDocument> listDocuments(long folderId, String fileName) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("*/*");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((DocumentService)this.proxy).listDocuments(folderId, fileName);
    }

    public WSDocument getDocument(long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((DocumentService)this.proxy).getDocument(docId);
    }

    public void delete(long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((DocumentService)this.proxy).delete(docId);
    }

    public DataHandler getContent(long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/octet-stream"});
        return ((DocumentService)this.proxy).getContent(docId);
    }

    public DataHandler getVersionContent(long docId, String version) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/octet-stream"});
        return ((DocumentService)this.proxy).getVersionContent(docId, version);
    }

    public void checkout(long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((DocumentService)this.proxy).checkout(docId);
    }

    public void update(WSDocument document) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((DocumentService)this.proxy).update(document);
    }

    public void checkin(long docId, String comment, Boolean release, File packageFile) throws FileNotFoundException {
        Attachment fileAttachment = new Attachment("filedata", (InputStream)new FileInputStream(packageFile), new ContentDisposition("form-data; name=\"filedata\"; filename=\"" + packageFile.getName() + "\""));
        WebClient.client((Object)this.proxy).type("multipart/form-data");
        WebClient.client((Object)this.proxy).accept(new String[]{"text/plain"});
        ((DocumentService)this.proxy).checkin(Long.toString(docId), comment, release.toString(), packageFile.getName(), fileAttachment);
    }

    public WSNote addNote(long docId, String note) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        WebClient.client((Object)this.proxy).type("application/x-www-form-urlencoded");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((DocumentService)this.proxy).addNote(docId, note);
    }

    public void deleteNote(long noteId) throws AuthenticationException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((DocumentService)this.proxy).deleteNote(noteId);
    }

    public void deleteVersion(long docId, String version) throws AuthenticationException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((DocumentService)this.proxy).deleteVersion(docId, version);
    }

    public List<WSNote> getNotes(long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((DocumentService)this.proxy).getNotes(docId);
    }

    public WSRating rateDocument(long docId, int vote) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((DocumentService)this.proxy).rateDocument(docId, vote);
    }

    public List<WSRating> getRatings(long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((DocumentService)this.proxy).getRatings(docId);
    }

    public void createPdf(long docId, String fileVersion) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((DocumentService)this.proxy).createPdf(docId, fileVersion);
    }

    public void createThumbnail(long docId, String fileVersion, String type) throws AuthenticationException, WebserviceException, PersistenceException, IOException {
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((DocumentService)this.proxy).createThumbnail(docId, fileVersion, type);
    }
}

