/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.client;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSBookmark;
import com.logicaldoc.webservice.rest.BookmarkService;
import com.logicaldoc.webservice.rest.client.AbstractRestClient;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.apache.cxf.jaxrs.client.WebClient;

public class RestBookmarkClient
extends AbstractRestClient<BookmarkService> {
    public RestBookmarkClient(String endpoint, String apiKey) {
        this(endpoint, apiKey, -1);
    }

    public RestBookmarkClient(String endpoint, String apiKey, int timeout) {
        super(BookmarkService.class, endpoint, apiKey, timeout);
    }

    public WSBookmark saveBookmark(WSBookmark bookmark) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((BookmarkService)this.proxy).saveBookmark(bookmark);
    }

    public WSBookmark bookmarkDocument(@QueryParam(value="docId") long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((BookmarkService)this.proxy).bookmarkDocument(docId);
    }

    @GET
    @Path(value="/bookmarkFolder")
    public WSBookmark bookmarkFolder(@QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((BookmarkService)this.proxy).bookmarkFolder(folderId);
    }

    @GET
    @Path(value="/getBookmarks")
    public List<WSBookmark> getBookmarks() throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        return ((BookmarkService)this.proxy).getBookmarks();
    }

    @DELETE
    @Path(value="/deleteBookmark")
    public void deleteBookmark(@QueryParam(value="bookmarkId") long bookmarkId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((BookmarkService)this.proxy).deleteBookmark(bookmarkId);
    }

    @DELETE
    @Path(value="/unbookmarkDocument")
    public void unbookmarkDocument(@QueryParam(value="docId") long docId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((BookmarkService)this.proxy).unbookmarkDocument(docId);
    }

    @DELETE
    @Path(value="/unbookmarkFolder")
    public void unbookmarkFolder(@QueryParam(value="folderId") long folderId) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException {
        WebClient.client((Object)this.proxy).type("application/json");
        WebClient.client((Object)this.proxy).accept(new String[]{"application/json"});
        ((BookmarkService)this.proxy).unbookmarkFolder(folderId);
    }
}

