/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest.client;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public abstract class AbstractRestClient<T> {
    protected String endpoint;
    protected String apiKey;
    protected int timeout;
    protected T proxy;

    protected AbstractRestClient(Class<T> stub, String endpoint, String apiKey) {
        this.endpoint = endpoint;
        this.apiKey = apiKey;
        this.prepareProxy(stub);
    }

    protected AbstractRestClient(Class<T> stub, String endpoint, String apiKey, int timeout) {
        this(stub, endpoint, apiKey);
        this.timeout = timeout;
        if (timeout > 0) {
            HTTPConduit conduit = WebClient.getConfig(this.proxy).getHttpConduit();
            HTTPClientPolicy policy = new HTTPClientPolicy();
            policy.setReceiveTimeout((long)timeout);
            conduit.setClient(policy);
        }
    }

    protected void prepareProxy(Class<T> stub) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        if (StringUtils.isNotEmpty((CharSequence)this.apiKey)) {
            bean.setHeaders(Map.of("X-API-KEY", this.apiKey));
            bean.setInheritHeaders(true);
        }
        bean.setResourceClass(stub);
        bean.setAddress(this.endpoint);
        bean.setProviders(List.of(new JacksonJsonProvider()));
        this.proxy = bean.create(stub, new Object[0]);
    }
}

