/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSFolder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface FolderService {
    @POST
    @Path(value="/create")
    public WSFolder create(WSFolder var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/createSimple")
    @Consumes(value={"text/plain", "application/json"})
    public WSFolder createSimple(String var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/createSimpleForm")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public WSFolder createSimpleForm(@FormParam(value="folderPath") String var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/createSimpleJSON")
    @Consumes(value={"application/json"})
    public WSFolder createSimpleJSON(String var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/createPath")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public WSFolder createPath(@FormParam(value="parentId") long var1, @FormParam(value="path") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/findByPath")
    @Produces(value={"application/json"})
    public WSFolder findByPath(@QueryParam(value="path") String var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getRootFolder")
    @Produces(value={"application/json"})
    public WSFolder getRootFolder() throws AuthenticationException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/createFolder")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain", "application/json", "application/xml"})
    public long createFolder(@FormParam(value="parentId") long var1, @FormParam(value="name") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getFolder")
    @Produces(value={"application/json", "application/xml"})
    public WSFolder getFolder(@QueryParam(value="folderId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @DELETE
    @Path(value="/delete")
    public void delete(@QueryParam(value="folderId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/listChildren")
    @Produces(value={"application/json", "application/xml"})
    public List<WSFolder> listChildren(@QueryParam(value="folderId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/list")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Lists the sub-folders", description="Returns the list of child folders. Example: curl -u admin:admin -H ''Accept: application/json'' http://localhost:8080/services/rest/folder/list?folderId=4")
    public List<WSFolder> list(@Parameter(description="The ID of the parent folder", required=true) @QueryParam(value="folderId") long var1, @QueryParam(value="sort") String var3, @QueryParam(value="page") Integer var4, @QueryParam(value="max") Integer var5) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getPath")
    public List<WSFolder> getPath(@QueryParam(value="folderId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getPathString")
    public String getPathString(@QueryParam(value="folderId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @PUT
    @Path(value="/update")
    public void update(WSFolder var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @PUT
    @Path(value="/rename")
    public void rename(@QueryParam(value="folderId") long var1, @QueryParam(value="name") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @PUT
    @Path(value="/move")
    public void move(@QueryParam(value="folderId") long var1, @QueryParam(value="parentId") long var3) throws AuthenticationException, PersistenceException, WebserviceException, PermissionException;

    @POST
    @Path(value="/createAlias")
    public WSFolder createAlias(@FormParam(value="parentId") long var1, @FormParam(value="foldRef") long var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getDefaultWorkspace")
    public WSFolder getDefaultWorkspace() throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/listWorkspaces")
    public List<WSFolder> listWorkspaces() throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/isReadable")
    public boolean isReadable(@QueryParam(value="folderId") long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/isWritable")
    public boolean isWritable(@QueryParam(value="folderId") long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/isGranted")
    public boolean isGranted(@QueryParam(value="folderId") long var1, @QueryParam(value="permission") String var3) throws AuthenticationException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/copy")
    public void copy(@FormParam(value="folderId") long var1, @FormParam(value="targetId") long var3, @FormParam(value="foldersOnly") int var5, @FormParam(value="securityOption") String var6) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @PUT
    @Path(value="/setAccessControlList")
    public void setAccessControlList(@QueryParam(value="folderId") long var1, List<WSAccessControlEntry> var3) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException;

    @GET
    @Path(value="/getAccessControlList")
    public List<WSAccessControlEntry> getAccessControlList(@QueryParam(value="folderId") long var1) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;
}

