/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.rest;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.authorization.UnexistingResourceException;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSAccessControlEntry;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSLink;
import com.logicaldoc.webservice.model.WSNote;
import com.logicaldoc.webservice.model.WSRating;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.activation.DataHandler;
import jakarta.mail.MessagingException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;

@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/json"})
public interface DocumentService {
    @POST
    @Path(value="/create")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Operation(summary="Creates a new document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=WSDocument.class))}), @ApiResponse(responseCode="401", description="Authentication failed"), @ApiResponse(responseCode="500", description="Generic error, see the response message")})
    public WSDocument create(@Multipart(value="document", required=true, type="application/json") WSDocument var1, @Multipart(value="content", required=true, type="application/octet-stream") Attachment var2);

    @GET
    @Path(value="/getDocument")
    @Produces(value={"application/json", "application/xml"})
    public WSDocument getDocument(@QueryParam(value="docId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/checkout")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void checkout(@FormParam(value="docId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/checkin")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Check-in an existing document", description="Performs a check-in (commit) operation of new content over an existing document. The document must be in checked-out status")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Successful operation"), @ApiResponse(responseCode="401", description="Authentication failed"), @ApiResponse(responseCode="500", description="Generic error, see the response message")})
    public void checkin(@Multipart(value="docId", required=true) String var1, @Multipart(value="comment", required=false) String var2, @Multipart(value="release", required=false) String var3, @Multipart(value="filename", required=true) String var4, @Multipart(value="filedata", required=true) Attachment var5);

    @POST
    @Path(value="/replaceFile")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Replace the file of a version", description="Replaces the file associated to a given version.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="successful operation"), @ApiResponse(responseCode="400", description="bad request"), @ApiResponse(responseCode="401", description="Authentication failed"), @ApiResponse(responseCode="500", description="Generic error, see the response message")})
    public void replaceFile(@Multipart(value="docId", required=false) String var1, @Multipart(value="fileVersion", required=false) String var2, @Multipart(value="comment", required=false) String var3, @Multipart(value="filedata", required=false) Attachment var4);

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Uploads a document", description="Creates or updates an existing document, if used in update mode docId must be provided, when used in create mode folderId is required. Returns the ID of the created/updated document. &lt;br/&gt;Example: curl -u admin:admin -H ''Accept: application/json'' -X POST -F folderId=4 -F filename=newDoc.txt -F filedata=@newDoc.txt http://localhost:8080/services/rest/document/upload")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=Long.class, description="The ID of the document created or updated"))}), @ApiResponse(responseCode="401", description="Authentication failed"), @ApiResponse(responseCode="500", description="Generic error, see the response message")})
    public Long upload(@Multipart(value="docId", required=false) String var1, @Multipart(value="folderId", required=false) String var2, @Multipart(value="release", required=false) String var3, @Multipart(value="filename", required=true) String var4, @Multipart(value="language", required=false) String var5, @Multipart(value="filedata", required=true) Attachment var6);

    @DELETE
    @Path(value="/delete")
    public void delete(@QueryParam(value="docId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public List<WSDocument> list(@QueryParam(value="folderId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/listPaginated")
    @Produces(value={"application/json"})
    public List<WSDocument> listPaginated(@QueryParam(value="folderId") long var1, @QueryParam(value="fileName") String var3, @QueryParam(value="sort") String var4, @QueryParam(value="page") Integer var5, @QueryParam(value="max") Integer var6) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/listDocuments")
    public List<WSDocument> listDocuments(@QueryParam(value="folderId") long var1, @QueryParam(value="fileName") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @PUT
    @Path(value="/update")
    public void update(WSDocument var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @GET
    @Path(value="/getContent")
    @Produces(value={"application/octet-stream"})
    public DataHandler getContent(@QueryParam(value="docId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException;

    @GET
    @Path(value="/getVersionContent")
    @Produces(value={"application/octet-stream"})
    public DataHandler getVersionContent(@QueryParam(value="docId") long var1, @QueryParam(value="version") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException;

    @POST
    @Path(value="/addNote")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public WSNote addNote(@FormParam(value="docId") long var1, @FormParam(value="note") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @DELETE
    @Path(value="/deleteNote")
    public void deleteNote(@QueryParam(value="noteId") long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getNotes")
    public List<WSNote> getNotes(@QueryParam(value="docId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @PUT
    @Path(value="/rateDocument")
    public WSRating rateDocument(@QueryParam(value="docId") long var1, @QueryParam(value="vote") int var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @GET
    @Path(value="/getRatings")
    public List<WSRating> getRatings(@QueryParam(value="docId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @DELETE
    @Path(value="/deleteVersion")
    public String deleteVersion(@QueryParam(value="docId") long var1, @QueryParam(value="version") String var3) throws AuthenticationException, WebserviceException, PersistenceException;

    @PUT
    @Path(value="/move")
    public void move(@QueryParam(value="docId") long var1, @QueryParam(value="folderId") long var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @PUT
    @Path(value="/copy")
    @Produces(value={"application/json"})
    @Operation(summary="Copies a document")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="successful operation", content={@Content(schema=@Schema(implementation=WSDocument.class))}), @ApiResponse(responseCode="401", description="Authentication failed"), @ApiResponse(responseCode="500", description="Generic error, see the response message")})
    public WSDocument copy(@QueryParam(value="docId") long var1, @QueryParam(value="folderId") long var3, @QueryParam(value="links") boolean var5, @QueryParam(value="notes") boolean var6, @QueryParam(value="security") boolean var7) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException;

    @PUT
    @Path(value="/createThumbnail")
    public void createThumbnail(@QueryParam(value="docId") long var1, @QueryParam(value="fileVersion") String var3, @QueryParam(value="type") String var4) throws AuthenticationException, WebserviceException, PersistenceException, IOException;

    @GET
    @Path(value="/thumbnail/{type}/{docpath:.*}")
    @Produces(value={"image/jpeg"})
    public Response getThumbnail(@PathParam(value="type") String var1, @PathParam(value="docpath") String var2, @PathParam(value="docpath") List<PathSegment> var3) throws AuthenticationException, WebserviceException, PersistenceException, IOException, PermissionException;

    @PUT
    @Path(value="/createPdf")
    public void createPdf(@QueryParam(value="docId") long var1, @QueryParam(value="fileVersion") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException;

    @PUT
    @Path(value="/promoteVersion")
    public void promoteVersion(@QueryParam(value="docId") long var1, @QueryParam(value="version") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException, UnexistingResourceException;

    @PUT
    @Path(value="/rename")
    public void rename(@QueryParam(value="docId") long var1, @QueryParam(value="name") String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @GET
    @Path(value="/getVersions")
    public List<WSDocument> getVersions(@QueryParam(value="docId") long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @POST
    @Path(value="/createAlias")
    public WSDocument createAlias(long var1, long var3, String var5) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/createDownloadTicket")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createDownloadTicket(long var1, String var3, Integer var4, String var5, Integer var6) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @POST
    @Path(value="/createViewTicket")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createViewTicket(long var1, String var3, Integer var4, String var5, Integer var6, Integer var7) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @DELETE
    @Path(value="/deleteLink")
    public void deleteLink(long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getAliases")
    public List<WSDocument> getAliases(long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getDocumentByCustomId")
    public WSDocument getDocumentByCustomId(String var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getDocuments")
    public List<WSDocument> getDocuments(List<Long> var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getExtractedText")
    @Produces(value={"text/plain"})
    public String getExtractedText(long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getRecentDocuments")
    public List<WSDocument> getRecentDocuments(Integer var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getLinks")
    public List<WSLink> getLinks(long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/getResource")
    @Produces(value={"application/octet-stream"})
    public DataHandler getResource(long var1, String var3, String var4) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException;

    public WSLink link(long var1, long var3, String var5) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    public void lock(long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    public void reindex(long var1, String var3) throws AuthenticationException, ParsingException, WebserviceException, PersistenceException;

    @POST
    @Path(value="/uploadResource")
    @Consumes(value={"multipart/form-data"})
    @Operation(summary="Uploads a new resource of the document")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="successful operation")})
    public void uploadResource(@Multipart(value="docId", required=false) String var1, @Multipart(value="fileVersion", required=false) String var2, @Multipart(value="suffix", required=false) String var3, @Multipart(value="content", required=false) Attachment var4) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, IOException;

    public void restore(long var1, long var3) throws AuthenticationException, WebserviceException, PersistenceException;

    public WSNote saveNote(long var1, WSNote var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    public void sendEmail(List<Long> var1, String var2, String var3, String var4) throws AuthenticationException, WebserviceException, PersistenceException, IOException, MessagingException;

    public void setPassword(long var1, String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    public void unlock(long var1) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    public boolean unprotect(long var1, String var3) throws PersistenceException, AuthenticationException, WebserviceException;

    public void unsetPassword(long var1, String var3) throws AuthenticationException, PermissionException, WebserviceException, PersistenceException, UnexistingResourceException;

    @PUT
    @Path(value="/setAccessControlList")
    public void setAccessControlList(@QueryParam(value="docId") long var1, List<WSAccessControlEntry> var3) throws PersistenceException, PermissionException, AuthenticationException, WebserviceException;

    @GET
    @Path(value="/getAccessControlList")
    public List<WSAccessControlEntry> getAccessControlList(@QueryParam(value="docId") long var1) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException;

    @GET
    @Path(value="/isRead")
    public boolean isRead(@QueryParam(value="docId") long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/isDownload")
    public boolean isDownload(@QueryParam(value="docId") long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/isWrite")
    public boolean isWrite(@QueryParam(value="docId") long var1) throws AuthenticationException, WebserviceException, PersistenceException;

    @GET
    @Path(value="/isGranted")
    public boolean isGranted(@QueryParam(value="docId") long var1, @QueryParam(value="permission") String var3) throws AuthenticationException, WebserviceException, PersistenceException;
}

