/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.model;

import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.WorkingTime;
import com.logicaldoc.util.crypt.CryptUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.DateUtil;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSUtil;
import com.logicaldoc.webservice.model.WSWorkingTime;
import jakarta.xml.bind.annotation.XmlType;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(name="WSUser")
public class WSUser {
    @WSDoc(documented=false)
    private static final Logger log = LoggerFactory.getLogger(WSUser.class);
    @WSDoc(documented=false)
    public static final int TYPE_DEFAULT = 0;
    @WSDoc(documented=false)
    public static final int TYPE_SYSTEM = 1;
    @WSDoc(documented=false)
    public static final int TYPE_GUEST = 2;
    @WSDoc(documented=false)
    public static final int SOURCE_DEFAULT = 0;
    @WSDoc(documented=false)
    public static final int SOURCE_LDAP = 1;
    @WSDoc(documented=false)
    public static final int SOURCE_ACTIVE_DIRECTORY = 2;
    @WSDoc(documented=false)
    public static final long USERID_ADMIN = 1L;
    @WSDoc(description="unique identifier")
    private long id;
    private String username = "";
    @WSDoc(required=false)
    private String password = "";
    @WSDoc(required=false)
    private String decodedPassword = "";
    @WSDoc(required=false)
    private String passwordmd4 = "";
    @WSDoc(required=false)
    private String name = "";
    @WSDoc(required=false)
    private String firstName = "";
    @WSDoc(required=false)
    private String street = "";
    @WSDoc(required=false)
    private String postalcode = "";
    @WSDoc(required=false)
    private String city = "";
    @WSDoc(required=false)
    private String country = "";
    @WSDoc(required=false)
    private String state = "";
    @WSDoc(description="default language; <a href='/wiki/LanguageSpecification'>See specification</a>", required=false)
    private String language = "";
    @WSDoc(description="address used for notifications, must be a valid e-mail", required=true)
    private String email = "";
    @WSDoc(description="a simple text to be used as a signature in the footer of the outgoing emails", required=false)
    private String emailSignature;
    @WSDoc(description="secondary email address, must be a valid e-mail", required=false)
    private String email2 = "";
    @WSDoc(description="a simple text to be used as a signature in the footer of the outgoing emails", required=false)
    private String emailSignature2;
    @WSDoc(required=false)
    private String telephone = "";
    @WSDoc(required=false)
    private String telephone2 = "";
    @WSDoc(required=false)
    private String company;
    @WSDoc(required=false)
    private String department;
    @WSDoc(required=false)
    private String organizationalUnit;
    @WSDoc(required=false)
    private String building;
    @WSDoc(description="must be <b>0: normal or 2: guest</b>")
    private int type = 0;
    @WSDoc(description="ids of the groups this user belongs to")
    private List<Long> groupIds = new ArrayList<Long>();
    @WSDoc(required=false, description="if <b>1</b> the user is enabled, if <b>0</b> the user is disabled")
    private Integer enabled = 1;
    @WSDoc(description="if <b>1</b> the user must confirm any change in the legals")
    private Integer legals;
    @WSDoc(description="if <b>1</b> the user can connect during working time only")
    private int enforceWorkingTime = 0;
    @WSDoc(description="last time the password was changed (format must be 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd')", required=false)
    private String passwordChanged = "";
    @WSDoc(description="if <b>1</b> the password is eligible for expiration, if <b>0</b> the password never expires")
    private int passwordExpires = 0;
    @WSDoc(description="if <b>1</b> the evaluation form is available, if <b>0</b> the evaluation form is not evailable")
    private int evalFormEnabled = 1;
    @WSDoc(description="must be <b>0</b>")
    private int source = 0;
    @WSDoc(description="maximum allowed user's quota expressed in bytes, <b>-1</b> for no limits")
    private long quota = -1L;
    @WSDoc(description=" actual quota used by the user ")
    private long quotaCount = 0L;
    @WSDoc(required=false)
    private String lastModified;
    @WSDoc(description="last time the user has logged in", required=false)
    private String lastLogin;
    @WSDoc(description="when the user has been created", required=false)
    private String creation;
    @WSDoc(description="date format to use when display dates", required=false)
    private String dateFormat;
    @WSDoc(description="date format to use when display dates in short format", required=false)
    private String dateFormatShort;
    @WSDoc(description="date format to use when display dates and times", required=false)
    private String dateFormatLong;
    @WSDoc(description="comma separated list of searches that defines the order they are displayed in the user interface", required=false)
    private String searchPref;
    @WSDoc(description="when this account expires", required=false)
    private String expire;
    @WSDoc(description="the working time specification", required=false)
    private List<WSWorkingTime> workingTimes = new ArrayList<WSWorkingTime>();
    @WSDoc(description="maximum number of inactivity days after which the account gets disabled", required=false)
    private Integer maxInactivity;
    @WSDoc(description="the time zone of the suer", required=false)
    private String timeZone;
    @WSDoc(description="the second factor authenticator to use", required=false)
    private String secondFactor;
    @WSDoc(description="key used by the second factor authenticator", required=false)
    private String key;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        Object fullName = this.getFirstName();
        if (fullName != null && this.getName() != null) {
            fullName = (String)fullName + " " + this.getName();
        }
        if (fullName == null && this.getName() != null) {
            fullName = this.getName();
        }
        if (fullName == null) {
            fullName = this.getUsername();
        }
        return fullName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getStreet() {
        return this.street;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setUsername(String uname) {
        this.username = uname;
    }

    public void setPassword(String passwd) throws NoSuchAlgorithmException {
        this.decodedPassword = passwd;
        this.password = null;
        if (StringUtils.isNotEmpty(passwd)) {
            this.password = CryptUtil.encryptSHA256(passwd);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setStreet(String str) {
        this.street = str;
    }

    public void setPostalcode(String pc) {
        this.postalcode = pc;
    }

    public void setCity(String ct) {
        this.city = ct;
    }

    public void setCountry(String cnt) {
        this.country = cnt;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public void setEmail(String mail) {
        this.email = mail;
    }

    public void setTelephone(String phone) {
        this.telephone = phone;
    }

    public List<Long> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(List<Long> groupIds) {
        this.groupIds = groupIds;
    }

    public String toString() {
        return this.getUsername();
    }

    public String getUserGroupName() {
        return "_user_" + this.getId();
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getTelephone2() {
        return this.telephone2;
    }

    public void setTelephone2(String telephone2) {
        this.telephone2 = telephone2;
    }

    public String getPasswordChanged() {
        return this.passwordChanged;
    }

    public void setPasswordChanged(String passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    public int getPasswordExpires() {
        return this.passwordExpires;
    }

    public void setPasswordExpires(int passwordExpires) {
        this.passwordExpires = passwordExpires;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public long getQuota() {
        return this.quota;
    }

    public void setQuota(long quota) {
        this.quota = quota;
    }

    public long getQuotaCount() {
        return this.quotaCount;
    }

    public void setQuotaCount(long quotaCount) {
        this.quotaCount = quotaCount;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public User toUser() {
        User user = new User();
        try {
            user.setId(this.getId());
            user.setCity(this.getCity());
            user.setCountry(this.getCountry());
            user.setEmail(this.getEmail());
            user.setEmail2(this.getEmail2());
            user.setFirstName(this.getFirstName());
            user.setName(this.getName());
            user.setLanguage(this.getLanguage());
            user.setPostalcode(this.getPostalcode());
            user.setState(this.getState());
            user.setStreet(this.getStreet());
            user.setTelephone(this.getTelephone());
            user.setTelephone2(this.getTelephone2());
            user.setCompany(this.getCompany());
            user.setDepartment(this.getDepartment());
            user.setBuilding(this.getBuilding());
            user.setOrganizationalUnit(this.getOrganizationalUnit());
            user.setUsername(this.getUsername());
            user.setEnabled(this.getEnabled());
            user.setPasswordExpires(this.getPasswordExpires());
            user.setEvalFormEnabled(this.getEvalFormEnabled());
            user.setQuota(this.getQuota());
            user.setType(this.getType());
            user.setSource(this.getSource());
            user.setPassword(this.getPassword());
            user.setPasswordChanged(new Date());
            user.setEmailSignature(this.getEmailSignature());
            user.setEmailSignature2(this.getEmailSignature2());
            user.setDateFormat(this.getDateFormat());
            user.setDateFormatShort(this.getDateFormatShort());
            user.setDateFormatLong(this.getDateFormatLong());
            user.setSearchPref(this.getSearchPref());
            user.setExpire(WSUtil.convertStringToDate(this.getExpire()));
            user.setEnforceWorkingTime(this.getEnforceWorkingTime());
            user.setMaxInactivity(this.getMaxInactivity());
            user.setTimeZone(this.getTimeZone());
            user.setKey(this.getKey());
            user.setSecondFactor(this.getSecondFactor());
            if (this.getLegals() != null) {
                user.setLegals(this.getLegals());
            }
            if (CollectionUtils.isNotEmpty(this.groupIds)) {
                GroupDAO groupDao = Context.get(GroupDAO.class);
                HashSet<Group> groups = new HashSet<Group>();
                for (long groupId : this.getGroupIds()) {
                    Group group = (Group)groupDao.findById(groupId);
                    if (group == null) continue;
                    groups.add(group);
                }
                if (CollectionUtils.isNotEmpty(groups)) {
                    user.setGroups(groups);
                }
            }
            if (CollectionUtils.isNotEmpty(this.workingTimes)) {
                for (WSWorkingTime wswt : this.workingTimes) {
                    WorkingTime wt = new WorkingTime();
                    BeanUtils.copyProperties((Object)wt, (Object)wswt);
                    user.getWorkingTimes().add(wt);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user;
    }

    public static WSUser fromUser(User user) {
        WSUser wsUser = new WSUser();
        try {
            UserDAO dao = Context.get(UserDAO.class);
            dao.initialize(user);
            wsUser.setId(user.getId());
            wsUser.setCity(user.getCity());
            wsUser.setCountry(user.getCountry());
            wsUser.setEmail(user.getEmail());
            wsUser.setEmail2(user.getEmail2());
            wsUser.setFirstName(user.getFirstName());
            wsUser.setName(user.getName());
            wsUser.setLanguage(user.getLanguage());
            wsUser.setPostalcode(user.getPostalcode());
            wsUser.setState(user.getState());
            wsUser.setStreet(user.getStreet());
            wsUser.setTelephone(user.getTelephone());
            wsUser.setTelephone2(user.getTelephone2());
            wsUser.setCompany(user.getCompany());
            wsUser.setDepartment(user.getDepartment());
            wsUser.setBuilding(user.getBuilding());
            wsUser.setOrganizationalUnit(user.getOrganizationalUnit());
            wsUser.setUsername(user.getUsername());
            wsUser.setEnabled(user.getEnabled());
            wsUser.setPasswordExpires(user.getPasswordExpires());
            wsUser.setEvalFormEnabled(user.getEvalFormEnabled());
            wsUser.setQuota(user.getQuota());
            wsUser.setType(user.getType().ordinal());
            wsUser.setSource(user.getSource().ordinal());
            wsUser.setPassword(user.getPassword());
            wsUser.setPasswordmd4(user.getPasswordmd4());
            wsUser.setPasswordChanged(DateUtil.format(user.getPasswordChanged()));
            wsUser.setLastModified(DateUtil.format(user.getLastModified()));
            wsUser.setLastLogin(DateUtil.format(user.getLastLogin()));
            wsUser.setCreation(DateUtil.format(user.getCreation()));
            wsUser.setEmailSignature(user.getEmailSignature());
            wsUser.setEmailSignature2(user.getEmailSignature2());
            wsUser.setDateFormat(user.getDateFormat());
            wsUser.setDateFormatShort(user.getDateFormatShort());
            wsUser.setDateFormatLong(user.getDateFormatLong());
            wsUser.setSearchPref(user.getSearchPref());
            wsUser.setExpire(DateUtil.format(user.getExpire()));
            wsUser.setEnforceWorkingTime(user.getEnforceWorkingTime());
            wsUser.setMaxInactivity(user.getMaxInactivity());
            wsUser.setTimeZone(user.getTimeZone());
            wsUser.setKey(user.getKey());
            wsUser.setSecondFactor(user.getSecondFactor());
            wsUser.setLegals(user.getLegals());
            wsUser.setGroupIds(user.getGroups().stream().map(g -> g.getId()).collect(Collectors.toList()));
            List<WSWorkingTime> tmp = user.getWorkingTimes().stream().map(wt -> {
                WSWorkingTime wswt = new WSWorkingTime();
                try {
                    BeanUtils.copyProperties((Object)wswt, (Object)wt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return wswt;
            }).collect(Collectors.toList());
            wsUser.setWorkingTimes(tmp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return wsUser;
    }

    public String getPasswordmd4() {
        return this.passwordmd4;
    }

    public void setPasswordmd4(String passwordmd4) {
        this.passwordmd4 = passwordmd4;
    }

    public String getEmailSignature() {
        return this.emailSignature;
    }

    public void setEmailSignature(String emailSignature) {
        this.emailSignature = emailSignature;
    }

    public String getEmail2() {
        return this.email2;
    }

    public void setEmail2(String email2) {
        this.email2 = email2;
    }

    public String getEmailSignature2() {
        return this.emailSignature2;
    }

    public void setEmailSignature2(String emailSignature2) {
        this.emailSignature2 = emailSignature2;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormatShort() {
        return this.dateFormatShort;
    }

    public void setDateFormatShort(String dateFormatShort) {
        this.dateFormatShort = dateFormatShort;
    }

    public String getDateFormatLong() {
        return this.dateFormatLong;
    }

    public void setDateFormatLong(String dateFormatLong) {
        this.dateFormatLong = dateFormatLong;
    }

    public String getSearchPref() {
        return this.searchPref;
    }

    public void setSearchPref(String searchPref) {
        this.searchPref = searchPref;
    }

    public String getExpire() {
        return this.expire;
    }

    public void setExpire(String expire) {
        this.expire = expire;
    }

    public int getEnforceWorkingTime() {
        return this.enforceWorkingTime;
    }

    public void setEnforceWorkingTime(int enforceWorkingTime) {
        this.enforceWorkingTime = enforceWorkingTime;
    }

    public List<WSWorkingTime> getWorkingTimes() {
        return this.workingTimes;
    }

    public void setWorkingTimes(List<WSWorkingTime> workingTimes) {
        this.workingTimes = workingTimes;
    }

    public Integer getMaxInactivity() {
        return this.maxInactivity;
    }

    public void setMaxInactivity(Integer maxInactivity) {
        this.maxInactivity = maxInactivity;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getSecondFactor() {
        return this.secondFactor;
    }

    public void setSecondFactor(String secondFactor) {
        this.secondFactor = secondFactor;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDecodedPassword() {
        return this.decodedPassword;
    }

    public void setDecodedPassword(String decodedPassword) {
        this.decodedPassword = decodedPassword;
    }

    public String getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(String lastLogin) {
        this.lastLogin = lastLogin;
    }

    public String getCreation() {
        return this.creation;
    }

    public void setCreation(String creation) {
        this.creation = creation;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public int getEvalFormEnabled() {
        return this.evalFormEnabled;
    }

    public void setEvalFormEnabled(int evalFormEnabled) {
        this.evalFormEnabled = evalFormEnabled;
    }

    public Integer getLegals() {
        return this.legals;
    }

    public void setLegals(Integer legals) {
        this.legals = legals;
    }
}

