/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.model;

import com.logicaldoc.core.searchengine.FulltextSearchOptions;
import com.logicaldoc.core.searchengine.SearchOptions;
import com.logicaldoc.util.time.DateUtil;
import com.logicaldoc.webservice.model.WSUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

@XmlRootElement(name="searchoptions")
@XmlType(name="WSSearchOptions")
public class WSSearchOptions
implements Comparable<WSSearchOptions> {
    protected int maxHits = 40;
    private int type = 0;
    protected String expression = "";
    protected String name = "";
    protected String description = "";
    private String topOperator;
    private int caseSensitive = 1;
    private int retrieveAliases = 0;
    private List<Long> filterIds = new ArrayList<Long>();
    private Long folderId = null;
    private int searchInSubPath = 1;
    private String expressionLanguage = Locale.ENGLISH.getLanguage();
    private Long sizeMin = null;
    private Long sizeMax = null;
    private String format = "";
    private List<String> fields = new ArrayList<String>();
    private String language = null;
    private String dateFrom = null;
    private String dateTo = null;
    private String creationFrom = null;
    private String creationTo = null;
    private Long template = null;

    public void setExpression(String expr) {
        this.expression = expr;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getTopOperator() {
        return this.topOperator;
    }

    public void setTopOperator(String topOperator) {
        this.topOperator = topOperator;
    }

    public List<Long> getFilterIds() {
        return this.filterIds;
    }

    public void setFilterIds(List<Long> filterIds) {
        this.filterIds = filterIds;
    }

    public int getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(int caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public int getRetrieveAliases() {
        return this.retrieveAliases;
    }

    public void setRetrieveAliases(int retrieveAliases) {
        this.retrieveAliases = retrieveAliases;
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    public int getSearchInSubPath() {
        return this.searchInSubPath;
    }

    public void setSearchInSubPath(int searchInSubPath) {
        this.searchInSubPath = searchInSubPath;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public Long getSizeMin() {
        return this.sizeMin;
    }

    public void setSizeMin(Long sizeMin) {
        this.sizeMin = sizeMin;
    }

    public Long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(Long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Long getTemplate() {
        return this.template;
    }

    public void setTemplate(Long template) {
        this.template = template;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public String getCreationFrom() {
        return this.creationFrom;
    }

    public void setCreationFrom(String creationFrom) {
        this.creationFrom = creationFrom;
    }

    public String getCreationTo() {
        return this.creationTo;
    }

    public void setCreationTo(String creationTo) {
        this.creationTo = creationTo;
    }

    public static WSSearchOptions fromSearchOptions(SearchOptions opt) {
        WSSearchOptions wopt = new WSSearchOptions();
        wopt.setType(opt.getType());
        wopt.setName(opt.getName());
        wopt.setDescription(opt.getDescription());
        wopt.setExpression(opt.getExpression());
        wopt.setFolderId(opt.getFolderId());
        wopt.setSearchInSubPath(opt.isSearchInSubPath() ? 1 : 0);
        wopt.setMaxHits(opt.getMaxHits());
        wopt.setRetrieveAliases(opt.isRetrieveAliases() ? 1 : 0);
        wopt.setTemplate(opt.getTemplate());
        wopt.setCaseSensitive(opt.isCaseSensitive() ? 1 : 0);
        wopt.setFilterIds(new ArrayList<Long>(opt.getFilterIds()));
        if (opt.getType() == 0) {
            wopt.setCreationFrom(DateUtil.format(((FulltextSearchOptions)opt).getCreationFrom()));
            wopt.setCreationTo(DateUtil.format(((FulltextSearchOptions)opt).getCreationTo()));
            wopt.setDateFrom(DateUtil.format(((FulltextSearchOptions)opt).getDateFrom()));
            wopt.setDateTo(DateUtil.format(((FulltextSearchOptions)opt).getDateTo()));
            wopt.setExpressionLanguage(((FulltextSearchOptions)opt).getExpressionLanguage());
            wopt.setLanguage(((FulltextSearchOptions)opt).getLanguage());
            wopt.setFields(new ArrayList<String>(((FulltextSearchOptions)opt).getFields()));
            wopt.setFormat(((FulltextSearchOptions)opt).getFormat());
            wopt.setSizeMax(((FulltextSearchOptions)opt).getSizeMax());
            wopt.setSizeMin(((FulltextSearchOptions)opt).getSizeMin());
        }
        return wopt;
    }

    public SearchOptions toSearchOptions() {
        FulltextSearchOptions so = null;
        if (this.type == 0) {
            so = new FulltextSearchOptions();
            so.setCaseSensitive(this.caseSensitive == 1);
            so.setDescription(this.description);
            so.setExpression(this.expression);
            if (this.filterIds != null) {
                for (Long id : this.filterIds) {
                    so.getFilterIds().add(id);
                }
            }
            so.setFolderId(this.folderId);
            so.setMaxHits(this.maxHits);
            so.setName(this.name);
            so.setRetrieveAliases(this.retrieveAliases == 1);
            so.setSearchInSubPath(this.searchInSubPath == 1);
            so.setTopOperator(this.topOperator);
            so.setTemplate(this.getTemplate());
            so.setCreationFrom(WSUtil.convertStringToDate(this.creationFrom));
            so.setCreationTo(WSUtil.convertStringToDate(this.creationTo));
            so.setDateFrom(WSUtil.convertStringToDate(this.dateFrom));
            so.setDateTo(WSUtil.convertStringToDate(this.dateTo));
            so.setExpressionLanguage(this.expressionLanguage);
            so.setFields(new HashSet<String>(this.fields));
            so.setFormat(this.format);
            so.setLanguage(this.language);
            so.setSizeMax(this.sizeMax);
            so.setSizeMin(this.sizeMin);
        }
        return so;
    }

    @Override
    public int compareTo(WSSearchOptions o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WSSearchOptions)) {
            return false;
        }
        WSSearchOptions other = (WSSearchOptions)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

