/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.model;

import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserType;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.DateUtil;
import com.logicaldoc.webservice.doc.WSDoc;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@XmlType(name="WSGroup")
public class WSGroup
implements Serializable {
    @WSDoc(documented=false)
    private static final long serialVersionUID = 1L;
    @WSDoc(documented=false)
    public static final long GROUPID_ADMIN = 1L;
    @WSDoc(documented=false)
    public static final int TYPE_DEFAULT = 0;
    @WSDoc(documented=false)
    public static final int TYPE_USER = 1;
    @WSDoc(description="unique identifier")
    private long id;
    @WSDoc(description="must be unique")
    private String name = "";
    private String description = "";
    @WSDoc(description="set it to 0")
    private int type = 0;
    @WSDoc(description="inherit security policies from this referenced group at creation time", required=false)
    private Long inheritGroupId;
    @WSDoc(description="set of users in this group")
    private List<Long> userIds = new ArrayList<Long>();
    @WSDoc(description="the last modified date (format must be 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd')", required=false)
    private String lastModified;
    @WSDoc(description="where the group was created, 'local' indicates it was created in the local database", required=false)
    private String source = "local";

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Long> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public Long getInheritGroupId() {
        return this.inheritGroupId;
    }

    public void setInheritGroupId(Long inheritGroupId) {
        this.inheritGroupId = inheritGroupId;
    }

    public Group toGroup() {
        Group group = new Group();
        try {
            group.setId(this.getId());
            group.setName(this.getName());
            group.setDescription(this.getDescription());
            group.setType(this.getType());
            if (CollectionUtils.isNotEmpty(this.userIds)) {
                UserDAO userDao = Context.get(UserDAO.class);
                HashSet<User> users = new HashSet<User>();
                for (long userId : this.getUserIds()) {
                    User user = (User)userDao.findById(userId);
                    if (user == null || user.getType() != UserType.DEFAULT) continue;
                    users.add(user);
                }
                if (CollectionUtils.isNotEmpty(users)) {
                    group.setUsers(users);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return group;
    }

    public static WSGroup fromGroup(Group group) {
        WSGroup wsGroup = new WSGroup();
        try {
            wsGroup.setId(group.getId());
            wsGroup.setName(group.getName());
            wsGroup.setDescription(group.getDescription());
            wsGroup.setType(group.getType().ordinal());
            wsGroup.setLastModified(DateUtil.format(group.getLastModified()));
            wsGroup.setSource(group.getSource());
            wsGroup.setUserIds(group.getUsers().stream().map(u -> u.getId()).collect(Collectors.toList()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wsGroup;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id == ((WSGroup)obj).getId();
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

