/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.model;

import com.logicaldoc.util.time.DateUtil;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.model.WSDocument;
import com.logicaldoc.webservice.model.WSFolder;
import com.logicaldoc.webservice.model.WSUser;
import com.logicaldoc.webservice.model.WSUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlRootElement(name="attribute")
@XmlType(name="WSAttribute")
public class WSAttribute
implements Serializable {
    @WSDoc(documented=false)
    private static final long serialVersionUID = 1L;
    @WSDoc(documented=false)
    public static final int TYPE_STRING = 0;
    @WSDoc(documented=false)
    public static final int TYPE_INT = 1;
    @WSDoc(documented=false)
    public static final int TYPE_DOUBLE = 2;
    @WSDoc(documented=false)
    public static final int TYPE_DATE = 3;
    @WSDoc(documented=false)
    public static final int TYPE_USER = 4;
    @WSDoc(documented=false)
    public static final int TYPE_BOOLEAN = 5;
    @WSDoc(documented=false)
    public static final int TYPE_FOLDER = 6;
    @WSDoc(documented=false)
    public static final int TYPE_DOCUMENT = 7;
    @WSDoc(required=true, description="name of the attribute")
    private String name;
    @WSDoc(required=false)
    private String stringValue;
    @WSDoc(required=false)
    private Long intValue;
    @WSDoc(required=false)
    private Double doubleValue;
    @WSDoc(required=false, description="the date value; format must be 'yyyy-MM-dd'")
    private String dateValue;
    @WSDoc(required=true, description="<b>0</b> = String, <b>1</b> = int, <b>2</b> = double, <b>3</b> = date, <b>4</b> = user (intValue represents the user's id), <b>5</b> = boolean (intValue must be <b>0</b> or <b>1</b>), <b>6</b> = folder (intValue represents the folders's id, <b>7</b> = document (intValue represents the document's id), <b>8</b> = section")
    private int type = 0;
    @WSDoc(required=true)
    private int mandatory = 0;
    @WSDoc(required=true)
    private int hidden = 0;
    @WSDoc(required=true)
    private int readonly = 0;
    @WSDoc(required=false)
    private int position = 0;
    @WSDoc(required=false)
    private String label;
    @WSDoc(required=true, description="<b>0</b> = free, <b>1</b> = preset")
    private int editor = 0;
    @WSDoc(required=false, description="Id of the attribute set")
    private Long setId;
    @WSDoc(required=true, description="<b>0</b> = single value, <b>1</b> = one or more values")
    private int multiple = 0;
    @WSDoc(required=false, description="The reference attribute name, used for multi value attributes")
    private String parent;
    @WSDoc(required=false, description="Name of another attribute on which the value of this attribute also depends, used for managing linked presets")
    private String dependsOn;
    @WSDoc(required=false, description="Read only. In case of multiple string values, contains the values separated by a comma")
    private String stringValues;
    @WSDoc(required=false, description="Optional validation script")
    private String validation;
    @WSDoc(required=false, description="Optional initialization script")
    private String initialization;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        Object val = WSAttribute.getValue(this);
        return this.getName() + (String)(val != null ? " - " + val.toString() : "");
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Long getIntValue() {
        return this.intValue;
    }

    public void setIntValue(Long intValue) {
        this.intValue = intValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public String getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(String dateValue) {
        this.dateValue = dateValue;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(int mandatory) {
        this.mandatory = mandatory;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static Object getValue(WSAttribute attribute) {
        switch (attribute.type) {
            case 0: {
                return attribute.getStringValue();
            }
            case 2: {
                return attribute.getDoubleValue();
            }
            case 3: {
                return WSUtil.convertStringToDate(attribute.getDateValue());
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return attribute.getIntValue();
            }
        }
        return attribute.getStringValue();
    }

    public static void setValue(WSAttribute attribute, Object value) {
        if (attribute.getType() == 4 && !(value instanceof WSUser)) {
            if (value instanceof Long) {
                Long longValue;
                attribute.intValue = longValue = (Long)value;
            } else if (value instanceof String) {
                String string;
                attribute.stringValue = string = (String)value;
            }
            return;
        }
        WSAttribute.setNonUserValue(attribute, value);
    }

    private static void setNonUserValue(WSAttribute attribute, Object value) {
        if (value == null) {
            return;
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Long.class, Integer.class, Boolean.class, Double.class, Date.class, WSUser.class, WSFolder.class, WSDocument.class}, (Object)object2, n)) {
            case 0: {
                String string = (String)object2;
                attribute.type = 0;
                attribute.setStringValue(string);
                break;
            }
            case 1: {
                Long longValue = (Long)object2;
                attribute.type = 1;
                attribute.setIntValue(longValue);
                break;
            }
            case 2: {
                Integer integer = (Integer)object2;
                attribute.type = 1;
                attribute.setIntValue(integer.longValue());
                break;
            }
            case 3: {
                Boolean bool = (Boolean)object2;
                attribute.setIntValue(bool != false ? 1L : 0L);
                attribute.type = 5;
                break;
            }
            case 4: {
                Double doubleVal = (Double)object2;
                attribute.type = 2;
                attribute.setDoubleValue(doubleVal);
                break;
            }
            case 5: {
                Date date = (Date)object2;
                attribute.type = 3;
                attribute.setDateValue(DateUtil.format(date));
                break;
            }
            case 6: {
                WSUser user = (WSUser)object2;
                attribute.stringValue = user.getFullName();
                attribute.intValue = user.getId();
                attribute.type = 4;
                break;
            }
            case 7: {
                WSFolder folder = (WSFolder)object2;
                attribute.stringValue = folder.getName();
                attribute.intValue = folder.getId();
                attribute.type = 6;
                break;
            }
            case 8: {
                WSDocument document = (WSDocument)object2;
                attribute.stringValue = document.getFileName();
                attribute.intValue = document.getId();
                attribute.type = 7;
                break;
            }
            default: {
                WSAttribute.setDateValue(attribute, value);
            }
        }
    }

    private static void setDateValue(WSAttribute attribute, Object value) {
        attribute.type = 3;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{XMLGregorianCalendar.class, Date.class}, (Object)object2, n)) {
            case 0: {
                XMLGregorianCalendar theXGCal = (XMLGregorianCalendar)object2;
                GregorianCalendar theGCal = theXGCal.toGregorianCalendar();
                Date theDate = theGCal.getTime();
                attribute.setDateValue(DateUtil.format(theDate));
                break;
            }
            case 1: {
                Date date = (Date)object2;
                attribute.setDateValue(DateUtil.format(date));
                break;
            }
            default: {
                attribute.setDateValue(null);
            }
        }
    }

    public int getEditor() {
        return this.editor;
    }

    public void setEditor(int editor) {
        this.editor = editor;
    }

    public Long getSetId() {
        return this.setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }

    public int getHidden() {
        return this.hidden;
    }

    public void setHidden(int hidden) {
        this.hidden = hidden;
    }

    public int getMultiple() {
        return this.multiple;
    }

    public String getParent() {
        return this.parent;
    }

    public void setMultiple(int multiple) {
        this.multiple = multiple;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getStringValues() {
        return this.stringValues;
    }

    public void setStringValues(String stringValues) {
        this.stringValues = stringValues;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public String getInitialization() {
        return this.initialization;
    }

    public void setInitialization(String initialization) {
        this.initialization = initialization;
    }

    public int getReadonly() {
        return this.readonly;
    }

    public void setReadonly(int readonly) {
        this.readonly = readonly;
    }
}

