/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.mobile;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.AbstractService;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.mobile.CommentListVO;
import com.logicaldoc.webservice.mobile.CommentVO;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentService
extends AbstractService {
    protected final Logger log = LoggerFactory.getLogger(CommentService.class);

    @GET
    @Path(value="/getcomments/{sid}/{docid}")
    @Produces(value={"application/json"})
    public Response getComments(@PathParam(value="sid") String sid, @PathParam(value="docid") String docid) throws AuthenticationException, WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        Long docId = Long.parseLong(docid);
        Document document = (Document)ddao.findById(docId);
        this.checkDocumentPermission(Permission.READ, user, docId);
        boolean writeEnabled = this.isWriteEnabled(user, docId);
        DocumentNoteDAO dndao = Context.get(DocumentNoteDAO.class);
        List<DocumentNote> notes = dndao.findByDocId(docId, document.getFileVersion());
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yyyy HH:mm:ss Z", Locale.ENGLISH);
        CommentListVO comments = new CommentListVO();
        for (DocumentNote note : notes) {
            CommentVO cvo = new CommentVO();
            cvo.setName(String.valueOf(note.getId()));
            cvo.setContent(note.getMessage());
            cvo.setAuthor(note.getUsername());
            String formattedDate = sdf.format(note.getLastModified());
            cvo.setModifiedOn(formattedDate);
            comments.getItems().add(cvo);
        }
        if (writeEnabled) {
            comments.getNodePermissions().setCreate(true);
            comments.getNodePermissions().setDelete(true);
            comments.getNodePermissions().setEdit(true);
        }
        return Response.ok((Object)comments).build();
    }

    private boolean isWriteEnabled(User user, long docId) {
        try {
            DocumentDAO dao = Context.get(DocumentDAO.class);
            if (dao.isPermissionAllowed(Permission.WRITE, docId, user.getId())) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return false;
    }

    @POST
    @Path(value="/addcommentform/{sid}/{docid}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response addCommentForm(@PathParam(value="sid") String sid, @PathParam(value="docid") String docid, @FormParam(value="content") String content) throws AuthenticationException, WebserviceException, PersistenceException {
        CommentVO comment = new CommentVO();
        comment.setContent(content);
        User user = this.validateSession(sid);
        DocumentNote note = new DocumentNote();
        note.setDocId(Long.parseLong(docid));
        note.setUserId(user.getId());
        note.setUsername(user.getFullName());
        note.setDate(new Date());
        note.setMessage(content);
        DocumentNoteDAO dndao = Context.get(DocumentNoteDAO.class);
        dndao.store(note);
        return Response.ok((Object)comment).build();
    }

    @POST
    @Path(value="/addcomment/{sid}/{docid}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response addComment(@PathParam(value="sid") String sid, @PathParam(value="docid") String docid, CommentVO comment) throws AuthenticationException, WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        DocumentNote note = new DocumentNote();
        note.setDocId(Long.parseLong(docid));
        note.setUserId(user.getId());
        note.setUsername(user.getFullName());
        note.setDate(new Date());
        note.setMessage(comment.getContent());
        DocumentNoteDAO dndao = Context.get(DocumentNoteDAO.class);
        dndao.store(note);
        return Response.ok((Object)comment).build();
    }
}

