/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc.view.simple;

import com.logicaldoc.webservice.doc.JavaNameDisplayStrategy;
import com.logicaldoc.webservice.doc.view.simple.SimpleClassNameDisplayUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class SimpleJavaNameDisplayStrategy
implements JavaNameDisplayStrategy {
    private static final Map<Class<?>, String> PRIMITIVE_TYPE_DISPLAY = new HashMap();

    static {
        PRIMITIVE_TYPE_DISPLAY.put(String.class, "String");
        PRIMITIVE_TYPE_DISPLAY.put(BigDecimal.class, "BigDecimal");
        PRIMITIVE_TYPE_DISPLAY.put(BigInteger.class, "BigInteger");
        PRIMITIVE_TYPE_DISPLAY.put(Byte.class, "Byte");
        PRIMITIVE_TYPE_DISPLAY.put(Double.class, "Double");
        PRIMITIVE_TYPE_DISPLAY.put(Float.class, "Float");
        PRIMITIVE_TYPE_DISPLAY.put(Integer.class, "Integer");
        PRIMITIVE_TYPE_DISPLAY.put(Long.class, "Long");
        PRIMITIVE_TYPE_DISPLAY.put(Short.class, "Short");
        PRIMITIVE_TYPE_DISPLAY.put(Integer.TYPE, "Int");
        PRIMITIVE_TYPE_DISPLAY.put(Long.TYPE, "Long");
        PRIMITIVE_TYPE_DISPLAY.put(Float.TYPE, "Float");
        PRIMITIVE_TYPE_DISPLAY.put(Double.TYPE, "Double");
        PRIMITIVE_TYPE_DISPLAY.put(Byte.TYPE, "Byte");
        PRIMITIVE_TYPE_DISPLAY.put(Character.TYPE, "Char");
        PRIMITIVE_TYPE_DISPLAY.put(Boolean.class, "Boolean");
        PRIMITIVE_TYPE_DISPLAY.put(Boolean.TYPE, "Boolean");
        PRIMITIVE_TYPE_DISPLAY.put(Date.class, "Date");
        PRIMITIVE_TYPE_DISPLAY.put(Calendar.class, "Calendar");
        PRIMITIVE_TYPE_DISPLAY.put(XMLGregorianCalendar.class, "Calendar");
    }

    @Override
    public String displayElementName(String elementName) {
        if (!elementName.contains("-")) {
            return elementName;
        }
        String[] words = StringUtils.split(elementName, "-");
        ArrayList<String> capitalized = new ArrayList<String>();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            capitalized.add(!capitalized.isEmpty() ? StringUtils.capitalize(word) : word);
            ++n2;
        }
        return StringUtils.join(capitalized, "");
    }

    @Override
    public String displayClassName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.endsWith("Service")) {
            className = className.substring(0, className.length() - "Service".length());
        }
        return SimpleClassNameDisplayUtils.display(className);
    }

    @Override
    public String displayElementType(Class<?> type) {
        String display = PRIMITIVE_TYPE_DISPLAY.get(type);
        if (display != null) {
            return display;
        }
        if (type.isEnum()) {
            return StringUtils.join(Arrays.asList(type.getEnumConstants()), "<br/>");
        }
        String name = type.getName();
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }
}

