/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc.view.simple;

public class SimpleClassNameDisplayUtils {
    private SimpleClassNameDisplayUtils() {
    }

    public static String display(String className) {
        StringBuilder sb = new StringBuilder();
        int firstIndex = 0;
        int lastIndex = className.length() - 1;
        int i = firstIndex;
        while (i <= lastIndex) {
            CharType thisCharType = SimpleClassNameDisplayUtils.getCharType(className.charAt(i));
            CharType lastCharType = null;
            CharType nextCharType = null;
            if (i > firstIndex) {
                lastCharType = SimpleClassNameDisplayUtils.getCharType(className.charAt(i - 1));
            }
            if (i < lastIndex) {
                nextCharType = SimpleClassNameDisplayUtils.getCharType(className.charAt(i + 1));
            }
            if (SimpleClassNameDisplayUtils.shouldInsertBlank(thisCharType, lastCharType, nextCharType)) {
                sb.append(" ");
            }
            sb.append(className.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private static boolean shouldInsertBlank(CharType thisCharType, CharType lastCharType, CharType nextCharType) {
        if (thisCharType == CharType.LOWER_CASE) {
            if (lastCharType == null) {
                return false;
            }
            if (lastCharType == CharType.LOWER_CASE) {
                return false;
            }
            if (lastCharType == CharType.OTHER) {
                return false;
            }
        }
        if (thisCharType == CharType.OTHER) {
            if (lastCharType == null) {
                return false;
            }
            if (lastCharType == CharType.LOWER_CASE) {
                return true;
            }
            if (lastCharType == CharType.OTHER) {
                return nextCharType == CharType.LOWER_CASE;
            }
        }
        throw new IllegalStateException("Unreachable statement");
    }

    private static boolean isLowerCase(char c) {
        return c <= 'z' && c >= 'a';
    }

    private static CharType getCharType(char c) {
        if (SimpleClassNameDisplayUtils.isLowerCase(c)) {
            return CharType.LOWER_CASE;
        }
        return CharType.OTHER;
    }

    private static enum CharType {
        LOWER_CASE,
        OTHER;

    }
}

