/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc.view.freemarker;

import com.logicaldoc.webservice.doc.JavaNameDisplayStrategy;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.doc.model.WebServiceStubSet;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerWebServiceDisplayer {
    private final Template template;
    private final WebServiceStubSet serviceStubSet;
    private final JavaNameDisplayStrategy nameDisplayingStrategy;

    FreemarkerWebServiceDisplayer(Template template, JavaNameDisplayStrategy nameDisplayingStrategy, WebServiceStubSet serviceStubSet) {
        this.template = template;
        this.nameDisplayingStrategy = nameDisplayingStrategy;
        this.serviceStubSet = serviceStubSet;
    }

    public String displayWebService() {
        try {
            HashMap<String, Object> rootMap = new HashMap<String, Object>();
            rootMap.put("service", this.serviceStubSet);
            rootMap.put("elementType", new DisplayElementTypeMethodModel());
            rootMap.put("elementName", new DisplayElementNameMethodModel());
            rootMap.put("className", new DisplayReadableClassNameMethodModel());
            rootMap.put("classDescription", new DisplayClassDescriptionMethodModel());
            StringWriter out = new StringWriter();
            this.template.process(rootMap, (Writer)out);
            return out.toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Class<?> toClass(String className) {
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("void")) {
            return Void.TYPE;
        }
        if (className.startsWith("[L")) {
            className = className.substring(2, className.length() - 1);
        } else if (className.startsWith("[[L")) {
            className = className.substring(3, className.length() - 1);
        } else if (className.equals("[J")) {
            className = Long.class.getName();
        } else if (className.equals("[D")) {
            className = Double.class.getName();
        }
        try {
            return this.serviceStubSet.getWebServiceClass().getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            Logger console = LoggerFactory.getLogger("console");
            console.warn(e.getMessage());
            console.warn("Cannot generate html for type {}. Will use 'UnkownType' instead", (Object)className);
            return UnkownType.class;
        }
    }

    private final class DisplayClassDescriptionMethodModel
    implements TemplateMethodModel {
        private DisplayClassDescriptionMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            String className = (String)arguments.get(0);
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                WSDoc annotation = clazz.getAnnotation(WSDoc.class);
                if (annotation != null) {
                    return annotation.description();
                }
                return "";
            }
            catch (Exception t) {
                return "";
            }
        }
    }

    private final class DisplayElementNameMethodModel
    implements TemplateMethodModel {
        private DisplayElementNameMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            return FreemarkerWebServiceDisplayer.this.nameDisplayingStrategy.displayElementName((String)arguments.get(0));
        }
    }

    private final class DisplayElementTypeMethodModel
    implements TemplateMethodModel {
        private DisplayElementTypeMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            String className = (String)arguments.get(0);
            Class<?> clazz = FreemarkerWebServiceDisplayer.this.toClass(className);
            return FreemarkerWebServiceDisplayer.this.nameDisplayingStrategy.displayElementType(clazz);
        }
    }

    private final class DisplayReadableClassNameMethodModel
    implements TemplateMethodModel {
        private DisplayReadableClassNameMethodModel() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            String className = (String)arguments.get(0);
            Class<?> clazz = FreemarkerWebServiceDisplayer.this.toClass(className);
            return FreemarkerWebServiceDisplayer.this.nameDisplayingStrategy.displayClassName(clazz);
        }
    }

    private static interface UnkownType {
    }
}

