/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc.service;

import com.logicaldoc.webservice.doc.model.WebServiceStubSet;
import com.logicaldoc.webservice.doc.service.WebMethodStubSetFactory;
import jakarta.jws.WebMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class WebServiceStubSetFactory {
    private WebServiceStubSetFactory() {
    }

    public static WebServiceStubSet createWebServiceStubSet(Class<?> webServiceClass) {
        List<Method> methods = WebServiceStubSetFactory.getWebMethods(webServiceClass);
        WebServiceStubSet serviceStubs = new WebServiceStubSet();
        serviceStubs.setWebServiceClass(webServiceClass);
        for (Method method : methods) {
            serviceStubs.addMethodStub(WebMethodStubSetFactory.createWebMethodStubSet(method));
        }
        return serviceStubs;
    }

    private static List<Method> getWebMethods(Class<?> webServiceClass) {
        ArrayList<Method> webMethods = new ArrayList<Method>();
        Method[] methodArray = webServiceClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(WebMethod.class)) {
                webMethods.add(method);
            }
            ++n2;
        }
        return webMethods;
    }
}

