/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc.service;

import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.doc.model.JavaLanguageVariable;
import com.logicaldoc.webservice.doc.model.Stub;
import com.logicaldoc.webservice.doc.model.WebMethodStubSet;
import com.logicaldoc.webservice.doc.service.JavaLanguageVariableFactory;
import com.logicaldoc.webservice.doc.service.Variable2Stub;
import java.lang.reflect.Method;
import java.util.List;

public class WebMethodStubSetFactory {
    private WebMethodStubSetFactory() {
    }

    public static WebMethodStubSet createWebMethodStubSet(Method method) {
        WebMethodStubSet stubSet = new WebMethodStubSet();
        stubSet.setMethodName(method.getName());
        WSDoc annotation = method.getAnnotation(WSDoc.class);
        if (annotation != null) {
            stubSet.setDescription(annotation.description());
        }
        WebMethodStubSetFactory.addRequestStubs(method, stubSet);
        if (!Void.TYPE.equals(method.getReturnType())) {
            WebMethodStubSetFactory.addResponseStub(method, stubSet);
        }
        return stubSet;
    }

    private static void addResponseStub(Method method, WebMethodStubSet stubSet) {
        JavaLanguageVariable variable = JavaLanguageVariableFactory.createVariableFromMethodReturn(method);
        Stub stub = Variable2Stub.convertToStub(variable, stubSet.getStubTypeTreeRepository());
        stubSet.setResponseStub(stub);
    }

    private static void addRequestStubs(Method method, WebMethodStubSet stubSet) {
        List<JavaLanguageVariable> requestVariables = JavaLanguageVariableFactory.createVariablesFromMethodParamaters(method);
        for (JavaLanguageVariable variable : requestVariables) {
            Stub stub = Variable2Stub.convertToStub(variable, stubSet.getStubTypeTreeRepository());
            stubSet.addRequetStub(stub);
        }
    }
}

