/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc.service;

import com.logicaldoc.webservice.doc.model.JavaLanguageVariable;
import com.logicaldoc.webservice.doc.model.Stub;
import com.logicaldoc.webservice.doc.model.StubTypeTree;
import com.logicaldoc.webservice.doc.service.JavaLanguageVariableFactory;
import com.logicaldoc.webservice.doc.service.StubTypeTreeRepository;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Variable2Stub {
    private Variable2Stub() {
    }

    public static Stub convertToStub(JavaLanguageVariable variable, StubTypeTreeRepository typeTreeRepository) {
        Stub stub = new Stub();
        stub.setStubName(variable.getVariableName());
        stub.setRequired(variable.isRequired());
        stub.setMultiOccurs(variable.isMultiOccurs());
        stub.setDescription(variable.getDescription());
        stub.setType(variable.getType());
        Class<?> type = variable.getType();
        if (variable.getType().isArray()) {
            type = variable.getType().getComponentType();
        }
        if (type.isAnnotationPresent(XmlType.class) && !type.isEnum()) {
            Variable2Stub.convertFieldsToChildStubs(stub, type, typeTreeRepository);
        }
        return stub;
    }

    private static void convertFieldsToChildStubs(Stub parentStub, Class<?> type, StubTypeTreeRepository typeTreeRepository) {
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field childField = fieldArray[n2];
            Stub child = Variable2Stub.convertToStub(JavaLanguageVariableFactory.createVariableFromField(childField), typeTreeRepository);
            parentStub.addChild(child);
            ++n2;
        }
        LinkedList<FieldsOfSubType> fieldsOfSubTypes = Variable2Stub.getFieldsOfSubTypes(type, typeTreeRepository);
        for (FieldsOfSubType fieldsOfSubType : fieldsOfSubTypes) {
            for (Field field : fieldsOfSubType.fields) {
                Stub childStub = Variable2Stub.convertToStub(JavaLanguageVariableFactory.createVariableFromField(field), typeTreeRepository);
                childStub.setSubTypeOfParentStub(fieldsOfSubType.subType);
                parentStub.addChild(childStub);
            }
        }
    }

    private static LinkedList<FieldsOfSubType> getFieldsOfSubTypes(Class<?> thisType, StubTypeTreeRepository typeTreeRepository) {
        LinkedList<FieldsOfSubType> fieldsOfAllSubTypes = new LinkedList<FieldsOfSubType>();
        if (!thisType.isAnnotationPresent(XmlSeeAlso.class)) {
            return fieldsOfAllSubTypes;
        }
        List<Class<?>> subTypes = Variable2Stub.getSubTypes(thisType);
        Variable2Stub.registerToStubTypeTree(thisType, typeTreeRepository, subTypes);
        for (Class<?> subType : subTypes) {
            FieldsOfSubType fieldsOfSubType = new FieldsOfSubType(subType);
            fieldsOfSubType.addAll(Arrays.asList(subType.getDeclaredFields()));
            LinkedList<FieldsOfSubType> fieldsOfGrandSonType = Variable2Stub.getFieldsOfSubTypes(subType, typeTreeRepository);
            fieldsOfAllSubTypes.add(fieldsOfSubType);
            fieldsOfAllSubTypes.addAll(fieldsOfGrandSonType);
        }
        return fieldsOfAllSubTypes;
    }

    private static void registerToStubTypeTree(Class<?> thisType, StubTypeTreeRepository typeTreeRepository, List<Class<?>> subTypes) {
        StubTypeTree thisTypeTree = typeTreeRepository.getStubTypeTree(thisType);
        for (Class<?> subType : subTypes) {
            StubTypeTree subTypeTree = typeTreeRepository.getStubTypeTree(subType);
            subTypeTree.setParent(thisTypeTree);
        }
    }

    private static List<Class<?>> getSubTypes(Class<?> thisType) {
        ArrayList subTypes = new ArrayList();
        Class[] classArray = thisType.getAnnotation(XmlSeeAlso.class).value();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class subType = classArray[n2];
            if (thisType.isAssignableFrom(subType)) {
                subTypes.add(subType);
            }
            ++n2;
        }
        return subTypes;
    }

    private static final class FieldsOfSubType {
        private Class<?> subType;
        private List<Field> fields = new ArrayList<Field>();

        private FieldsOfSubType(Class<?> subType) {
            this.subType = subType;
        }

        public void addAll(List<Field> fields) {
            this.fields.addAll(fields);
        }
    }
}

