/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc.service;

import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.doc.model.JavaLanguageVariable;
import com.logicaldoc.webservice.doc.util.GenericsUtils;
import com.logicaldoc.webservice.doc.util.MyClassUtils;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JavaLanguageVariableFactory {
    private JavaLanguageVariableFactory() {
    }

    public static JavaLanguageVariable createVariableFromField(Field field) {
        JavaLanguageVariable variable = new JavaLanguageVariable();
        WSDoc annotation = field.getAnnotation(WSDoc.class);
        if (annotation == null) {
            variable.setVariableName(JavaLanguageVariableFactory.getElementName(field));
            variable.setRequired(true);
        } else {
            variable.setVariableName(JavaLanguageVariableFactory.getVariableName(field, annotation));
            variable.setRequired(JavaLanguageVariableFactory.isVariableRequired(annotation));
            variable.setDescription(JavaLanguageVariableFactory.getVariableDescription(annotation));
        }
        if (MyClassUtils.isClassArrayOrCollection(field.getType())) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType aType = (ParameterizedType)type;
                Type[] fieldArgTypes = aType.getActualTypeArguments();
                variable.setType((Class)fieldArgTypes[0]);
            } else {
                variable.setType(field.getType().getComponentType());
            }
        } else {
            variable.setType(GenericsUtils.getFieldGenericType(field));
        }
        variable.setMultiOccurs(MyClassUtils.isClassArrayOrCollection(field.getType()));
        return variable;
    }

    private static String getElementName(Field field) {
        return field.getName();
    }

    private static String getVariableName(Field field, WSDoc annotation) {
        if (!annotation.documented()) {
            return "sskip";
        }
        return JavaLanguageVariableFactory.getElementName(field);
    }

    private static String getVariableDescription(WSDoc annotation) {
        return annotation.description();
    }

    public static List<JavaLanguageVariable> createVariablesFromMethodParamaters(Method method) {
        ArrayList<JavaLanguageVariable> variables = new ArrayList<JavaLanguageVariable>();
        Annotation[][] annotationMatrix = method.getParameterAnnotations();
        int paramIndex = 0;
        while (paramIndex < annotationMatrix.length) {
            Annotation[] annotationsForSingleParam = annotationMatrix[paramIndex];
            WebParam xmlAnnotation = JavaLanguageVariableFactory.getXmlAnnotation(annotationsForSingleParam);
            JavaLanguageVariable variable = JavaLanguageVariableFactory.buildJavaVariableFromMethodParam(method, paramIndex, xmlAnnotation);
            variables.add(variable);
            ++paramIndex;
        }
        return variables;
    }

    public static JavaLanguageVariable createVariableFromMethodReturn(Method method) {
        WebResult webResultAnnotation = method.getAnnotation(WebResult.class);
        JavaLanguageVariable variable = new JavaLanguageVariable();
        variable.setType(GenericsUtils.getMethodGenericReturnType(method));
        variable.setVariableName(webResultAnnotation != null ? webResultAnnotation.name() : "");
        variable.setRequired(true);
        Class<?> resultClass = method.getReturnType();
        variable.setMultiOccurs(MyClassUtils.isClassArrayOrCollection(resultClass));
        return variable;
    }

    private static JavaLanguageVariable buildJavaVariableFromMethodParam(Method method, int paramIndex, WebParam xmlAnnotation) {
        JavaLanguageVariable variable = new JavaLanguageVariable();
        variable.setType(GenericsUtils.getMethodGenericParameterTypes(method, paramIndex));
        if (xmlAnnotation != null) {
            variable.setVariableName(xmlAnnotation.name());
        } else {
            variable.setVariableName(GenericsUtils.getMethodGenericParameterName(method, paramIndex));
        }
        WSDoc docAnnotation = method.getParameters()[paramIndex].getAnnotation(WSDoc.class);
        if (docAnnotation != null) {
            variable.setDescription(docAnnotation.description());
        }
        variable.setRequired(JavaLanguageVariableFactory.isVariableRequired(docAnnotation));
        Class<?> paramClass = method.getParameterTypes()[paramIndex];
        variable.setMultiOccurs(MyClassUtils.isClassArrayOrCollection(paramClass));
        return variable;
    }

    private static WebParam getXmlAnnotation(Annotation[] annotationForSingleParam) {
        Annotation[] annotationArray = annotationForSingleParam;
        int n = annotationForSingleParam.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof WebParam) {
                WebParam webParam = (WebParam)annotation;
                return webParam;
            }
            ++n2;
        }
        return null;
    }

    static boolean isVariableRequired(WSDoc annotation) {
        if (annotation == null) {
            return true;
        }
        return annotation.required();
    }
}

