/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice.doc;

import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.webservice.doc.WSDoc;
import com.logicaldoc.webservice.doc.model.WebMethodStubSet;
import com.logicaldoc.webservice.doc.model.WebServiceStubSet;
import com.logicaldoc.webservice.doc.service.WebServiceStubSetFactory;
import com.logicaldoc.webservice.doc.view.freemarker.ClasspathFreemarkerWebServiceDisplayEngine;
import com.logicaldoc.webservice.doc.view.freemarker.FreemarkerWebServiceDisplayEngine;
import com.logicaldoc.webservice.doc.view.simple.SimpleJavaNameDisplayStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceDocGen {
    private static final Logger console = LoggerFactory.getLogger("console");

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws ClassNotFoundException {
        String release = args[0];
        File outputDir = new File(args[1]);
        ArrayList services = new ArrayList();
        int i = 2;
        while (i < args.length) {
            try {
                void var5_9;
                String string = args[i];
                if (!string.startsWith("com.logicaldoc.")) {
                    String string2 = "com.logicaldoc." + args[i];
                }
                services.add(Class.forName((String)var5_9));
            }
            catch (Exception exception) {
                console.error(exception.getMessage());
            }
            ++i;
        }
        WebserviceDocGen doc = new WebserviceDocGen();
        doc.indexPage(release, outputDir, services);
        for (Class clazz : services) {
            doc.singleReport(outputDir, clazz);
        }
    }

    public void indexPage(String release, File outputDir, List<Class<?>> services) {
        outputDir.mkdirs();
        FreemarkerWebServiceDisplayEngine displayEngine = ClasspathFreemarkerWebServiceDisplayEngine.createEngine(new SimpleJavaNameDisplayStrategy(), "/wsdocindex.ftl");
        WebServiceStubSet serviceStubSet = new WebServiceStubSet();
        serviceStubSet.setRelease(release);
        for (Class<?> clazz : services) {
            WebMethodStubSet stub = new WebMethodStubSet();
            Object name = clazz.getSimpleName() + ".";
            name = ((String)name).replace("Service.", "");
            stub.setMethodName((String)name);
            WSDoc annotation = clazz.getAnnotation(WSDoc.class);
            if (annotation != null) {
                stub.setDescription(annotation.description());
            }
            serviceStubSet.addMethodStub(stub);
        }
        String html = displayEngine.displayWebService(serviceStubSet);
        String fileName = "index.html";
        File outputFile = new File(outputDir, fileName);
        FileUtil.writeFile(html, outputFile.getAbsolutePath());
        console.info("Please find the HTML files at {}", (Object)outputFile.getAbsolutePath());
    }

    public void singleReport(File outputDir, Class<?> webServiceClass) {
        WebServiceStubSet serviceStubSet = WebServiceStubSetFactory.createWebServiceStubSet(webServiceClass);
        outputDir.mkdirs();
        FreemarkerWebServiceDisplayEngine displayEngine = ClasspathFreemarkerWebServiceDisplayEngine.createEngine(new SimpleJavaNameDisplayStrategy(), "/wsdoc.ftl");
        String html = displayEngine.displayWebService(serviceStubSet);
        Object fileName = webServiceClass.getSimpleName();
        fileName = (String)fileName + ".html";
        fileName = ((String)fileName).replace("Service.", ".");
        File outputFile = new File(outputDir, (String)fileName);
        FileUtil.writeFile(html, outputFile.getAbsolutePath());
        console.info("Please find the HTML files at {}", (Object)outputFile.getAbsolutePath());
    }
}

