/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice;

import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.util.MimeType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class WebserviceServletUtil {
    private static final String UTF_8 = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 10240;

    private WebserviceServletUtil() {
    }

    public static void setContentDisposition(HttpServletRequest request, HttpServletResponse response, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent").toLowerCase();
        Object encodedFileName = null;
        if (userAgent.contains("msie") || userAgent.contains("opera") || userAgent.contains("trident") && userAgent.contains("windows") || userAgent.contains("edge") && userAgent.contains("windows")) {
            encodedFileName = URLEncoder.encode(filename, UTF_8);
            encodedFileName = ((String)encodedFileName).replace("+", "%20");
        } else {
            encodedFileName = userAgent.contains("safari") && !userAgent.contains("chrome") ? filename : (userAgent.contains("safari") && userAgent.contains("chrome") && userAgent.contains("android") ? filename : "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])filename.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8) + "?=");
        }
        boolean asAttachment = true;
        if (request.getParameter("open") != null) {
            asAttachment = !"true".equals(request.getParameter("open"));
        } else if (request.getAttribute("open") != null) {
            asAttachment = !"true".equals(request.getAttribute("open"));
        }
        response.setHeader("Content-Disposition", (asAttachment ? "attachment" : "inline") + "; filename=\"" + (String)encodedFileName + "\"");
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void downloadFile(HttpServletRequest request, HttpServletResponse response, File file, String fileName) throws IOException {
        String filename = fileName;
        if (filename == null) {
            filename = file.getName();
        }
        String mimetype = MimeType.getByFilename(filename);
        response.setContentType(mimetype);
        WebserviceServletUtil.setContentDisposition(request, response, filename);
        response.setHeader("Content-Length", Long.toString(file.length()));
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 10240);
            try {
                try (ServletOutputStream os = response.getOutputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static Session validateSession(HttpServletRequest request) throws ServletException {
        String sid = SessionManager.get().getSessionId(request);
        return WebserviceServletUtil.validateSession(sid);
    }

    public static Session validateSession(String sid) throws ServletException {
        Session session = SessionManager.get().get(sid);
        if (session == null) {
            throw new ServletException("Invalid Session");
        }
        if (!SessionManager.get().isOpen(sid)) {
            throw new ServletException("Invalid or Expired Session");
        }
        SessionManager.get().renew(sid);
        return session;
    }
}

