/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice;

import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.util.Pair;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.TimeDiff;
import com.logicaldoc.webservice.WebserviceCall;
import com.logicaldoc.webservice.WebserviceCallDAO;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String THREADPOOL_CALL_COUNTER = "WebserviceCallCounter";
    public static final String THREADPOOL_CALL_STORE = "WebserviceCallStore";
    public static final String WSCALL = "wscall";
    public static final String WSCALL_HYPHEN = "wscall-";
    private static final Logger log = LoggerFactory.getLogger(WebserviceInterceptor.class);
    @Resource(name="sequenceDAO")
    private SequenceDAO sequenceDAO;
    @Resource(name="ContextProperties")
    private ContextProperties settings;
    private static ConcurrentHashMap<Pair<String, Long>, AtomicLong> counters = new ConcurrentHashMap();
    private Date lastSync;
    private Date lastClean;

    public WebserviceInterceptor() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        if (!this.settings.getBoolean("webservice.enabled", false)) {
            ResourceBundle bundle = BundleUtils.getBundle(WebserviceInterceptor.class);
            throw new Fault(new org.apache.cxf.common.i18n.Message("Webservices not enabled", bundle, new Object[0]));
        }
        String payload = WebserviceInterceptor.getPayload(message, 2048L);
        Session session = null;
        try {
            session = WebserviceInterceptor.getSession(message, payload);
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
        }
        try {
            this.increaseCounters(session);
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
        }
        try {
            this.recordWebserviceCall(message, session);
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
        }
    }

    private void recordWebserviceCall(Message message, Session session) {
        if (RunLevel.current().aspectEnabled("saveApiCall") && this.settings.getBoolean("webservice.call.record", false)) {
            WebserviceCall call = new WebserviceCall();
            if (Context.get().getProperties().getBoolean("webservice.call.record.payload", false)) {
                String payload = WebserviceInterceptor.getPayload(message, null);
                call.setPayload(payload);
            } else {
                call.setPayload(null);
            }
            HttpServletRequest req = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            if (req != null) {
                call.setIp(req.getRemoteAddr());
            }
            call.setTenantId(-1L);
            if (session != null) {
                call.setSession(session);
            }
            this.saveCall(call, message);
        }
    }

    private void saveCall(WebserviceCall call, Message message) {
        call.setProtocol(message instanceof SoapMessage ? "soap" : "rest");
        call.setUri(this.getURI(message));
        if (call.getPayload() != null) {
            call.setPayload(WebserviceInterceptor.stripFileContent(call.getPayload()));
            call.setPayload(WebserviceInterceptor.maskCredentials(call.getPayload()));
        }
        if (call.getPayload() != null && call.getPayload().length() > 4000) {
            call.setPayload(StringUtils.abbreviate((String)call.getPayload(), (int)4000));
        }
        if (call.getSessionId() != null) {
            String sid = call.getSessionId();
            String maskedSid = StringUtils.overlay((String)sid, (String)StringUtils.repeat((String)"X", (int)(sid.length() - 6)), (int)0, (int)(sid.length() - 6));
            if (call.getUri() != null) {
                call.setUri(call.getUri().replace(sid, maskedSid));
            }
            if (call.getPayload() != null) {
                call.setPayload(call.getPayload().replace(sid, maskedSid));
            }
        }
        if (call.getUri() != null) {
            call.setUri(WebserviceInterceptor.maskCredentials(call.getUri()));
        }
        ThreadPools pools = Context.get(ThreadPools.class);
        pools.schedule(new WebserviceCallStore(call), THREADPOOL_CALL_STORE, 5000L);
    }

    private String getURI(Message message) {
        String query;
        Object uri = (String)message.get((Object)"org.apache.cxf.request.url");
        if (uri != null && (query = (String)message.get((Object)Message.QUERY_STRING)) != null) {
            uri = (String)uri + "?" + query;
        }
        return uri;
    }

    static String maskCredentials(String originalString) {
        String matchedText;
        String maskedString = originalString;
        String pattern = "<password(.*)>([\\w\\-\\d]*)</password>";
        Pattern regPat = Pattern.compile(pattern);
        Matcher matcher = regPat.matcher(maskedString);
        while (matcher.find()) {
            matchedText = matcher.group();
            if (matchedText.equals(originalString)) continue;
            maskedString = maskedString.replace(matchedText, "<password>XXXX</password>");
        }
        pattern = "password=[^&.]*";
        regPat = Pattern.compile(pattern);
        matcher = regPat.matcher(maskedString);
        while (matcher.find()) {
            matchedText = matcher.group();
            if (matchedText.equals(maskedString)) continue;
            maskedString = maskedString.replace(matchedText, "password=XXXX");
        }
        return maskedString;
    }

    static String stripFileContent(String originalString) {
        return originalString.replaceAll("<content[^>]*>.*</content>", "<content>...</content>");
    }

    protected void increaseCounters(Session session) {
        long timeSinceLastSync;
        String currentMonth = WebserviceInterceptor.getCurrentMonth();
        this.increaseCounter(WSCALL, -1L);
        this.increaseCounter(WSCALL_HYPHEN + currentMonth, -1L);
        if (session != null) {
            this.increaseCounter(WSCALL, session.getTenantId());
            this.increaseCounter(WSCALL_HYPHEN + currentMonth, session.getTenantId());
        }
        Date now = new Date();
        if (this.lastSync == null) {
            this.lastSync = new Date(1L);
        }
        if ((timeSinceLastSync = ChronoUnit.MINUTES.between(this.lastSync.toInstant(), now.toInstant())) >= 10L) {
            ThreadPools pools = Context.get(ThreadPools.class);
            pools.schedule(new WebserviceCallCounterSync(), THREADPOOL_CALL_COUNTER, 5000L);
        }
    }

    protected void syncCounters() {
        for (Map.Entry<Pair<String, Long>, AtomicLong> entry : counters.entrySet()) {
            AtomicLong counter = entry.getValue();
            this.sequenceDAO.next(entry.getKey().getKey(), 0L, entry.getKey().getValue(), counter.get());
            counter.set(0L);
        }
        this.lastSync = new Date();
    }

    public void shutdown() {
        try {
            this.syncCounters();
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
        }
    }

    protected void increaseCounter(String counterName, long tenantId) {
        Pair<String, Long> counterPair = new Pair<String, Long>(counterName, tenantId);
        AtomicLong counter = counters.computeIfAbsent(counterPair, k -> new AtomicLong(0L));
        counter.incrementAndGet();
    }

    static Session getSession(Message message, String payload) {
        String pattern;
        Pattern regPat;
        Matcher matcher;
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        Session session = SessionManager.get().getSession(request);
        if (session != null) {
            return session;
        }
        if (StringUtils.isEmpty((CharSequence)payload)) {
            payload = WebserviceInterceptor.getPayload(message, 2048L);
        }
        if (StringUtils.isNotEmpty((CharSequence)payload) && (matcher = (regPat = Pattern.compile(pattern = "<sid(.*)>([\\w\\-]*)</sid>")).matcher(payload)).find()) {
            String matchedText = matcher.group();
            String sid = matchedText.substring(matchedText.indexOf(62) + 1, matchedText.lastIndexOf(60));
            session = SessionManager.get().get(sid);
        }
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getPayload(Message message, Long maxlength) throws Fault {
        Object contentType = message.getContextualProperty("Content-Type");
        if (contentType == null) return null;
        if (!contentType.toString().toLowerCase().startsWith("text/")) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                CachedOutputStream bos;
                InputStream is;
                block17: {
                    String string;
                    is = (InputStream)message.getContent(InputStream.class);
                    try {
                        block18: {
                            bos = new CachedOutputStream();
                            try {
                                if (is == null) break block17;
                                IOUtils.copy(is, (OutputStream)bos);
                                bos.flush();
                                StringBuilder sb = new StringBuilder();
                                message.setContent(InputStream.class, (Object)bos.getInputStream());
                                if (maxlength != null) {
                                    bos.writeCacheTo(sb, maxlength.longValue());
                                } else {
                                    bos.writeCacheTo(sb);
                                }
                                string = sb.toString();
                                if (bos == null) break block18;
                            }
                            catch (Throwable throwable2) {
                                if (bos == null) throw throwable2;
                                bos.close();
                                throw throwable2;
                            }
                            bos.close();
                        }
                        if (is == null) return string;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    return string;
                }
                if (bos != null) {
                    bos.close();
                }
                if (is == null) return null;
                is.close();
                return null;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private static String getCurrentMonth() {
        LocalDate date = LocalDate.now();
        StringBuilder sb = new StringBuilder(Integer.toString(date.getYear()));
        int month = date.getMonthValue();
        if (month < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(month));
        return sb.toString();
    }

    public void setSequenceDAO(SequenceDAO sequenceDAO) {
        this.sequenceDAO = sequenceDAO;
    }

    public void setSettings(ContextProperties settings) {
        this.settings = settings;
    }

    class WebserviceCallCounterSync
    implements Callable<Void> {
        WebserviceCallCounterSync() {
        }

        @Override
        public Void call() {
            try {
                WebserviceInterceptor.this.syncCounters();
                WebserviceInterceptor.this.lastSync = new Date();
            }
            catch (Exception t) {
                log.warn(t.getMessage(), t);
            }
            return null;
        }
    }

    class WebserviceCallStore
    implements Callable<Void> {
        private WebserviceCall wsCall;

        public WebserviceCallStore(WebserviceCall wsCall) {
            this.wsCall = wsCall;
        }

        @Override
        public Void call() {
            try {
                long timeSinceLastClean;
                WebserviceCallDAO dao = Context.get(WebserviceCallDAO.class);
                Date now = new Date();
                if (WebserviceInterceptor.this.lastClean == null) {
                    WebserviceInterceptor.this.lastClean = now;
                }
                if ((timeSinceLastClean = TimeDiff.getTimeDifference(WebserviceInterceptor.this.lastClean, now, TimeDiff.TimeField.HOUR)) >= 24L) {
                    dao.cleanOldCalls(WebserviceInterceptor.this.settings.getInt("webservice.call.ttl", 90));
                }
                dao.store(this.wsCall);
            }
            catch (Exception t) {
                log.warn(t.getMessage(), t);
            }
            return null;
        }
    }
}

