/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice;

import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.webservice.WebserviceServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceChartServlet
extends HttpServlet {
    public static final String USER_ID = "userId";
    private static final long serialVersionUID = -6956612970433309888L;
    private static final Logger log = LoggerFactory.getLogger(WebserviceChartServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            File chartFile = null;
            try {
                try {
                    WebserviceServletUtil.validateSession(request);
                    int width = 1200;
                    if (request.getParameter("width") != null) {
                        width = Integer.parseInt(request.getParameter("width"));
                    }
                    int height = 450;
                    if (request.getParameter("height") != null) {
                        height = Integer.parseInt(request.getParameter("height"));
                    }
                    Locale locale = Locale.ENGLISH;
                    if (request.getParameter("locale") != null) {
                        locale = LocaleUtil.toLocale(request.getParameter("locale"));
                    }
                    long tenantId = -1L;
                    if (request.getParameter("tenantId") != null) {
                        tenantId = Long.parseLong(request.getParameter("tenantId"));
                    }
                    chartFile = FileUtil.createTempFile("chart", ".png");
                    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                    SequenceDAO dao = Context.get(SequenceDAO.class);
                    SimpleDateFormat dfName = new SimpleDateFormat("MMM yyyy", locale);
                    SimpleDateFormat dfNumber = new SimpleDateFormat("yyyyMM");
                    int i = 0;
                    while (i < 36) {
                        Calendar cal = Calendar.getInstance();
                        cal.add(2, -i);
                        String month = dfNumber.format(cal.getTime());
                        String monthName = dfName.format(cal.getTime());
                        dataset.addValue((double)dao.getCurrentValue("wscall-" + month, 0L, tenantId), (Comparable)((Object)"calls"), (Comparable)((Object)monthName));
                        ++i;
                    }
                    JFreeChart chart = ChartFactory.createBarChart((String)"", null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                    CategoryPlot catPlot = chart.getCategoryPlot();
                    catPlot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    BarRenderer r = (BarRenderer)catPlot.getRenderer();
                    r.setSeriesPaint(0, (Paint)Color.BLUE);
                    chart.getTitle().setHorizontalAlignment(HorizontalAlignment.LEFT);
                    chart.getTitle().setPaint((Paint)Color.BLUE);
                    CategoryAxis domainAxis = catPlot.getDomainAxis();
                    domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                    ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)chart, (int)width, (int)height);
                    WebserviceServletUtil.downloadFile(request, response, chartFile, "wschart.png");
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    FileUtil.delete(chartFile);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(chartFile);
                throw throwable;
            }
            FileUtil.delete(chartFile);
        }
    }
}

