/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice;

import com.logicaldoc.core.history.History;
import com.logicaldoc.webservice.WebserviceCallEvent;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

@Entity
@Table(name="ld_webservicecall")
@Cacheable
public class WebserviceCall
extends History {
    private static final long serialVersionUID = 1L;
    public static final String SOAP = "soap";
    public static final String REST = "rest";
    public static final String ASPECT = "saveApiCall";
    @Column(name="ld_protocol")
    private String protocol = "soap";

    public WebserviceCall() {
        this.setEvent(WebserviceCallEvent.CALL);
    }

    public void setEvent(WebserviceCallEvent event) {
        this.event = event != null ? event.toString() : null;
    }

    @Override
    public void setEvent(String event) {
        this.setEvent(WebserviceCallEvent.fromKey(event));
    }

    public WebserviceCallEvent getEventEnum() {
        if (this.event == null) {
            return null;
        }
        return WebserviceCallEvent.fromKey(this.event);
    }

    public WebserviceCall(WebserviceCall source) {
        this();
        this.copyAttributesFrom(source);
        this.setProtocol(source.getProtocol());
    }

    public String getPayload() {
        return this.getComment();
    }

    public void setPayload(String payload) {
        this.setComment(payload);
    }

    public String getUri() {
        return this.getPath();
    }

    public void setUri(String uri) {
        this.setPath(uri);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String toString() {
        return "WebserviceCall [uri=" + this.getUri() + ", date=" + String.valueOf(this.getDate()) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebserviceCall other = (WebserviceCall)obj;
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }
}

