/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.webservice;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AccountNotFoundException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authentication.InvalidSessionException;
import com.logicaldoc.core.security.authorization.PermissionException;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.DateUtil;
import com.logicaldoc.webservice.WebserviceException;
import com.logicaldoc.webservice.model.WSUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import java.util.Date;
import java.util.HashSet;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AbstractService {
    private static final String FOLDER = "folder ";
    private static final Logger log = LoggerFactory.getLogger(AbstractService.class);
    private boolean validateSession = true;
    @Resource(name="currentMessage")
    protected Message currentMessage;

    public void setValidateSession(boolean validateSession) {
        this.validateSession = validateSession;
    }

    protected String sessionId(String sidOrApikey) {
        if (!sidOrApikey.startsWith("ld-")) {
            return sidOrApikey;
        }
        return SessionManager.get().getSessionId(this.getCurrentRequest());
    }

    protected User validateSession(String sid) throws WebserviceException, PersistenceException, AuthenticationException {
        UserDAO userDao = Context.get(UserDAO.class);
        if (!this.validateSession) {
            User user = new User();
            user.setId(1L);
            user.setTenantId(1L);
            user.setName("admin");
            HashSet<Group> groups = new HashSet<Group>();
            GroupDAO grpDao = Context.get(GroupDAO.class);
            groups.add((Group)grpDao.findById(1L));
            user.setGroups(groups);
            return user;
        }
        if (!this.isWebserviceEnabled()) {
            throw new WebserviceException("WebServices are disabled");
        }
        if (sid == null || !SessionManager.get().isOpen(sid)) {
            throw new InvalidSessionException(sid);
        }
        SessionManager.get().renew(sid);
        String username = SessionManager.get().get(sid).getUsername();
        User user = userDao.findByUsername(username);
        if (user == null) {
            throw new AccountNotFoundException(null, String.format("User %s not found", username));
        }
        userDao.initialize(user);
        return user;
    }

    protected void checkGroup(String sid, String group) throws WebserviceException, PersistenceException {
        User user = this.validateSession(sid);
        if (!user.isMemberOf(group)) {
            String message = String.format("User %s doesn't belong to group %s", user.getUsername(), group);
            log.error(message);
            throw new WebserviceException(message);
        }
    }

    protected void checkAdministrator(String sid) throws WebserviceException, PersistenceException {
        this.checkGroup(sid, "admin");
    }

    protected void checkMenu(String sid, long menuId) throws WebserviceException, PersistenceException, PermissionException {
        User user = this.validateSession(sid);
        MenuDAO dao = Context.get(MenuDAO.class);
        if (!dao.isReadEnable(menuId, user.getId())) {
            String message = String.format("User %s cannot access menu %s", user.getUsername(), menuId);
            log.error(message);
            throw new PermissionException(user.getUsername(), "menu " + menuId, Permission.READ);
        }
    }

    protected void checkFolderPermission(Permission permission, User user, long folderId) throws PersistenceException, PermissionException {
        FolderDAO dao = Context.get(FolderDAO.class);
        if (!dao.isPermissionAllowed(permission, folderId, user.getId())) {
            String message = String.format("User %s doesn't have permission %s on folder %s", user.getUsername(), permission.name(), folderId);
            log.error(message);
            throw new PermissionException(user.getUsername(), FOLDER + folderId, permission);
        }
    }

    protected void checkDocumentPermission(Permission permission, User user, long docId) throws PersistenceException, PermissionException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        if (!dao.isPermissionAllowed(permission, docId, user.getId())) {
            String message = String.format("User %s doesn't have permission %s on document %s", user.getUsername(), permission.name(), docId);
            log.error(message);
            throw new PermissionException(user.getUsername(), "document " + docId, permission);
        }
    }

    protected void checkMenu(User user, long menuId) throws PermissionException {
        MenuDAO dao = Context.get(MenuDAO.class);
        if (!dao.isReadEnable(menuId, user.getId())) {
            String message = String.format("User %s doesn't have read permission on menu %s", user.getUsername(), menuId);
            log.error(message);
            throw new PermissionException(user.getUsername(), "menu " + menuId, Permission.READ);
        }
    }

    protected void checkPublished(User user, Document doc) throws WebserviceException {
        if (!(user.isMemberOf("admin") || user.isMemberOf("publisher") || doc.isPublishing())) {
            throw new WebserviceException("Document not published");
        }
    }

    protected void checkNotArchived(Document doc) throws WebserviceException {
        if (doc.getStatus() == DocumentStatus.ARCHIVED) {
            throw new WebserviceException("Document is archived");
        }
    }

    protected boolean isWebserviceEnabled() {
        return "true".equals(Context.get().getProperties().get("webservice.enabled"));
    }

    protected String getCurrentSessionId() {
        HttpServletRequest request = this.getCurrentRequest();
        Session session = SessionManager.get().getSession(request);
        if (session != null) {
            return session.getSid();
        }
        return null;
    }

    protected HttpServletRequest getCurrentRequest() {
        HttpServletRequest request = null;
        if (this.currentMessage != null) {
            request = (HttpServletRequest)this.currentMessage.get((Object)"HTTP.REQUEST");
        }
        return request;
    }

    protected String validateSession() throws InvalidSessionException {
        if (this.validateSession) {
            String sid = this.getCurrentSessionId();
            if (sid == null || !SessionManager.get().isOpen(sid)) {
                throw new InvalidSessionException(sid);
            }
            SessionManager.get().renew(sid);
            return sid;
        }
        return null;
    }

    protected String validateSessionREST() throws WebApplicationException {
        try {
            return this.validateSession();
        }
        catch (InvalidSessionException e) {
            throw new WebApplicationException(e.getMessage(), 401);
        }
    }

    public static String convertDateToString(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.format(date);
    }

    public static Date convertStringToDate(String date) {
        return WSUtil.convertStringToDate(date);
    }

    public boolean isValidateSession() {
        return this.validateSession;
    }

    public Message getCurrentMessage() {
        return this.currentMessage;
    }

    public void setCurrentMessage(Message currentMessage) {
        this.currentMessage = currentMessage;
    }
}

