/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.websockets;

import com.logicaldoc.core.automation.AutomationDictionary;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.gui.common.client.websockets.WebsocketMessage;
import com.logicaldoc.web.websockets.EventEndpoint;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

@AutomationDictionary
public class WebsocketTool {
    protected static final Random random = new Random();

    public void showMessage(Session session, String message, String level) {
        WebsocketMessage command = new WebsocketMessage(session.getSid(), "command");
        command.setCommand("message");
        command.setTenantId(session.getTenantId());
        command.setUserId(Long.valueOf(session.getUserId()));
        command.setUsername(session.getUsername());
        command.setPayload(message);
        command.setTarget(level);
        long randomLong = random.nextLong();
        command.setId(Long.valueOf(randomLong < 0L ? randomLong : -randomLong));
        EventEndpoint.distributeMessage(command);
    }

    public void openUrl(Session session, String url, String target) {
        WebsocketMessage command = new WebsocketMessage(session.getSid(), "command");
        command.setCommand("openurl");
        command.setTenantId(session.getTenantId());
        command.setUserId(Long.valueOf(session.getUserId()));
        command.setUsername(session.getUsername());
        command.setPayload(url);
        command.setTarget(StringUtils.isNotEmpty((CharSequence)target) ? target : "_blank");
        long randomLong = random.nextLong();
        command.setId(Long.valueOf(randomLong < 0L ? randomLong : -randomLong));
        EventEndpoint.distributeMessage(command);
    }
}

