/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.util;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualHostHelper {
    private static final int HTTP_PORT_NUMBER = 80;
    private static final int HTTPS_PORT_NUMBER = 443;
    private static final Logger log = LoggerFactory.getLogger(VirtualHostHelper.class);
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String X_FORWARDED_PORT = "x-forwarded-port";
    private static final String VH_HEADER = "logicaldoc-virtual-host";

    private VirtualHostHelper() {
    }

    private static HttpServletRequest getHttpServletRequest(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            return httpRequest;
        }
        return null;
    }

    public static String getWebAppName(ServletRequest request) {
        HttpServletRequest httpRequest = VirtualHostHelper.getHttpServletRequest(request);
        if (httpRequest == null) {
            return "logicaldoc";
        }
        return httpRequest.getContextPath().replace("/", "");
    }

    public static String getServerURL(ServletRequest request) {
        return VirtualHostHelper.getServerURL(request, false);
    }

    private static String getServerURL(String scheme, String serverName, int serverPort) {
        StringBuilder sbaseURL = new StringBuilder();
        sbaseURL.append(scheme);
        sbaseURL.append("://");
        sbaseURL.append(serverName);
        if (serverPort != 0) {
            log.debug("serverPort != 0; serverPort: {}", (Object)serverPort);
            if ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443) {
                sbaseURL.append(':');
                sbaseURL.append(serverPort);
            }
        }
        sbaseURL.append('/');
        return sbaseURL.toString();
    }

    public static String getServerURL(ServletRequest request, boolean local) {
        String baseURL = null;
        HttpServletRequest httpRequest = VirtualHostHelper.getHttpServletRequest(request);
        if (httpRequest != null) {
            baseURL = VirtualHostHelper.getServerUrlFromRequest(local, httpRequest);
        }
        if (baseURL == null) {
            log.warn("Could not retrieve base url correctly");
        }
        return baseURL;
    }

    private static String getServerUrlFromRequest(boolean local, HttpServletRequest httpRequest) {
        String baseURL;
        String logicaldocVH = httpRequest.getHeader(VH_HEADER);
        if (!local && logicaldocVH != null && logicaldocVH.contains("http")) {
            log.debug("logicaldocVH.contains(http)");
            log.debug("logicaldocVH: {}", (Object)logicaldocVH);
            baseURL = logicaldocVH;
        } else {
            String serverName = httpRequest.getServerName();
            int serverPort = httpRequest.getServerPort();
            String scheme = httpRequest.getScheme();
            if (!local) {
                serverPort = VirtualHostHelper.getForwardedPort(httpRequest, serverPort);
                scheme = VirtualHostHelper.getForwardedProtocol(httpRequest, scheme);
                String forwardedHost = httpRequest.getHeader(X_FORWARDED_HOST);
                if (forwardedHost != null) {
                    log.debug("forwardedHost != null");
                    if (forwardedHost.contains(":")) {
                        serverName = forwardedHost.split(":")[0];
                        serverPort = Integer.valueOf(forwardedHost.split(":")[1]);
                        log.debug("forwardedHost contains ':', serverPort: {}", (Object)serverPort);
                    } else {
                        log.debug("forwardedHost NOT contains ':', using fallback");
                        serverName = forwardedHost;
                        serverPort = 80;
                    }
                }
            }
            baseURL = VirtualHostHelper.getServerURL(scheme, serverName, serverPort);
        }
        return baseURL;
    }

    private static String getForwardedProtocol(HttpServletRequest httpRequest, String scheme) {
        String forwardedProto = httpRequest.getHeader(X_FORWARDED_PROTO);
        if (forwardedProto != null) {
            scheme = forwardedProto;
        }
        return scheme;
    }

    private static int getForwardedPort(HttpServletRequest httpRequest, int serverPort) {
        String forwardedPort = httpRequest.getHeader(X_FORWARDED_PORT);
        if (forwardedPort != null) {
            log.info("forwardedPort != null");
            try {
                serverPort = Integer.parseInt(forwardedPort);
                log.debug("forwardedPort != null; serverPort: {}", (Object)serverPort);
            }
            catch (NumberFormatException e) {
                log.error("Unable to get forwarded port from header", e);
            }
        }
        return serverPort;
    }

    public static String getBaseURL(ServletRequest request) {
        String baseURL = null;
        String serverUrl = VirtualHostHelper.getServerURL(request, false);
        if (serverUrl != null) {
            String webAppName = VirtualHostHelper.getWebAppName(request);
            baseURL = StringUtils.isNotBlank(webAppName) ? serverUrl + webAppName + "/" : serverUrl;
        }
        return baseURL;
    }
}

