/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web.util;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.InvalidSessionException;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.MimeType;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.IOUtil;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hsqldb.lib.StringUtil;
import org.jfree.util.Log;

public class ServletUtil {
    private static final String CONTENT_RANGE = "Content-Range";
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final String USER = "user";

    private ServletUtil() {
    }

    public static Session validateSession(HttpServletRequest request) throws InvalidSessionException {
        String sid = SessionManager.get().getSessionId(request);
        return ServletUtil.validateSession(sid);
    }

    public static Session validateSession(String sid) throws InvalidSessionException {
        Session session = SessionManager.get().get(sid);
        if (session == null) {
            throw new InvalidSessionException("Invalid Session " + sid);
        }
        if (!SessionManager.get().isOpen(sid)) {
            throw new InvalidSessionException("Invalid or expired Session " + sid);
        }
        SessionManager.get().renew(sid);
        return session;
    }

    public static User getSessionUser(HttpServletRequest request) throws InvalidSessionException {
        Session session = ServletUtil.validateSession(request);
        User user = (User)session.getDictionary().get(USER);
        ServletUtil.initializeUser(user);
        return user;
    }

    public static User getSessionUser(String sid) throws InvalidSessionException {
        Session session = ServletUtil.validateSession(sid);
        User user = (User)session.getDictionary().get(USER);
        ServletUtil.initializeUser(user);
        return user;
    }

    private static void initializeUser(User user) {
        UserDAO userDao = Context.get(UserDAO.class);
        try {
            userDao.initialize(user);
        }
        catch (PersistenceException e) {
            Log.warn((Object)e.getMessage(), (Exception)e);
        }
    }

    public static Session checkMenu(HttpServletRequest request, long menuId) throws ServletException, InvalidSessionException {
        Session session = ServletUtil.validateSession(request);
        MenuDAO dao = Context.get(MenuDAO.class);
        if (!dao.isReadEnable(menuId, session.getUserId())) {
            String message = "User " + session.getUsername() + " cannot access the menu " + menuId;
            throw new ServletException(message);
        }
        return session;
    }

    public static Session checkEvenOneMenu(HttpServletRequest request, long ... menuIds) throws ServletException, InvalidSessionException {
        Session session = ServletUtil.validateSession(request);
        MenuDAO dao = Context.get(MenuDAO.class);
        long[] lArray = menuIds;
        int n = menuIds.length;
        int n2 = 0;
        while (n2 < n) {
            long menuId = lArray[n2];
            if (dao.isReadEnable(menuId, session.getUserId())) {
                return session;
            }
            ++n2;
        }
        String message = String.format("User %s cannot access the menus %s", session.getUsername(), Arrays.asList(new long[][]{menuIds}));
        throw new ServletException(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void downloadPluginResource(HttpServletRequest request, HttpServletResponse response, String sid, String pluginName, String resourcePath, String fileName) throws IOException, InvalidSessionException {
        if (sid != null) {
            ServletUtil.validateSession(sid);
        } else {
            ServletUtil.validateSession(request);
        }
        String filename = fileName;
        if (filename == null) {
            filename = FileUtil.getName(resourcePath);
        }
        File file = PluginRegistry.getPluginResource(pluginName, resourcePath);
        String mimetype = MimeType.getByFilename(filename);
        response.setContentType(mimetype);
        ServletUtil.setContentDisposition(request, response, filename);
        response.setHeader("Content-Length", Long.toString(file.length()));
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                try (ServletOutputStream os = response.getOutputStream();){
                    int letter = 0;
                    byte[] buffer = new byte[131072];
                    while ((letter = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, letter);
                    }
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void downloadDocument(HttpServletRequest request, HttpServletResponse response, String sid, long docId, String fileVersion, String fileName, String suffix, User user) throws IOException, ServletException, PersistenceException {
        Session session = ServletUtil.getSession(request, sid);
        ServletUtil.initUser(user);
        Document document = ServletUtil.getDocument(docId, user);
        Object filename = ServletUtil.getFilename(fileName, suffix, document);
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(document, fileVersion, null);
        if (!store.exists(document.getId(), resource)) {
            throw new FileNotFoundException(resource);
        }
        if (StringUtils.isNotEmpty(suffix)) {
            resource = store.getResourceName(document, fileVersion, suffix);
            filename = (String)filename + "." + suffix.substring(suffix.lastIndexOf(46) + 1);
        }
        long length = store.size(document.getId(), resource);
        String contentType = MimeType.getByFilename((String)filename);
        long lastModified = document.getDate().getTime();
        String eTag = document.getId() + "_" + document.getVersion() + "_" + lastModified;
        boolean acceptsGzip = false;
        acceptsGzip = ServletUtil.getAcceptEncoding(request, suffix);
        response.setContentType(contentType);
        ServletUtil.setContentDisposition(request, response, (String)filename);
        Range rangeFull = new Range(0L, length - 1L, length);
        List<Range> ranges = ServletUtil.getRanges(request, response, length, lastModified, eTag, rangeFull);
        if (ranges == null) {
            response.sendError(416);
            return;
        }
        response.setBufferSize(10240);
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("ETag", eTag);
        response.setDateHeader("Last-Modified", lastModified);
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
        boolean gstreamRequired = (ranges.isEmpty() || ranges.get(0) == rangeFull || ranges.get((int)0).length == length) && acceptsGzip;
        Throwable throwable = null;
        Object var25_23 = null;
        try (GZIPOutputStream output = gstreamRequired ? new GZIPOutputStream((OutputStream)response.getOutputStream(), 10240) : response.getOutputStream();){
            if (gstreamRequired) {
                response.setHeader("Content-Encoding", "gzip");
                store.writeToStream(docId, resource, output);
            } else if (ranges.size() == 1) {
                Range r = ranges.get(0);
                response.setHeader(CONTENT_RANGE, "bytes " + r.start + "-" + r.end + "/" + r.total);
                if (length == r.length) {
                    response.setStatus(200);
                } else {
                    response.setStatus(206);
                }
                store.writeToStream(docId, resource, output, r.start, r.length);
            } else {
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                response.setStatus(206);
                ServletOutputStream sos = (ServletOutputStream)output;
                for (Range r : ranges) {
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + contentType);
                    sos.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + r.total);
                    store.writeToStream(docId, resource, (OutputStream)sos, r.start, r.length);
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES--");
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ServletUtil.saveHistory(request, sid, suffix, user, session, document, ranges);
    }

    private static void initUser(User user) {
        if (user != null) {
            try {
                ServletUtil.initializeUser(user);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static List<Range> getRanges(HttpServletRequest request, HttpServletResponse response, long length, long lastModified, String eTag, Range rangeFull) {
        String range = request.getHeader("Range");
        if (range == null) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(rangeFull);
            return ranges;
        }
        if (!StringUtils.left(range, 500).matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
            response.setHeader(CONTENT_RANGE, "bytes */" + length);
            return new ArrayList<Range>();
        }
        List<Range> ranges = ServletUtil.getRangesAsSpecifiedInIfRangeHeader(request, lastModified, eTag, rangeFull);
        if (!ranges.isEmpty()) {
            return ranges;
        }
        String[] stringArray = range.substring(6).split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            long start = ServletUtil.sublong(part, 0, part.indexOf("-"));
            long end = ServletUtil.sublong(part, part.indexOf("-") + 1, part.length());
            if (start == -1L) {
                start = length - end;
                end = length - 1L;
            } else if (end == -1L || end > length - 1L) {
                end = length - 1L;
            }
            if (start > end) {
                response.setHeader(CONTENT_RANGE, "bytes */" + length);
                return new ArrayList<Range>();
            }
            ranges.add(new Range(start, end, length));
            ++n2;
        }
        return ranges;
    }

    private static List<Range> getRangesAsSpecifiedInIfRangeHeader(HttpServletRequest request, long lastModified, String eTag, Range rangeFull) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        String ifRange = request.getHeader("If-Range");
        if (ifRange != null && !ifRange.equals(eTag)) {
            try {
                long ifRangeTime = request.getDateHeader("If-Range");
                if (ifRangeTime != -1L && ifRangeTime + 1000L < lastModified) {
                    ranges.add(rangeFull);
                }
            }
            catch (IllegalArgumentException ignore) {
                ranges.add(rangeFull);
            }
        }
        return ranges;
    }

    private static void saveHistory(HttpServletRequest request, String sid, String suffix, User user, Session session, Document document, List<Range> ranges) throws PersistenceException {
        boolean saveHistory = ServletUtil.isSaveHistory(request, suffix, user, ranges);
        if (!saveHistory) {
            return;
        }
        DocumentHistory history = new DocumentHistory();
        history.setDocument(document);
        history.setUser(user);
        if (session != null) {
            history.setSession(session);
        } else {
            history.setSessionId(sid);
        }
        FolderDAO fdao = Context.get(FolderDAO.class);
        history.setPath(fdao.computePathExtended(document.getFolder().getId()));
        if ("preview".equals(request.getParameter("control"))) {
            history.setEvent(DocumentEvent.VIEWED);
        } else {
            history.setEvent(DocumentEvent.DOWNLOADED);
        }
        DocumentHistoryDAO hdao = Context.get(DocumentHistoryDAO.class);
        List<DocumentHistory> oldHistories = hdao.findByUserIdAndEvent(user.getId(), history.getEvent(), session != null ? session.getSid() : sid);
        Calendar cal = Calendar.getInstance();
        cal.setTime(history.getDate());
        cal.add(13, -30);
        Date oldestDate = cal.getTime();
        DocumentHistory latestHistory = null;
        Date latestDate = null;
        if (!oldHistories.isEmpty()) {
            latestHistory = oldHistories.get(oldHistories.size() - 1);
            cal.setTime(latestHistory.getDate());
            latestDate = cal.getTime();
        }
        if (latestHistory == null || oldestDate.getTime() > latestDate.getTime() || !latestHistory.getDocId().equals(history.getDocId())) {
            try {
                hdao.store(history);
            }
            catch (PersistenceException e) {
                Log.warn((Object)e.getMessage(), (Exception)e);
            }
        }
    }

    private static boolean isSaveHistory(HttpServletRequest request, String suffix, User user, List<Range> ranges) {
        boolean saveHistory;
        boolean bl = saveHistory = StringUtils.isEmpty(suffix) || "conversion.pdf".equals(suffix) && "preview".equals(request.getParameter("control"));
        if (!ranges.isEmpty() && saveHistory) {
            saveHistory = false;
            for (Range rng : ranges) {
                if (rng.start != 0L) continue;
                saveHistory = true;
                break;
            }
        }
        saveHistory = saveHistory && user != null;
        return saveHistory;
    }

    private static boolean getAcceptEncoding(HttpServletRequest request, String suffix) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        boolean acceptsGzip = acceptEncoding != null && ServletUtil.accepts(acceptEncoding, "gzip");
        acceptsGzip = acceptsGzip && "true".equals(Context.get().getProperties().getProperty("download.gzip"));
        acceptsGzip = acceptsGzip && (StringUtil.isEmpty((String)suffix) || !"thumb.jpg".endsWith(suffix) && !"tile.jpg".endsWith(suffix));
        return acceptsGzip;
    }

    private static Document getDocument(long docId, User user) throws PersistenceException, FileNotFoundException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        Document doc = (Document)dao.findById(docId);
        if (doc == null || user != null && !user.isMemberOf("admin") && !user.isMemberOf("publisher") && !doc.isPublishing()) {
            throw new FileNotFoundException("Document not published");
        }
        return doc;
    }

    private static String getFilename(String fileName, String suffix, Document doc) {
        String filename = fileName;
        if (filename == null) {
            filename = doc.getFileName();
        }
        if (StringUtils.isNotEmpty(suffix) && !suffix.endsWith(".p7m") && !suffix.endsWith(".m7m")) {
            filename = FileUtil.getBaseName(filename);
        }
        return filename;
    }

    private static Session getSession(HttpServletRequest request, String sid) throws ServletException {
        Session session = null;
        if (sid != null) {
            try {
                session = ServletUtil.validateSession(sid);
            }
            catch (InvalidSessionException e) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            session = ServletUtil.validateSession(request);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void downloadFile(HttpServletRequest request, HttpServletResponse response, File file, String fileName) throws IOException {
        String filename = fileName;
        if (filename == null) {
            filename = file.getName();
        }
        String mimetype = MimeType.getByFilename(filename);
        response.setContentType(mimetype);
        ServletUtil.setContentDisposition(request, response, filename);
        response.setHeader("Content-Length", Long.toString(file.length()));
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 10240);
            try {
                try (ServletOutputStream os = response.getOutputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void setContentDisposition(HttpServletRequest request, HttpServletResponse response, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent").toLowerCase();
        Object encodedFileName = null;
        if (userAgent.contains("msie") || userAgent.contains("opera") || userAgent.contains("trident") && userAgent.contains("windows") || userAgent.contains("edge") && userAgent.contains("windows")) {
            encodedFileName = URLEncoder.encode(filename, StandardCharsets.UTF_8.displayName());
            encodedFileName = ((String)encodedFileName).replace("+", "%20");
        } else {
            encodedFileName = userAgent.contains("safari") && !userAgent.contains("chrome") ? filename : (userAgent.contains("safari") && userAgent.contains("chrome") && userAgent.contains("android") ? filename : "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])filename.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8) + "?=");
        }
        boolean asAttachment = true;
        if (request.getParameter("open") != null) {
            asAttachment = !"true".equals(request.getParameter("open"));
        } else if (request.getAttribute("open") != null) {
            asAttachment = !"true".equals(request.getAttribute("open"));
        }
        response.setHeader("Content-Disposition", (asAttachment ? "attachment" : "inline") + "; filename=\"" + (String)encodedFileName + "\"");
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
    }

    public static void downloadDocumentText(HttpServletRequest request, HttpServletResponse response, long docId, User user) throws IOException, PersistenceException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        DocumentDAO ddao = Context.get(DocumentDAO.class);
        Document doc = (Document)ddao.findById(docId);
        if (doc == null) {
            throw new FileNotFoundException();
        }
        if (doc.getDocRef() != null) {
            doc = (Document)ddao.findById(doc.getDocRef());
        }
        String mimetype = "text/plain";
        response.setContentType(mimetype);
        ServletUtil.setContentDisposition(request, response, doc.getFileName() + ".txt");
        ServletUtil.initializeUser(user);
        if (!(user.isMemberOf("admin") || user.isMemberOf("publisher") || doc.isPublishing())) {
            throw new FileNotFoundException("Document not published");
        }
        SearchEngine indexer = Context.get(SearchEngine.class);
        String content = indexer.getHit(docId).getContent();
        if (content == null) {
            content = "";
        }
        try {
            response.getOutputStream().write(content.getBytes(StandardCharsets.UTF_8));
        }
        finally {
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }

    public static void downloadDocument(HttpServletRequest request, HttpServletResponse response, String sid, long docId, String fileVersion, String fileName, User user) throws IOException, NumberFormatException, ServletException, PersistenceException {
        ServletUtil.downloadDocument(request, response, sid, docId, fileVersion, fileName, null, user);
    }

    public static void uploadDocumentResource(HttpServletRequest request, long docId, String suffix, String fileVersion, String docVersion) throws PersistenceException, IOException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(docId);
        String ver = docVersion;
        if (StringUtils.isEmpty(ver)) {
            ver = fileVersion;
        }
        if (StringUtils.isEmpty(ver)) {
            ver = doc.getFileVersion();
        }
        Store store = Context.get(Store.class);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List<FileItem> fileItems = ServletUtil.getUploadFileItems(request, upload);
        for (FileItem item : fileItems) {
            if (item.isFormField()) continue;
            File savedFile = ServletUtil.writeItemToFile(item);
            try {
                Throwable throwable = null;
                Object var17_17 = null;
                try (InputStream is = item.getInputStream();){
                    store.store(item.getInputStream(), docId, store.getResourceName(doc, ver, suffix));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                FileUtils.forceDelete(savedFile);
            }
        }
    }

    private static File writeItemToFile(FileItem item) throws IOException {
        File savedFile = FileUtil.createTempFile("upload", "");
        IOUtil.write(item.getInputStream(), savedFile);
        return savedFile;
    }

    private static List<FileItem> getUploadFileItems(HttpServletRequest request, ServletFileUpload upload) throws IOException {
        List fileItems;
        try {
            fileItems = upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
        return fileItems;
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = StringUtils.left(acceptHeader, 100).split("\\s*(,;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    public static void sendError(HttpServletResponse response, String message) {
        try {
            response.sendError(500, message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getSelfURLhost(HttpServletRequest request) {
        String hostUrl = "";
        int serverPort = request.getServerPort();
        hostUrl = serverPort == 80 || serverPort == 443 || serverPort == 0 ? String.format("%s://%s", request.getScheme(), request.getServerName()) : String.format("%s://%s:%s", request.getScheme(), request.getServerName(), serverPort);
        return hostUrl;
    }

    public static String getSelfURL(HttpServletRequest request) {
        Object url = ServletUtil.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (requestUri != null && !requestUri.isEmpty()) {
            url = (String)url + requestUri;
        }
        if (queryString != null && !queryString.isEmpty()) {
            url = (String)url + "?" + queryString;
        }
        return url;
    }

    protected static class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

